/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.apns;

import com.adventnet.wms.nioclient.apns.APNSRequest;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class APNSEventDispatcher {
    private static LinkedBlockingQueue queue = new LinkedBlockingQueue();
    private static ThreadPoolExecutor executor;
    private static boolean initialized;

    public static synchronized void initialize(int threadCount) {
        if (initialized) {
            return;
        }
        executor = new ThreadPoolExecutor(threadCount, threadCount, 100L, TimeUnit.MILLISECONDS, queue);
        initialized = true;
    }

    public static void process(APNSRequest request, int eventcode) {
        if (!initialized) {
            APNSEventDispatcher.initialize(2);
        }
        executor.execute(new APNSDispatcher(request, eventcode));
    }

    static {
        initialized = false;
    }

    static class APNSDispatcher
    implements Runnable {
        private APNSRequest request;
        private int eventcode;

        public APNSDispatcher(APNSRequest request, int eventcode) {
            this.request = request;
            this.eventcode = eventcode;
        }

        @Override
        public void run() {
            try {
                this.request.notifyListener(this.eventcode);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

