/*
 * Decompiled with CFR 0.152.
 */
package com.zohocorp.zoho.ztiadapter.util;

import com.zohocorp.zoho.ztiadapter.ConfManager;
import com.zohocorp.zoho.ztiadapter.ZohoHTTPClient;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AuthUtil {
    private static Logger logger = Logger.getLogger(AuthUtil.class.getName());
    private static String zapikey = null;
    private static String orgZuid = null;
    private static long lastlogintime = 0L;

    private static void setOrgZuid() throws Exception {
        orgZuid = null;
        String orgZuidUrl = ConfManager.getNotifyServer() + "/wms/getOrgZuid.do?zdportal=" + ConfManager.getZSPortal() + "&zapikey=" + zapikey + "&scope=" + ConfManager.getScope();
        logger.log(Level.WARNING, "Get getOrgZuid URL : {0}", orgZuidUrl);
        ZohoHTTPClient cli = new ZohoHTTPClient();
        cli.setDiscardCookies(true);
        byte[] response = cli.get(orgZuidUrl);
        if (response != null) {
            orgZuid = new String(response);
            lastlogintime = System.currentTimeMillis();
        }
        if (orgZuid == null) {
            throw new Exception("Unable to get ZUID for the zapikey");
        }
    }

    public static String getOrgZuid() {
        return orgZuid;
    }

    public static String getZAPIKey() {
        return zapikey;
    }

    public static long getLastLoginTime() {
        return lastlogintime;
    }

    public static boolean login() {
        try {
            zapikey = ConfManager.getZAPIKey();
            AuthUtil.setOrgZuid();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while resolving Zoho Identifier for..." + ConfManager.getZAPIKey(), e);
            return false;
        }
    }

    public static void relogin() throws Exception {
        AuthUtil.setOrgZuid();
    }
}

