/*
 * Decompiled with CFR 0.152.
 */
package com.zohocorp.zoho.ztiadapter;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.FixedHashMap;
import com.adventnet.wms.servercommon.taskengine.TaskManager;
import com.zohocorp.zoho.ztiadapter.ConfManager;
import com.zohocorp.zoho.ztiadapter.ZTIAdapter;
import java.io.File;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZohoTeleAdapter {
    private static Logger logger = Logger.getLogger(ZohoTeleAdapter.class.getName());
    public static final Zoho ZOHO = new Zoho();
    public static FixedHashMap notifiedCallMap = new FixedHashMap(50);
    private int checkInterval;
    private boolean active;
    private String protocol;
    private String pbxName;

    public ZohoTeleAdapter(String protocol, Integer interval) {
        this.protocol = protocol;
        this.checkInterval = interval;
        this.pbxName = protocol.replaceAll("[0-9]", "");
    }

    public String getProtocol() {
        return this.protocol;
    }

    protected String getHome() {
        return ConfManager.getAdapterHome() + File.separator + "teleadapters" + File.separator + this.getPbxName();
    }

    private int getHealthCheckInterval() {
        return this.checkInterval;
    }

    public boolean init() {
        return true;
    }

    public boolean init(int monitoringServerIdx) {
        return true;
    }

    public boolean isServiceable() {
        return this.active;
    }

    protected void setServiceable(boolean active) {
        this.active = active;
    }

    protected boolean isLive() {
        return true;
    }

    public boolean restart() {
        return true;
    }

    public boolean makeCall(String fromNumber, String toNumber, Hashtable attachments) {
        return true;
    }

    public boolean endCall(String extn, Hashtable attachments) {
        return true;
    }

    public boolean transferCall(String transferFrom, String transferTo, Hashtable attachments) {
        return true;
    }

    public boolean holdCall(String extn, Hashtable attachments) {
        return true;
    }

    public boolean handleExtnUpdate(Hashtable attachments) {
        return true;
    }

    public String getPbxName() {
        return this.pbxName;
    }

    public void setPbxName(String pbxName) {
        this.pbxName = pbxName;
    }

    public static class Zoho {
        public boolean callReceived(String calluid, String fromNumber, String toNumber, String dateOfCreation) {
            return this.callReceived(calluid, fromNumber, toNumber, dateOfCreation, null, false);
        }

        public boolean callReceived(String calluid, String fromNumber, String toNumber, String dateOfCreation, boolean retry) {
            return this.callReceived(calluid, fromNumber, toNumber, dateOfCreation, null, retry);
        }

        public boolean callReceived(String calluid, String fromNumber, String toNumber, String dateOfCreation, Hashtable attachments) {
            return this.callReceived(calluid, fromNumber, toNumber, dateOfCreation, attachments, false);
        }

        public boolean callReceived(String calluid, String fromNumber, String toNumber, String dateOfCreation, Hashtable attachments, boolean retry) {
            return this.notifyEvent("callreceived", calluid, fromNumber, toNumber, dateOfCreation, attachments, retry);
        }

        public boolean callEnded(String calluid, String oprNumber, String otherNumber, String dateOfCreation, int billablesec) {
            return this.callEnded(calluid, oprNumber, otherNumber, dateOfCreation, billablesec, null, false);
        }

        public boolean callEnded(String calluid, String oprNumber, String otherNumber, String dateOfCreation, int billablesec, boolean retry) {
            return this.callEnded(calluid, oprNumber, otherNumber, dateOfCreation, billablesec, null, retry);
        }

        public boolean callEnded(String calluid, String oprNumber, String otherNumber, String dateOfCreation, int billablesec, Hashtable attachments) {
            return this.callEnded(calluid, oprNumber, otherNumber, dateOfCreation, billablesec, attachments, false);
        }

        public boolean callEnded(String calluid, String fromNumber, String toNumber, String dateOfCreation, int billablesec, Hashtable attachments, boolean retry) {
            return this.notifyEvent("callended", calluid, fromNumber, toNumber, dateOfCreation, billablesec, attachments, retry);
        }

        public boolean callConnected(String calluid, String fromNumber, String toNumber, String dateOfCreation) {
            return this.callConnected(calluid, fromNumber, toNumber, dateOfCreation, null, false);
        }

        public boolean callConnected(String calluid, String fromNumber, String toNumber, String dateOfCreation, boolean retry) {
            return this.callConnected(calluid, fromNumber, toNumber, dateOfCreation, null, retry);
        }

        public boolean callConnected(String calluid, String fromNumber, String toNumber, String dateOfCreation, Hashtable attachments) {
            return this.callConnected(calluid, fromNumber, toNumber, dateOfCreation, attachments, false);
        }

        public boolean callConnected(String calluid, String fromNumber, String toNumber, String dateOfCreation, Hashtable attachments, boolean retry) {
            return this.notifyEvent("callconnected", calluid, fromNumber, toNumber, dateOfCreation, attachments, retry);
        }

        public boolean callInitiated(String fromNumber, String toNumber) {
            return this.callInitiated(fromNumber, toNumber, null, false);
        }

        public boolean callInitiated(String fromNumber, String toNumber, boolean retry) {
            return this.callInitiated(fromNumber, toNumber, null, retry);
        }

        public boolean callInitiated(String fromNumber, String toNumber, Hashtable attachments) {
            return this.callInitiated(fromNumber, toNumber, attachments, false);
        }

        public boolean callInitiated(String fromNumber, String toNumber, Hashtable attachments, boolean retry) {
            Hashtable<String, String> ht = new Hashtable<String, String>();
            ht.put("fromnumber", fromNumber);
            ht.put("tonumber", toNumber);
            WmsEvent event = new WmsEvent();
            event.setOpr("zoho.notify");
            event.putData("ztiopr", (Object)"handlenewcall");
            event.putData("msg", ht);
            event.putData("retry", (Object)("" + retry));
            if (attachments != null) {
                event.putData("attachments", (Object)attachments);
            }
            TaskManager.delegate((WmsEvent)event);
            return true;
        }

        public boolean notifyEvent(Hashtable msgObj) {
            return this.notifyEvent(msgObj, null, false);
        }

        public boolean notifyEvent(Hashtable msgObj, Hashtable attachments) {
            return this.notifyEvent(msgObj, attachments, false);
        }

        public boolean notifyEvent(Hashtable msgObj, Hashtable attachments, boolean retry) {
            WmsEvent event = new WmsEvent();
            event.setOpr("zoho.notify");
            event.putData("ztiopr", (Object)"handleevent");
            event.putData("msg", (Object)msgObj);
            event.putData("retry", (Object)("" + retry));
            if (attachments != null) {
                event.putData("attachments", (Object)attachments);
            }
            TaskManager.delegate((WmsEvent)event);
            return true;
        }

        public boolean notifyEvent(String callstate, String calluid, String fromNumber, String toNumber, String dateOfCreation, Hashtable attachments, boolean retry) {
            return this.notifyEvent(callstate, calluid, fromNumber, toNumber, dateOfCreation, 0, attachments, retry);
        }

        public boolean notifyEvent(String callstate, String calluid, String fromNumber, String toNumber, String dateOfCreation, int billablesec, Hashtable attachments, boolean retry) {
            Hashtable<String, Object> ht = new Hashtable<String, Object>();
            ht.put("fromnumber", fromNumber);
            ht.put("tonumber", toNumber);
            Hashtable calltype = this.decideCallType(fromNumber, toNumber);
            if (calltype == null) {
                logger.log(Level.INFO, "zuid is not available for both from & to numbers. Nothing to do. Omit.");
                return false;
            }
            if (ConfManager.getZSPortal() != null) {
                ht.put("zsportal", ConfManager.getZSPortal());
            }
            if (calluid == null) {
                calluid = this.generateCallUID(fromNumber, dateOfCreation);
                logger.log(Level.INFO, "generated call UID = " + calluid);
            }
            ht.put("callrefid", calluid);
            ht.put("callstate", callstate);
            ht.put("zuid", calltype.get("zuid"));
            ht.put("calltype", calltype.get("calltype"));
            if ("callreceived".equals(callstate)) {
                ht.put("dateofcreation", dateOfCreation);
                String zuidlist = (String)notifiedCallMap.get((Object)calluid);
                if (zuidlist == null) {
                    zuidlist = "";
                }
                zuidlist = zuidlist + calltype.get("zuid") + ",";
                notifiedCallMap.put((Object)calluid, (Object)zuidlist);
            } else if ("callconnected".equals(callstate)) {
                String zuidlist = (String)notifiedCallMap.get((Object)calluid);
                zuidlist = zuidlist != null ? zuidlist.replace(calltype.get("zuid") + ",", "") : "";
                ht.put("closenotify", zuidlist);
            } else if ("callended".equals(callstate)) {
                notifiedCallMap.remove((Object)calluid);
                ht.put("billablesec", billablesec);
            }
            logger.log(Level.INFO, "Notify Event =  " + ht);
            return this.notifyEvent(ht, attachments);
        }

        public String getUserforExtension(String extn) {
            return ZTIAdapter.getUserforExtension(extn);
        }

        public Hashtable getUserExtensions() {
            return ZTIAdapter.getUserExtensions();
        }

        private Hashtable decideCallType(String fromNumber, String toNumber) {
            Hashtable<String, String> ht = new Hashtable<String, String>();
            String fromzuid = this.getUserforExtension(fromNumber);
            String tozuid = this.getUserforExtension(toNumber);
            if (fromzuid != null) {
                if (tozuid != null) {
                    return null;
                }
                ht.put("calltype", "outgoing");
                ht.put("zuid", fromzuid);
                return ht;
            }
            if (tozuid != null) {
                ht.put("calltype", "incoming");
                ht.put("zuid", tozuid);
                return ht;
            }
            return null;
        }

        public String generateCallUID(String fromNumber, String dateOfCreation) {
            String newstr = fromNumber + "_" + dateOfCreation;
            try {
                String pattern = "[-+)(*&^%$#@!~`\"';:/?.>,< ]";
                newstr = newstr.replaceAll(pattern, "");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while ZohoTeleAdapter.generateCallUID ", e);
            }
            return newstr;
        }
    }
}

