/*
 * Decompiled with CFR 0.152.
 */
package com.zohocorp.zoho.ztiadapter;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.taskengine.TaskManager;
import com.zoho.desk.websocket.DMSClient;
import com.zoho.desk.websocket.DMSConstants;
import com.zohocorp.zoho.ztiadapter.ConfManager;
import com.zohocorp.zoho.ztiadapter.TeleAdapterEngine;
import com.zohocorp.zoho.ztiadapter.ZohoHTTPClient;
import com.zohocorp.zoho.ztiadapter.util.AuthUtil;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZTIAdapter {
    private static Logger logger = Logger.getLogger(ZTIAdapter.class.getName());
    private static boolean isServerRunning = false;
    private static Hashtable<String, String> userExtensions = new Hashtable();
    private static String protocol = null;

    public static void initialize(String confPath) {
        try {
            if (ConfManager.initialize(confPath)) {
                if (!TaskManager.initialize()) {
                    logger.severe("Unable to start the ZTIAdapter->TaskManager initialization fails");
                    System.exit(1);
                }
                if (AuthUtil.login()) {
                    if (!ZTIAdapter.verifyLicense()) {
                        logger.severe("License check failed. Contact Zoho Support");
                        System.exit(1);
                    }
                    if (!ZTIAdapter.loadUserExtensions()) {
                        logger.severe("Unable to start the ZTIAdapter->loadUserExtensions fails");
                        System.exit(1);
                    }
                    TeleAdapterEngine.initialize();
                    ZTIAdapter.StartEvent();
                } else {
                    logger.severe(" Unable to login, quiting....");
                    System.exit(1);
                }
            } else {
                logger.severe("Unable to initialize ZTIAdapter quiting.....");
                System.exit(1);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while ZohoTeleAdapter.initialize ", e);
        }
    }

    public static String getUserforExtension(String extn) {
        if (extn != null && userExtensions.containsKey(extn)) {
            return userExtensions.get(extn);
        }
        return null;
    }

    private static boolean verifyLicense() {
        ZohoHTTPClient cli = new ZohoHTTPClient();
        cli.setDiscardCookies(true);
        try {
            Hashtable<String, String> attachments = ConfManager.getLicenseConfigurations();
            Hashtable<String, Object> event = new Hashtable<String, Object>();
            event.put("zuid", AuthUtil.getOrgZuid().split("_")[1]);
            event.put("opr", "verifylicense");
            if (ConfManager.getZSPortal() != null) {
                if (attachments == null) {
                    attachments = new Hashtable<String, String>();
                }
                attachments.put("zsportal", ConfManager.getZSPortal());
            }
            if (attachments != null) {
                event.put("attachments", attachments);
            }
            byte[] response = cli.get(ConfManager.getNotifyServer() + "/wms/newZtilistener.do?event=" + URLEncoder.encode(HttpDataWraper.getString(event), StandardCharsets.UTF_8.toString()) + "&zapikey=" + URLEncoder.encode(AuthUtil.getZAPIKey(), StandardCharsets.UTF_8.toString()));
            return Boolean.parseBoolean(new String(response));
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error while ZohoTeleAdapter.verifyLicense ", ex);
            return false;
        }
    }

    private static boolean loadUserExtensions() {
        ZohoHTTPClient cli = new ZohoHTTPClient();
        cli.setDiscardCookies(true);
        try {
            Hashtable<String, Object> event = new Hashtable<String, Object>();
            event.put("zuid", AuthUtil.getOrgZuid().split("_")[1]);
            event.put("opr", "getextensions");
            if (ConfManager.getZSPortal() != null) {
                Hashtable<String, String> attachments = new Hashtable<String, String>();
                attachments.put("zsportal", ConfManager.getZSPortal());
                event.put("attachments", attachments);
            }
            String getUserExtnURL = ConfManager.getNotifyServer() + "/wms/newZtilistener.do?event=" + URLEncoder.encode(HttpDataWraper.getString(event), StandardCharsets.UTF_8.toString()) + "&zapikey=" + URLEncoder.encode(AuthUtil.getZAPIKey(), StandardCharsets.UTF_8.toString());
            logger.log(Level.WARNING, "userExtensions URL : {0}", getUserExtnURL);
            byte[] response = cli.get(getUserExtnURL);
            Hashtable newUserExtensions = (Hashtable)HttpDataWraper.getObject((String)new String(response));
            ZTIAdapter.updateUserExtnChanges(userExtensions, newUserExtensions);
            userExtensions = newUserExtensions;
            logger.log(Level.WARNING, "userExtensions : {0}", userExtensions);
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error while ZohoTeleAdapter.loadUserExtensions ", ex);
            return false;
        }
    }

    public static Hashtable getUserExtensions() {
        return userExtensions;
    }

    private static void registerDMS() throws Exception {
        DMSConstants.setAgentOrgZuid(AuthUtil.getOrgZuid());
        DMSClient.getInstance().initializeConnectivity();
    }

    public static void handleDMSEvent(Hashtable msg) {
        logger.severe("#msg =======> " + msg);
        try {
            int mtype = Integer.parseInt(msg.get("mtype") + "");
            if (mtype == 650) {
                Hashtable details = (Hashtable)msg.get("msg");
                Hashtable data = (Hashtable)details.get("data");
                protocol = data.get("protocol") + "";
                if ("tele.makecall".equals(details.get("opr"))) {
                    WmsEvent evt = new WmsEvent();
                    evt.setOpr(details.get("opr") + "");
                    evt.putData("msg", (Object)data);
                    evt.putData("protocol", (Object)protocol);
                    evt.putData("attachments", (Object)data);
                    TaskManager.delegate((WmsEvent)evt);
                } else if ("reloadExtensions".equals(details.get("opr"))) {
                    ZTIAdapter.loadUserExtensions();
                }
            }
        }
        catch (Exception exp) {
            logger.log(Level.WARNING, "Error while ZohoTeleAdapter.initialize ", exp);
        }
    }

    private static boolean StartEvent() throws Exception {
        if (!isServerRunning) {
            ZohoEvent newServer = new ZohoEvent();
            newServer.start();
            ZTIAdapter.registerDMS();
            logger.severe("Started serverId " + newServer.serverId);
        }
        return true;
    }

    private static void updateUserExtnChanges(Hashtable<String, String> oldExtnVsZuid, Hashtable<String, String> newExtnVsZuid) {
        logger.log(Level.INFO, "Old Extns List =>{0}", new Object[]{oldExtnVsZuid});
        logger.log(Level.INFO, "New Extns List =>{0}", new Object[]{newExtnVsZuid});
        logger.log(Level.INFO, "protocol =>{0}", new Object[]{protocol});
        if (protocol != null) {
            Hashtable<String, Hashtable<String, String>> modifiedExtnVsZuid = ZTIAdapter.getModifiedExtensions(oldExtnVsZuid, newExtnVsZuid);
            WmsEvent evt = new WmsEvent();
            evt.putData("protocol", (Object)protocol);
            evt.putData("attachments", modifiedExtnVsZuid);
            evt.setOpr("tele.notifyextnupdate");
            TaskManager.delegate((WmsEvent)evt);
        }
    }

    private static Hashtable<String, Hashtable<String, String>> getModifiedExtensions(Hashtable<String, String> old_extns_list, Hashtable<String, String> new_extns_list) {
        Hashtable<String, Hashtable<String, String>> returnTable = new Hashtable<String, Hashtable<String, String>>();
        logger.log(Level.INFO, "Old Extns List =>{0}", new Object[]{old_extns_list});
        logger.log(Level.INFO, "New Extns List =>{0}", new Object[]{new_extns_list});
        HashSet<Map.Entry<String, String>> add_extns_list = new HashSet<Map.Entry<String, String>>(old_extns_list.entrySet());
        HashSet<Map.Entry<String, String>> del_extns_list = new HashSet<Map.Entry<String, String>>(old_extns_list.entrySet());
        add_extns_list.addAll(new_extns_list.entrySet());
        del_extns_list.addAll(new_extns_list.entrySet());
        add_extns_list.removeAll(old_extns_list.entrySet());
        del_extns_list.removeAll(new_extns_list.entrySet());
        Hashtable add_extn_table = new Hashtable();
        Hashtable delete_extn_table = new Hashtable();
        for (Map.Entry entry : add_extns_list) {
            add_extn_table.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : del_extns_list) {
            delete_extn_table.put(entry.getKey(), entry.getValue());
        }
        logger.log(Level.INFO, "Listerners to be added to the extns =>{0} ", new Object[]{add_extn_table});
        logger.log(Level.INFO, "Listerners to be removed to the extns =>{0} ", new Object[]{delete_extn_table});
        returnTable.put("addlist", add_extn_table);
        returnTable.put("deletelist", delete_extn_table);
        return returnTable;
    }

    static class ZohoEvent
    extends Thread {
        int timeout = 30000;
        long serverId = new Date().getTime();

        public ZohoEvent() {
            super("ZohoEvent");
        }

        @Override
        public void run() {
            isServerRunning = Boolean.TRUE;
            while (isServerRunning) {
                logger.severe("Running serverId " + this.serverId);
                try {
                    Thread.sleep(this.timeout);
                    if (System.currentTimeMillis() - AuthUtil.getLastLoginTime() <= 86400000L) continue;
                    logger.info("Relogin...." + System.currentTimeMillis());
                    AuthUtil.relogin();
                    if (ZTIAdapter.verifyLicense()) continue;
                    logger.severe("License check failed. Contact Zoho Support");
                    System.exit(1);
                }
                catch (Exception e) {
                    logger.severe("Unable to relogin. Please check the zapikey. Contact Zoho Support");
                    System.exit(1);
                }
            }
            isServerRunning = Boolean.FALSE;
        }
    }
}

