/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.websocket;

import com.zoho.desk.websocket.DMSConstants;
import com.zoho.desk.websocket.DMSStatusHandler;
import com.zohocorp.zoho.ztiadapter.ConfManager;
import com.zohocorp.zoho.ztiadapter.ZohoHTTPClient;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class DMSDomainHandler
extends DMSStatusHandler {
    private static final Logger LOGGER = Logger.getLogger(DMSDomainHandler.class.getName());
    private static DMSDomainHandler dmsDomainHandler;

    public DMSDomainHandler() {
        try {
            DMSDomainHandler.updateLatestDMSDomains();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to update Latest DMS Domains", e);
        }
    }

    public static DMSDomainHandler getInstance() {
        if (dmsDomainHandler == null) {
            dmsDomainHandler = new DMSDomainHandler();
        }
        return dmsDomainHandler;
    }

    public void connectToPrimaryDomain() throws Exception {
        this.setDmsDomain("primarydc");
        LOGGER.log(Level.INFO, "connected PrimaryDomain {0}", DMSConstants.getDmsServer());
    }

    public void connectToSecondaryDomain() throws Exception {
        this.setDmsDomain("secondarydc");
        LOGGER.log(Level.INFO, "connected SecondaryDomain {0}", DMSConstants.getDmsServer());
    }

    void setDmsDomain(String domainDc) throws Exception {
        JSONArray dmsDomain = DMSConstants.getDmsDomains();
        LOGGER.log(Level.INFO, "DMS Domains {0}", DMSConstants.getDmsDomains());
        for (int i = 0; i < dmsDomain.length(); ++i) {
            JSONObject domainObject = (JSONObject)dmsDomain.get(i);
            String domainKey = domainObject.getString(domainDc);
            DMSConstants.setDmsSERVER(domainObject.getString(domainKey));
            LOGGER.log(Level.INFO, "DMS Server {0}", DMSConstants.getDmsServer());
        }
    }

    void changeDC() throws Exception {
        if (DMSConstants.getDmsDomains() != null) {
            LOGGER.log(Level.INFO, "Change DC Action is called");
            if (DMSDomainHandler.isPrimaryDC() && DMSDomainHandler.getPrimaryDCRetryCount() < 4 || !DMSDomainHandler.isPrimaryDC()) {
                LOGGER.log(Level.INFO, "Connecting to primary DC.");
                DMSDomainHandler.setPrimaryDC(true);
                this.connectToPrimaryDomain();
                DMSDomainHandler.setPrimaryDCRetryCount(DMSDomainHandler.getPrimaryDCRetryCount() + 1);
            } else {
                LOGGER.log(Level.INFO, "Connecting to primary DC.");
                DMSDomainHandler.setPrimaryDC(false);
                this.connectToSecondaryDomain();
            }
        }
    }

    private static void updateLatestDMSDomains() throws Exception {
        DMSConstants.setDmsDomains(DMSDomainHandler.getLatestDMSDomains());
        LOGGER.log(Level.INFO, "DMS Server Details - {0}", DMSConstants.getDmsDomains());
    }

    private static JSONArray getLatestDMSDomains() throws Exception {
        JSONArray dmsDomains = null;
        String url = ConfManager.getNotifyServer() + "/wms/getDMSDomain.do?zapikey=" + ConfManager.getZAPIKey() + "&scope=" + ConfManager.getScope();
        try {
            ZohoHTTPClient cli = new ZohoHTTPClient();
            cli.setDiscardCookies(true);
            byte[] response = cli.get(url);
            if (response != null) {
                JSONObject resp = new JSONObject(new String(response));
                dmsDomains = resp.getJSONArray("domains");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, " getDMSDomain URL : {0}", url);
            throw new Exception("Unable to get LatestDMSDomains");
        }
        return dmsDomains;
    }
}

