/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.websocket;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.nioclient.SSLManager;
import com.adventnet.wms.nioclient.http.EventDispatcher;
import com.adventnet.wms.nioclient.http.HttpRequestEventListener;
import com.adventnet.wms.nioclient.http.NIONetDataProcessor;
import com.adventnet.wms.nioclient.http.SelectorPoolFactory;
import com.adventnet.wms.nioclient.websocket.WebSocketRequest;
import com.zoho.desk.websocket.DMSConstants;
import com.zoho.desk.websocket.DMSDomainHandler;
import com.zoho.desk.websocket.DMSEventHandler;
import com.zoho.desk.websocket.DMSReconnect;
import com.zoho.desk.websocket.DMSStatusHandler;
import com.zohocorp.zoho.ztiadapter.ConfManager;
import com.zohocorp.zoho.ztiadapter.ZTIAdapter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DMSClient
extends DMSStatusHandler {
    private static final Logger LOGGER = Logger.getLogger(DMSClient.class.getName());
    private WebSocketRequest request = null;
    private String uid = null;
    private String sid = null;
    private static volatile DMSClient dmsClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DMSClient getInstance() throws Exception {
        if (dmsClient != null) return dmsClient;
        Class<DMSClient> clazz = DMSClient.class;
        synchronized (DMSClient.class) {
            if (dmsClient != null) return dmsClient;
            dmsClient = new DMSClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dmsClient;
        }
    }

    private DMSClient() throws Exception {
        DMSStatusHandler.setCreateNewSession(false);
        if (DMSConstants.getDmsDomains() == null) {
            DMSDomainHandler.getInstance().connectToPrimaryDomain();
            this.resetStatusOnSuccess();
        }
        SelectorPoolFactory.init((int)443, (int)2);
        SelectorPoolFactory.init((int)80, (int)2, (int)0, (int)1);
        NIONetDataProcessor.initialize((int)2, (int)2);
        EventDispatcher.initialize((int)2);
        SSLManager.setJREHome((String)System.getProperty("java.home"));
        SSLManager.setValidDomains((String)this.getDmsDomainsList());
        LOGGER.log(Level.INFO, "SETTING VALID DOMAINS {0}", this.getDmsDomainsList());
        SSLManager.initializeClientManager();
        LOGGER.log(Level.INFO, "CONNECTIVITY THREADS INITIALIZED IN CONSTRUCTOR");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeConnectivity() {
        try {
            DMSClient dMSClient = this;
            synchronized (dMSClient) {
                if (this.sid == null) {
                    LOGGER.log(Level.INFO, "INITIALIZE CONNECTIVITY");
                    DMSEventHandler impl = new DMSEventHandler();
                    this.request = new WebSocketRequest(this.getDMS_WSS_URL(), 443, (HttpRequestEventListener)impl);
                    this.request.invokePingFrame(true);
                    this.request.setNotifyEmptyFrame(true);
                    this.request.setPingInterval(25);
                    this.request.setRequestURI("/wsconnect");
                    if (ConfManager.isProxyEnabled()) {
                        this.request.setProxy(ConfManager.getProxyHost(), Integer.parseInt(ConfManager.getProxyPort()), ConfManager.getProxyUserName(), ConfManager.getProxyPasswd());
                    }
                    this.request.addParam("zuid", DMSConstants.getAgentOrgZuid());
                    this.request.addParam("prd", ConfManager.getPrd());
                    this.request.addParam("config", "16");
                    this.request.addParam("authtype", "6");
                    this.request.addParam("key", ConfManager.getZAPIKey());
                    this.request.setConnectExpireTime(1500L);
                    this.request.connect();
                } else {
                    this.reinitializeConnectivity();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "initializeConnectivity - ERROR OCCURED {0}", ex);
            DMSClient.handleDisconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitializeConnectivity() {
        try {
            DMSClient dMSClient = this;
            synchronized (dMSClient) {
                LOGGER.log(Level.INFO, " REINITIALIZE CONNECTIVITY");
                DMSEventHandler impl = new DMSEventHandler();
                this.request = new WebSocketRequest(this.getDMS_WSS_URL(), 443, (HttpRequestEventListener)impl);
                this.request.invokePingFrame(true);
                this.request.setNotifyEmptyFrame(true);
                this.request.setPingInterval(25);
                if (ConfManager.isProxyEnabled()) {
                    this.request.setProxy(ConfManager.getProxyHost(), Integer.parseInt(ConfManager.getProxyPort()), ConfManager.getProxyUserName(), ConfManager.getProxyPasswd());
                }
                this.request.setRequestURI("/wsconnect");
                this.request.addParam("c", this.uid);
                this.request.addParam("i", this.sid);
                this.request.addParam("key", ConfManager.getZAPIKey());
                this.request.connect();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "reinitializeConnectivity - ERROR OCCURED {0}", ex);
            DMSClient.handleDisconnect();
        }
    }

    private void StopConnectivity() {
        if (!this.request.isClosed()) {
            this.request.close();
        }
    }

    private String getDMS_WSS_URL() {
        return "wss://" + DMSConstants.getDmsServer();
    }

    public void handleResponse(String response) {
        try {
            if (response.isEmpty()) {
                this.handlePongResponse();
            } else {
                ArrayList al = (ArrayList)HttpDataWraper.getObject((String)response);
                for (Hashtable msg : al) {
                    int mtype;
                    if (msg.get("seq") != null) {
                        String data = "{\"s\":\"" + (String)msg.get("seq") + "\"}";
                        LOGGER.log(Level.INFO, "Ack: {0}", data);
                        this.request.write(data);
                    }
                    if ((mtype = Integer.parseInt("" + msg.get("mtype"))) == DMSStatusHandler.MType.ACKNOWLEDGEMENT.value) {
                        Hashtable details = (Hashtable)msg.get("msg");
                        this.uid = (String)details.get("uid");
                        this.sid = (String)details.get("sid");
                        DMSStatusHandler.setRetryTime(0);
                        this.resetStatusOnSuccess();
                        continue;
                    }
                    if (mtype == DMSStatusHandler.MType.EMPTY_KEY.value || mtype == DMSStatusHandler.MType.AUTH_FAIL.value) {
                        LOGGER.log(Level.WARNING, "MTYPE: {0} - Wms Authentication failure/Unauthorized user.", mtype);
                        DMSClient.setAgentState(DMSStatusHandler.AgentStatus.AUTH_FAILED.ordinal());
                        System.exit(1);
                        continue;
                    }
                    if (mtype == DMSStatusHandler.MType.DCSWITCH_RECONNECT.value || mtype == DMSStatusHandler.MType.SESSION_CLOSE.value) {
                        if (mtype == DMSStatusHandler.MType.DCSWITCH_RECONNECT.value) {
                            LOGGER.log(Level.WARNING, "MTYPE: {0} - Re-Connect DC Switch", mtype);
                        } else {
                            LOGGER.log(Level.WARNING, "MTYPE: {0} - Web socket session closed", mtype);
                        }
                        DMSConstants.setDmsDomains(String.valueOf(al));
                        DMSDomainHandler.getInstance().connectToPrimaryDomain();
                        DMSStatusHandler.setCreateNewSession(true);
                        dmsClient = null;
                        continue;
                    }
                    if (mtype == DMSStatusHandler.MType.DOS_BLOCK.value) {
                        String blockType = (String)msg.get("b");
                        if (blockType.equals("temporary")) {
                            LOGGER.log(Level.WARNING, "MTYPE: {0} - Wms DOS block temporary. Retrying after 1 min.", mtype);
                            DMSClient.setAgentState(DMSStatusHandler.AgentStatus.DOS_TEMP.ordinal());
                            continue;
                        }
                        LOGGER.log(Level.WARNING, "MTYPE: {0} - Wms DOS block Permanaent.", mtype);
                        DMSClient.setAgentState(DMSStatusHandler.AgentStatus.DOS_PERM.ordinal());
                        continue;
                    }
                    if (mtype == DMSStatusHandler.MType.SERVICE_DOWN.value) {
                        DMSClient.setAgentState(DMSStatusHandler.AgentStatus.SERVICE_DOWN.ordinal());
                        LOGGER.log(Level.WARNING, "MTYPE: {0} - Service Down. Retrying after 5 min", mtype);
                        continue;
                    }
                    DMSClient.setAgentState(DMSStatusHandler.AgentStatus.ACTIVE.ordinal());
                    ZTIAdapter.handleDMSEvent(msg);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "handleResponse - ERROR OCCURED {0}", e);
        }
    }

    public static void handleDisconnect() {
        try {
            DMSClient.handleReconnect(true);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "handleDisconnect - ERROR OCCURED {0}", e);
        }
    }

    public static void handleDisconnectWithOutDelay() {
        try {
            DMSClient.handleReconnect(false);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "handleDisconnectWithOutDelay - ERROR OCCURED {0}", e);
        }
    }

    private static void handleReconnect(final boolean delay) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                LOGGER.log(Level.INFO, "RECONNECT - STOP THE WMSWORKER");
                try {
                    DMSClient.getInstance().StopConnectivity();
                    if (delay) {
                        Thread.sleep(30000L);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "handleReconnect - Exception in Stop Connectivity error {0}", e);
                }
                LOGGER.log(Level.INFO, "RECONNECT - WMSWORKER STOPPED");
                LOGGER.log(Level.INFO, "RE-REGISTER");
                try {
                    DMSClient.getInstance().initializeConnectivity();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "RE-REGISTERATION FAILED");
                    LOGGER.log(Level.WARNING, "handleReconnect - Exception in Initialize connectivity error {0}", e);
                }
                LOGGER.log(Level.INFO, "RECONNECT - thread ended");
            }
        });
        thread.start();
    }

    private String getDmsDomainsList() throws JSONException {
        JSONArray dmsDomain = DMSConstants.getDmsDomains();
        String proxyHost = ConfManager.isProxyEnabled() ? "," + ConfManager.getProxyHost() : "";
        ArrayList<String> domainList = new ArrayList<String>();
        for (int i = 0; i < dmsDomain.length(); ++i) {
            JSONObject domainObject = (JSONObject)dmsDomain.get(i);
            domainList.add(domainObject.getString(domainObject.getString("primarydc")) + proxyHost);
            domainList.add(domainObject.getString(domainObject.getString("secondarydc")) + proxyHost);
        }
        return String.join((CharSequence)",", domainList);
    }

    public void shutDownAgentInFailure() {
        LOGGER.log(Level.WARNING, "shutDownAgentInFailure - Failure status has been updated. Shutdown access initiated.");
        System.exit(0);
    }

    private void resetStatusOnSuccess() {
        DMSStatusHandler.setPrimaryDCRetryCount(0);
        DMSStatusHandler.setCreateNewSession(false);
        DMSClient.setAgentState(DMSStatusHandler.AgentStatus.ACTIVE.ordinal());
        DMSClient.setPrimaryDC(true);
    }

    void handlePongResponse() throws Exception {
        DMSClient.setPingTime(0L);
        DMSClient.setDmsConnected(true);
        Thread.sleep(10000L);
        if (DMSReconnect.getDmsReconnect() == null) {
            LOGGER.log(Level.INFO, "STARTING - RECONNECT THREAD");
            DMSReconnect.getInstance().execute();
        }
    }
}

