/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.managerAPI;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.pbx.AgiChannelActivityAction;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.ListenerPriority;
import org.asteriskjava.pbx.NewChannelListener;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.asterisk.wrap.events.HangupEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.managerAPI.EventListenerBaseClass;
import org.asteriskjava.pbx.internal.managerAPI.OriginateResult;
import org.asteriskjava.pbx.internal.managerAPI.OriginateToExtension;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class DialToAgi
extends EventListenerBaseClass {
    private static final Log logger = LogFactory.getLog(DialToAgi.class);
    private final OriginateResult[] result = new OriginateResult[2];
    private volatile boolean hangupDetected = false;
    private OriginateToExtension originator;

    public DialToAgi(String descriptiveName) {
        super(descriptiveName, PBXFactory.getActivePBX());
    }

    /*
     * Loose catch block
     */
    public OriginateResult[] dial(NewChannelListener listener, EndPoint localHandset, AgiChannelActivityAction action, CallerID callerID, Integer timeout, boolean hideCallerId, Map<String, String> channelVarsToSet) throws PBXException, InterruptedException {
        PBX pbx = PBXFactory.getActivePBX();
        try {
            try (OriginateToExtension originate = new OriginateToExtension(listener);){
                OriginateResult trcResult;
                this.startListener();
                this.originator = originate;
                this.result[0] = trcResult = originate.originate(localHandset, pbx.getExtensionAgi(), true, ((AsteriskPBX)pbx).getManagementContext(), callerID, timeout, hideCallerId, channelVarsToSet);
                if (trcResult.isSuccess()) {
                    if (trcResult.getChannel() != null) {
                        trcResult.getChannel().setCurrentActivityAction(action);
                        if (trcResult.getChannel().waitForChannelToReachAgi(30L, TimeUnit.SECONDS)) {
                            logger.info("Call reached AGI");
                        } else {
                            logger.error("Call never reached agi");
                        }
                    } else {
                        logger.error("Call never reached agi");
                    }
                } else {
                    logger.warn("Originate failed: " + trcResult.getAbortReason());
                }
                logger.info("Hangup status is " + this.hangupDetected);
                OriginateResult[] originateResultArray = this.result;
                return originateResultArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.close();
        }
    }

    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        required.add(HangupEvent.class);
        return required;
    }

    @Override
    public void onManagerEvent(ManagerEvent event) {
        if (event instanceof HangupEvent) {
            HangupEvent hangup = (HangupEvent)event;
            Channel hangupChannel = hangup.getChannel();
            if (logger.isDebugEnabled()) {
                logger.debug("hangup :" + hangupChannel);
                logger.debug("channel 0:" + this.result[0]);
                logger.debug("channel 1:" + this.result[1]);
            }
            if (this.result[0] != null && this.result[0].isSuccess() && hangupChannel.isSame(this.result[0].getChannel())) {
                this.hangupDetected = true;
            }
        }
    }

    @Override
    public ListenerPriority getPriority() {
        return ListenerPriority.NORMAL;
    }

    public void abort() {
        this.originator.abort("user abort");
    }
}

