/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.websocket;

import com.adventnet.wms.common.Base64;
import com.adventnet.wms.common.exception.WMSCommunicationException;
import com.adventnet.wms.common.websocket.WebSocket;
import com.adventnet.wms.common.websocket.WebSocketHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.net.ssl.SSLContext;

public class WebSocketV13
extends WebSocket {
    private static final Logger logger = Logger.getLogger(WebSocketV13.class.getName());
    private URI uri = null;
    private WebSocketHandler callbackHandler;
    private CharBuffer headerBuffer = CharBuffer.allocate(1024);
    private String cookie = null;
    private String host = null;
    private int port = -1;
    private boolean isSSL = false;
    private int conStatus = 0;
    private Socket socket = null;
    private InputStream in = null;
    private OutputStream out = null;
    private ReadThread readThread;
    private WriteThread writeThread;
    private CallbackThread callbackThread;
    private LinkedBlockingQueue<WriteFrame> writeQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<CallbackEvent> callbackQueue = new LinkedBlockingQueue();
    private Random random = new Random(System.currentTimeMillis());
    private static String NEWLINE = "\r\n";
    private static int VERSION = 13;
    private static long PING_INTERVAL = 15L;
    private boolean closed = false;
    private boolean offerCompression = false;
    private boolean isCompressionEnabled = false;
    private Inflater inflater;
    private Deflater deflater;

    public WebSocketV13(String url, boolean offerCompression) throws WMSCommunicationException {
        try {
            this.offerCompression = offerCompression;
            this.uri = new URI(url);
            if (!this.uri.getScheme().equals("ws") && !this.uri.getScheme().equals("wss")) {
                throw new WMSCommunicationException("Invalid url");
            }
            this.isSSL = this.uri.getScheme().equals("wss");
            this.port = this.uri.getPort();
            if (this.port == -1) {
                this.port = this.isSSL ? 443 : 80;
            }
            this.host = this.uri.getHost();
            logger.info("GS --> new websocket uri=" + this.uri);
        }
        catch (URISyntaxException use) {
            throw new WMSCommunicationException("Invalid Url");
        }
        catch (Exception e) {
            throw new WMSCommunicationException("Exception : " + e.getMessage());
        }
    }

    @Override
    public void setHandler(WebSocketHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public void addCookie(String key, String value) {
        this.cookie = this.cookie != null ? this.cookie + "; " + key + "=" + value : key + "=" + value;
    }

    @Override
    public void connect() throws WMSCommunicationException {
        if (this.conStatus != 0) {
            return;
        }
        if (this.callbackHandler == null) {
            throw new WMSCommunicationException("WebSocket Handler not found");
        }
        if (this.host == null) {
            throw new WMSCommunicationException("Invalid host " + this.host);
        }
        if (this.port < 0) {
            throw new WMSCommunicationException("Invalid port " + this.port);
        }
        this.readThread = new ReadThread();
        this.readThread.start();
        this.callbackThread = new CallbackThread();
        this.callbackThread.start();
    }

    public boolean isOpen() {
        return this.conStatus == 1;
    }

    private boolean isHold() {
        return this.conStatus == 2;
    }

    @Override
    public boolean write(String msg) throws WMSCommunicationException {
        if (this.closed) {
            throw new WMSCommunicationException("WebSocket closed");
        }
        try {
            this.writeQueue.put(new WriteFrame(1, msg));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean writeBinary(byte[] msg) throws WMSCommunicationException {
        if (this.closed) {
            throw new WMSCommunicationException("WebSocket closed");
        }
        try {
            this.writeQueue.put(new WriteFrame(2, msg));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void hold() {
        if (this.isOpen()) {
            try {
                this.conStatus = 2;
                this.writeQueue.put(new WriteFrame(1, "."));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void resume() {
        if (this.isHold()) {
            try {
                this.conStatus = 1;
                this.writeQueue.put(new WriteFrame(1, ","));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        try {
            this.writeQueue.put(new WriteFrame(8, ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doConnect() throws WMSCommunicationException {
        try {
            if (this.isSSL) {
                SSLContext sslCtx = SSLContext.getInstance("TLS");
                sslCtx.init(null, null, null);
                this.socket = sslCtx.getSocketFactory().createSocket(this.host, this.port);
            } else {
                this.socket = new Socket(this.host, this.port);
            }
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }
        catch (UnknownHostException uhe) {
            throw new WMSCommunicationException("Invalid Host : " + uhe);
        }
        catch (IOException ioe) {
            throw new WMSCommunicationException("IO Exception : " + ioe);
        }
        catch (SecurityException se) {
            throw new WMSCommunicationException("Secruity Exception : " + se);
        }
        catch (Exception e) {
            throw new WMSCommunicationException("Exception : " + e.getMessage());
        }
    }

    private void doHandshake() throws WMSCommunicationException {
        try {
            ArrayList<String> responseHeader;
            block23: {
                this.headerBuffer.clear();
                String path = this.uri.getPath();
                if (path == null) {
                    path = "/";
                } else if (this.uri.getQuery() != null) {
                    path = path + "?" + this.uri.getRawQuery();
                }
                this.headerBuffer.put("GET " + path + " HTTP/1.1" + NEWLINE);
                this.appendHeaderValue("Host", this.host);
                this.appendHeaderValue("Upgrade", "websocket");
                this.appendHeaderValue("Connection", "Upgrade");
                this.appendHeaderValue("Sec-WebSocket-Version", "" + VERSION);
                this.appendHeaderValue("Sec-WebSocket-Key", Base64.encodeByte(this.getRandomBytes(16)));
                if (this.offerCompression) {
                    this.appendHeaderValue("sec-websocket-extensions", "permessage-deflate");
                }
                Enumeration en = this.headers.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    this.appendHeaderValue(key, (String)this.headers.get(key));
                }
                if (this.cookie != null) {
                    this.appendHeaderValue("Cookie", this.cookie);
                }
                this.headerBuffer.put(NEWLINE);
                this.headerBuffer.flip();
                this.writeBytes(this.headerBuffer.toString().getBytes("UTF-8"));
                int maxLen = 1024;
                byte[] buffer = new byte[maxLen];
                int pos = 0;
                responseHeader = new ArrayList<String>();
                do {
                    byte b = this.readByte();
                    buffer[pos] = b;
                    if (buffer[++pos - 1] == 10 && buffer[pos - 2] == 13) {
                        String line = new String(buffer, "UTF-8");
                        if (line.trim().equals("")) break block23;
                        responseHeader.add(line.trim());
                        buffer = new byte[maxLen];
                        pos = 0;
                    }
                    if (pos < 1020) continue;
                    throw new WMSCommunicationException("Header too long : " + new String(buffer, "UTF-8"));
                } while (responseHeader.size() <= 10);
                throw new WMSCommunicationException("Too many headers : " + responseHeader);
            }
            if (responseHeader.size() == 0) {
                throw new WMSCommunicationException("Insuffcient response header");
            }
            try {
                int responseStatusCode = Integer.parseInt(((String)responseHeader.remove(0)).substring(9, 12));
                if (responseStatusCode != 101) {
                    throw new WMSCommunicationException("Invalid status code : " + responseStatusCode);
                }
            }
            catch (WMSCommunicationException wce1) {
                throw wce1;
            }
            catch (Exception e1) {
                throw new WMSCommunicationException("Invalid Status message in response");
            }
            try {
                HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
                for (String line : responseHeader) {
                    String[] keyValue = line.split(": ", 2);
                    responseHeaderMap.put(keyValue[0], keyValue[1]);
                }
                if (!((String)responseHeaderMap.get("Upgrade")).toLowerCase().equals("websocket") || !((String)responseHeaderMap.get("Connection")).toLowerCase().equals("upgrade")) {
                    throw new WMSCommunicationException("Headers on upgrade not found");
                }
                if (responseHeaderMap.get("Sec-Websocket-Extensions") != null && ((String)responseHeaderMap.get("Sec-Websocket-Extensions")).trim().equals("permessage-deflate")) {
                    this.isCompressionEnabled = true;
                    this.inflater = new Inflater(true);
                    this.deflater = new Deflater(9, true);
                }
            }
            catch (WMSCommunicationException wce2) {
                throw wce2;
            }
            catch (Exception e2) {
                throw new WMSCommunicationException("Unable to verify response header : " + e2.getMessage());
            }
        }
        catch (WMSCommunicationException wce) {
            throw wce;
        }
        catch (IOException ioe) {
            throw new WMSCommunicationException("IOException : " + ioe.getMessage());
        }
        catch (Exception e) {
            throw new WMSCommunicationException("Exception doHandshake : " + e.getMessage());
        }
    }

    private void appendHeaderValue(String name, String value) {
        this.headerBuffer.put(name);
        this.headerBuffer.put(": ");
        this.headerBuffer.put(value);
        this.headerBuffer.put(NEWLINE);
    }

    private synchronized void handleClose() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.readThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.callbackThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.callbackThread.flush();
        try {
            this.writeThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.callbackHandler.onClose(this.conStatus);
        }
        catch (Exception exception) {
        }
        finally {
            this.writeQueue = null;
            this.callbackQueue = null;
            this.callbackHandler = null;
            this.readThread = null;
            this.writeThread = null;
        }
    }

    private byte readByte() throws WMSCommunicationException {
        try {
            byte[] data = new byte[1];
            if (this.in.read(data) == -1) {
                throw new WMSCommunicationException("Stream Closed");
            }
            return data[0];
        }
        catch (IOException ioe) {
            throw new WMSCommunicationException("IOException on read");
        }
        catch (WMSCommunicationException wce) {
            throw wce;
        }
    }

    private void writeBytes(byte[] data) throws WMSCommunicationException {
        try {
            this.out.write(data);
            this.out.flush();
        }
        catch (IOException ioe) {
            throw new WMSCommunicationException("IOException on write");
        }
    }

    private byte[] inflate(byte[] data) throws IOException, DataFormatException {
        int count;
        ByteBuffer bb = ByteBuffer.allocate(data.length + 4);
        bb.put(data);
        bb.put(new byte[]{0, 0, -1, -1});
        data = bb.array();
        this.inflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[1024];
        while ((count = this.inflater.inflate(buffer, 0, buffer.length)) > 0) {
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        return output;
    }

    private byte[] deflate(byte[] data) throws IOException {
        int count;
        this.deflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[1024];
        while ((count = this.deflater.deflate(buffer, 0, buffer.length, 2)) > 0) {
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        ByteBuffer bb = ByteBuffer.allocate(output.length - 4);
        bb.put(output, 0, output.length - 4);
        output = bb.array();
        return output;
    }

    private byte[] getRandomBytes(int len) {
        byte[] rb = new byte[len];
        this.random.nextBytes(rb);
        return rb;
    }

    static class Status {
        public static final int HOLD = 2;
        public static final int CONNECTED = 1;
        public static final int NOT_CONNECTED = 0;
        public static final int CLOSED = -1;
        public static final int ABORTED = -2;
        public static final int ERROR = -3;

        Status() {
        }
    }

    static class OPCode {
        public static final int CONTINUATION = 0;
        public static final int TEXT = 1;
        public static final int BINARY = 2;
        public static final int CLOSE = 8;
        public static final int PING = 9;
        public static final int PONG = 10;

        OPCode() {
        }
    }

    class WriteFrame {
        private byte opcode;
        private byte[] data;

        public WriteFrame(int opcode, String strData) throws WMSCommunicationException {
            this(opcode, strData, true);
        }

        public WriteFrame(int opcode, byte[] data) throws WMSCommunicationException {
            this(opcode, data, true);
        }

        public WriteFrame(int opcode, String strData, boolean mask) throws WMSCommunicationException {
            try {
                this.opcode = (byte)opcode;
                this.data = this.prepareFrame(strData.getBytes("UTF-8"), mask);
            }
            catch (WMSCommunicationException wce) {
                throw wce;
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Unable to prepare write frame : " + e.getMessage());
            }
        }

        public WriteFrame(int opcode, byte[] data, boolean mask) throws WMSCommunicationException {
            try {
                this.opcode = (byte)opcode;
                this.data = this.prepareFrame(data, mask);
            }
            catch (WMSCommunicationException wce) {
                throw wce;
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Unable to prepare write frame : " + e.getMessage());
            }
        }

        public byte[] getBytes() {
            return this.data;
        }

        private byte[] prepareFrame(byte[] rawData, boolean mask) throws WMSCommunicationException {
            try {
                byte[] b;
                ByteArrayOutputStream wf = new ByteArrayOutputStream(rawData.length + 10);
                if (WebSocketV13.this.isCompressionEnabled) {
                    wf.write((byte)(0xC0 | this.opcode));
                    rawData = rawData.length == 0 ? rawData : WebSocketV13.this.deflate(rawData);
                } else {
                    wf.write((byte)(0x80 | this.opcode));
                }
                int length = rawData.length;
                int lf = 0;
                if (length < 126) {
                    lf = length;
                    lf = mask ? 0x80 | lf : lf;
                    wf.write((byte)lf);
                } else if (length <= 65535) {
                    lf = 126;
                    lf = mask ? 0x80 | lf : lf;
                    wf.write((byte)lf);
                    b = new byte[]{(byte)(length >>> 8), (byte)(length & 0xFF)};
                    wf.write(b);
                } else if (length > 65535) {
                    lf = 127;
                    lf = mask ? 0x80 | lf : lf;
                    wf.write((byte)lf);
                    b = new byte[]{(byte)(length >>> 56), (byte)(length >>> 48), (byte)(length >>> 40), (byte)(length >>> 32), (byte)(length >>> 24), (byte)(length >>> 16), (byte)(length >>> 8), (byte)length};
                    wf.write(b);
                }
                if (mask) {
                    byte[] maskValue = WebSocketV13.this.getRandomBytes(4);
                    wf.write(maskValue);
                    for (int i = 0; i < rawData.length; ++i) {
                        int n = i;
                        rawData[n] = (byte)(rawData[n] ^ maskValue[i % 4]);
                    }
                }
                wf.write(rawData);
                return wf.toByteArray();
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Unable to prepare write frame : " + e.getMessage());
            }
        }

        public boolean isCloseFrame() {
            return this.opcode == 8;
        }
    }

    class ReadFrame {
        private byte[] data;
        private int payloadSize = -1;
        private ByteArrayOutputStream baos;
        private int opcode = 0;
        private boolean finSet = true;
        private boolean isFrameCompressed = false;

        ReadFrame() {
        }

        public int readFully() throws WMSCommunicationException {
            try {
                byte header = WebSocketV13.this.readByte();
                this.finSet = (header >> 7 & 1) == 1;
                boolean rsv1 = (header & 0x40) != 0;
                boolean ctrl = (header & 8) != 0;
                this.isFrameCompressed = this.finSet && !ctrl && rsv1;
                this.opcode = header & 0xF;
                if (this.opcode == 8) {
                    return 0;
                }
                byte plen = WebSocketV13.this.readByte();
                if (plen > 0 && plen < 126) {
                    this.payloadSize = plen;
                } else if (plen == 126) {
                    this.payloadSize = (int)this.readSize(2);
                } else if (plen == 127) {
                    this.payloadSize = (int)this.readSize(8);
                }
                if (this.payloadSize < 1) {
                    return 0;
                }
                this.baos = new ByteArrayOutputStream(this.payloadSize);
                for (int i = 0; i < this.payloadSize; ++i) {
                    this.baos.write(WebSocketV13.this.readByte());
                }
                if (this.baos.size() != this.payloadSize) {
                    throw new WMSCommunicationException("Corrupted Stream");
                }
                this.data = this.isFrameCompressed && WebSocketV13.this.isCompressionEnabled ? WebSocketV13.this.inflate(this.baos.toByteArray()) : this.baos.toByteArray();
                return this.payloadSize;
            }
            catch (WMSCommunicationException wce) {
                throw wce;
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Exception : " + e.getMessage());
            }
        }

        public boolean isSingleFrame() {
            return this.finSet;
        }

        public boolean isCloseFrame() {
            return this.opcode == 8;
        }

        public boolean isTextFrame() {
            return this.opcode == 1;
        }

        public boolean isBinaryFrame() {
            return this.opcode == 2;
        }

        public String getText() throws WMSCommunicationException {
            try {
                return new String(this.data, "UTF-8");
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Unable to get text : " + e.getMessage());
            }
        }

        private long readSize(int len) throws WMSCommunicationException {
            long size = 0L;
            for (int i = 0; i < len; ++i) {
                size = size << 8 | (long)(WebSocketV13.this.readByte() & 0xFF);
            }
            return size;
        }

        public void clear() {
            this.baos = null;
        }
    }

    class CallbackEvent {
        public static final int TYPE_OPEN = 1;
        public static final int TYPE_MESSAGE = 2;
        private int type = -10;
        private HashMap<String, Object> details = new HashMap();

        public CallbackEvent(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public void put(String key, Object value) {
            this.details.put(key, value);
        }

        public Object get(String key) {
            return this.details.get(key);
        }

        public void clear() {
            this.details = null;
        }
    }

    class CallbackThread
    extends Thread {
        CallbackThread() {
        }

        @Override
        public void run() {
            while (!WebSocketV13.this.closed) {
                try {
                    CallbackEvent cbe = (CallbackEvent)WebSocketV13.this.callbackQueue.take();
                    this.execute(cbe);
                    cbe.clear();
                }
                catch (Exception exception) {}
            }
        }

        public void execute(CallbackEvent cbe) {
            try {
                if (cbe == null) {
                    return;
                }
                switch (cbe.getType()) {
                    case 1: {
                        WebSocketV13.this.callbackHandler.onOpen();
                        break;
                    }
                    case 2: {
                        WebSocketV13.this.callbackHandler.onMessage((String)cbe.get("msg"));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void flush() {
            if (WebSocketV13.this.callbackQueue.size() > 0) {
                ArrayList unflushed = new ArrayList();
                WebSocketV13.this.callbackQueue.drainTo(unflushed);
                for (CallbackEvent cbe : unflushed) {
                    this.execute(cbe);
                }
            }
        }
    }

    class WriteThread
    extends Thread {
        private long lastPingTime = 0L;

        WriteThread() {
        }

        @Override
        public void run() {
            while (!WebSocketV13.this.closed) {
                try {
                    WriteFrame wf = (WriteFrame)WebSocketV13.this.writeQueue.poll(PING_INTERVAL, TimeUnit.SECONDS);
                    if (wf == null && !WebSocketV13.this.isHold()) {
                        if (System.currentTimeMillis() - this.lastPingTime <= PING_INTERVAL * 1000L) continue;
                        this.lastPingTime = System.currentTimeMillis();
                        wf = new WriteFrame(1, "-");
                        WebSocketV13.this.writeBytes(wf.getBytes());
                        continue;
                    }
                    if (wf == null) continue;
                    WebSocketV13.this.writeBytes(wf.getBytes());
                    if (!wf.isCloseFrame()) continue;
                    WebSocketV13.this.conStatus = -1;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                    break;
                }
                catch (InterruptedException wf) {
                }
                catch (Exception e) {
                    WebSocketV13.this.conStatus = -2;
                    break;
                }
            }
            WebSocketV13.this.handleClose();
        }
    }

    class ReadThread
    extends Thread {
        ReadThread() {
        }

        @Override
        public void run() {
            try {
                WebSocketV13.this.doConnect();
                WebSocketV13.this.doHandshake();
                WebSocketV13.this.conStatus = 1;
                WebSocketV13.this.writeThread = new WriteThread();
                WebSocketV13.this.writeThread.start();
                WebSocketV13.this.callbackQueue.put(new CallbackEvent(1));
                while (!WebSocketV13.this.closed) {
                    ReadFrame rf = new ReadFrame();
                    int len = rf.readFully();
                    if (rf.isCloseFrame()) {
                        WebSocketV13.this.conStatus = -1;
                        break;
                    }
                    if (len < 0) {
                        WebSocketV13.this.conStatus = -3;
                        break;
                    }
                    if (len == 0) continue;
                    if (rf.isTextFrame()) {
                        logger.fine("GS --> Read Frame : [" + len + "] : " + rf.getText());
                        CallbackEvent cbe = new CallbackEvent(2);
                        cbe.put("msg", rf.getText());
                        WebSocketV13.this.callbackQueue.put(cbe);
                    }
                    rf.clear();
                }
            }
            catch (Exception e) {
                WebSocketV13.this.conStatus = -2;
            }
            WebSocketV13.this.handleClose();
        }
    }
}

