/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.websocket;

import com.adventnet.wms.common.Base64;
import com.adventnet.wms.common.exception.WMSCommunicationException;
import com.adventnet.wms.common.exception.WSRetryFailureException;
import com.adventnet.wms.common.websocket.WSQueryConnectionMonitor;
import com.adventnet.wms.common.websocket.WebSocket;
import com.adventnet.wms.common.websocket.WebSocketHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;

public class WebSocketQueryV13
extends WebSocket {
    private static final Logger logger = Logger.getLogger(WebSocketQueryV13.class.getName());
    private URI uri = null;
    private CharBuffer headerBuffer = CharBuffer.allocate(1024);
    private String cookie = null;
    private Object wslock = new Object();
    private String host = null;
    private int port = -1;
    private boolean isSSL = false;
    private int conStatus = 0;
    private Socket socket = null;
    private InputStream in = null;
    private OutputStream out = null;
    private Random random = new Random(System.currentTimeMillis());
    private static String NEWLINE = "\r\n";
    private static int VERSION = 13;
    private boolean closed = false;
    private static long pinginterval = 60L;
    private long lastPingTime = System.currentTimeMillis();
    private static final int PERREADMAXLEN = 8192;

    public WebSocketQueryV13(String url) throws WMSCommunicationException {
        try {
            this.uri = new URI(url);
            if (!this.uri.getScheme().equals("ws") && !this.uri.getScheme().equals("wss")) {
                throw new WMSCommunicationException("Invalid url");
            }
            this.isSSL = this.uri.getScheme().equals("wss");
            this.port = this.uri.getPort();
            if (this.port == -1) {
                this.port = this.isSSL ? 443 : 80;
            }
            this.host = this.uri.getHost();
            if (!WSQueryConnectionMonitor.startMonitor()) {
                logger.info("GS --> Initializing WS Query connection monitoring");
            }
            logger.info("GS --> new websocket uri=" + this.uri);
        }
        catch (URISyntaxException use) {
            throw new WMSCommunicationException("Invalid Url");
        }
        catch (Exception e) {
            throw new WMSCommunicationException("Exception : " + e.getMessage());
        }
    }

    @Override
    public void setHandler(WebSocketHandler handler) {
    }

    @Override
    public void addCookie(String key, String value) {
        this.cookie = this.cookie != null ? this.cookie + "; " + key + "=" + value : key + "=" + value;
    }

    @Override
    public void connect() throws WMSCommunicationException {
        if (this.conStatus != 0) {
            return;
        }
        if (this.host == null) {
            throw new WMSCommunicationException("Invalid host " + this.host);
        }
        if (this.port < 0) {
            throw new WMSCommunicationException("Invalid port " + this.port);
        }
        this.doConnect();
        this.doHandshake();
        this.conStatus = 1;
        WSQueryConnectionMonitor.registerWSConnectionForMonitor(this);
        this.closed = false;
    }

    public boolean isOpen() {
        return this.conStatus == 1;
    }

    @Override
    public boolean write(String msg) throws WMSCommunicationException {
        throw new WMSCommunicationException("Unsupported Operation for this connection");
    }

    @Override
    public boolean writeBinary(byte[] msg) throws WMSCommunicationException {
        throw new WMSCommunicationException("Unsupported Operation for this connection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPing() {
        block9: {
            try {
                if (this.inprogress || System.currentTimeMillis() - this.lastPingTime <= pinginterval * 1000L) break block9;
                Object object = this.wslock;
                synchronized (object) {
                    WriteFrame wf = new WriteFrame(1, "-");
                    this.writeBytes(wf.getBytes());
                    ReadFrame rf = new ReadFrame();
                    int len = rf.readFully();
                    if (len == 0 && rf.isCloseFrame()) {
                        this.doReconnect();
                    }
                    this.lastPingTime = System.currentTimeMillis();
                }
            }
            catch (WMSCommunicationException e) {
                logger.warning(" Exception in doPing " + e.getMessage());
                this.conStatus = -2;
                try {
                    this.doReconnect();
                }
                catch (Exception exception) {}
            }
            catch (Exception ex) {
                logger.warning(" General Exception in doPing " + ex.getMessage());
            }
        }
    }

    private void cleanupSocket() {
        try {
            this.socket.setSoTimeout(25);
            byte[] b = new byte[1];
            int c = -1;
            while (this.in.read(b) != -1) {
                c = -1;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.socket.setSoTimeout(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ArrayList processCommand(String msg) throws WMSCommunicationException, WSRetryFailureException {
        this.inprogress = true;
        Object object = this.wslock;
        synchronized (object) {
            this.cleanupSocket();
            ArrayList<String> responseList = new ArrayList<String>();
            try {
                int max;
                if (this.closed) {
                    this.doReconnect();
                    throw new WMSCommunicationException("WebSocket closed");
                }
                try {
                    this.writeBytes(new WriteFrame(1, msg).getBytes());
                }
                catch (Exception e) {
                    this.doReconnect();
                    throw new WMSCommunicationException(e.getMessage());
                }
                boolean completed = false;
                for (max = 0; !completed && max < 500; ++max) {
                    String response;
                    ReadFrame rf = new ReadFrame();
                    int len = rf.readFully();
                    if (len == 33) {
                        this.inprogress = false;
                        if (rf.isTextFrame()) {
                            response = rf.getText();
                            responseList.add(response);
                        }
                        return responseList;
                    }
                    if (rf.isCloseFrame()) {
                        this.doReconnect();
                        throw new WMSCommunicationException("Closed");
                    }
                    if (len <= 0 || !rf.isTextFrame() && !rf.isBinaryFrame()) continue;
                    response = rf.getText();
                    responseList.add(response);
                }
                if (max >= 100) {
                    this.doReconnect();
                    throw new WMSCommunicationException("Command Failed");
                }
            }
            catch (Exception ex) {
                this.doReconnect();
                throw new WMSCommunicationException(ex.getMessage());
            }
        }
        this.inprogress = false;
        return null;
    }

    private void doReconnect() throws WSRetryFailureException {
        try {
            this.close();
            this.conStatus = 0;
            this.connect();
        }
        catch (WMSCommunicationException ex) {
            throw new WSRetryFailureException("Retry attempt failed");
        }
    }

    @Override
    public void hold() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void close() {
        try {
            this.writeBytes(new WriteFrame(8, "").getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        WSQueryConnectionMonitor.removeWSConnectionMonitoring(this);
        this.closed = true;
    }

    private void doConnect() throws WMSCommunicationException {
        try {
            if (this.isSSL) {
                SSLContext sslCtx = SSLContext.getInstance("TLS");
                sslCtx.init(null, null, null);
                this.socket = sslCtx.getSocketFactory().createSocket(this.host, this.port);
            } else {
                this.socket = new Socket(this.host, this.port);
            }
            if (this.sendbuffersize != -1) {
                this.socket.setSendBufferSize(this.sendbuffersize);
            }
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }
        catch (UnknownHostException uhe) {
            throw new WMSCommunicationException("Invalid Host : " + uhe);
        }
        catch (IOException ioe) {
            throw new WMSCommunicationException("IO Exception : " + ioe);
        }
        catch (SecurityException se) {
            throw new WMSCommunicationException("Secruity Exception : " + se);
        }
        catch (Exception e) {
            throw new WMSCommunicationException("Exception : " + e.getMessage());
        }
    }

    private void doHandshake() throws WMSCommunicationException {
        try {
            ArrayList<String> responseHeader;
            block21: {
                this.headerBuffer.clear();
                String path = this.uri.getPath();
                if (path == null) {
                    path = "/";
                } else if (this.uri.getQuery() != null) {
                    path = path + "?" + this.uri.getRawQuery();
                }
                this.headerBuffer.put("GET " + path + " HTTP/1.1" + NEWLINE);
                this.appendHeaderValue("Host", this.host);
                this.appendHeaderValue("Upgrade", "websocket");
                this.appendHeaderValue("Connection", "Upgrade");
                this.appendHeaderValue("Sec-WebSocket-Version", "" + VERSION);
                this.appendHeaderValue("Sec-WebSocket-Key", Base64.encodeByte(this.getRandomBytes(16)));
                Enumeration en = this.headers.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    this.appendHeaderValue(key, (String)this.headers.get(key));
                }
                if (this.cookie != null) {
                    this.appendHeaderValue("Cookie", this.cookie);
                }
                this.headerBuffer.put(NEWLINE);
                this.headerBuffer.flip();
                this.writeBytes(this.headerBuffer.toString().getBytes("UTF-8"));
                int maxLen = 1024;
                byte[] buffer = new byte[maxLen];
                int pos = 0;
                responseHeader = new ArrayList<String>();
                do {
                    byte b = this.readByte();
                    buffer[pos] = b;
                    if (buffer[++pos - 1] == 10 && buffer[pos - 2] == 13) {
                        String line = new String(buffer, "UTF-8");
                        if (line.trim().equals("")) break block21;
                        responseHeader.add(line.trim());
                        buffer = new byte[maxLen];
                        pos = 0;
                    }
                    if (pos < 1020) continue;
                    throw new WMSCommunicationException("Header too long : " + new String(buffer, "UTF-8"));
                } while (responseHeader.size() <= 10);
                throw new WMSCommunicationException("Too many headers : " + responseHeader);
            }
            if (responseHeader.size() == 0) {
                throw new WMSCommunicationException("Insuffcient response header");
            }
            try {
                int responseStatusCode = Integer.parseInt(((String)responseHeader.remove(0)).substring(9, 12));
                if (responseStatusCode != 101) {
                    throw new WMSCommunicationException("Invalid status code : " + responseStatusCode);
                }
            }
            catch (WMSCommunicationException wce1) {
                throw wce1;
            }
            catch (Exception e1) {
                throw new WMSCommunicationException("Invalid Status message in response");
            }
            try {
                HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
                for (String line : responseHeader) {
                    String[] keyValue = line.split(": ", 2);
                    responseHeaderMap.put(keyValue[0], keyValue[1]);
                }
                if (!((String)responseHeaderMap.get("Upgrade")).toLowerCase().equals("websocket") || !((String)responseHeaderMap.get("Connection")).equals("Upgrade")) {
                    throw new WMSCommunicationException("Headers on upgrade not found");
                }
                this.inprogress = false;
            }
            catch (WMSCommunicationException wce2) {
                throw wce2;
            }
            catch (Exception e2) {
                throw new WMSCommunicationException("Unable to verify response header : " + e2.getMessage());
            }
        }
        catch (WMSCommunicationException wce) {
            throw wce;
        }
        catch (IOException ioe) {
            throw new WMSCommunicationException("IOException : " + ioe.getMessage());
        }
        catch (Exception e) {
            throw new WMSCommunicationException("Exception doHandshake : " + e.getMessage());
        }
    }

    private void appendHeaderValue(String name, String value) {
        this.headerBuffer.put(name);
        this.headerBuffer.put(": ");
        this.headerBuffer.put(value);
        this.headerBuffer.put(NEWLINE);
    }

    private byte readByte() throws WMSCommunicationException {
        try {
            byte[] data = new byte[1];
            if (this.in.read(data) == -1) {
                throw new WMSCommunicationException("Stream Closed");
            }
            return data[0];
        }
        catch (IOException ioe) {
            throw new WMSCommunicationException("IOException on read");
        }
        catch (WMSCommunicationException wce) {
            throw wce;
        }
    }

    private void readByte(ByteArrayOutputStream baos, int payloadSize) throws WMSCommunicationException {
        try {
            while (payloadSize > 0) {
                byte[] data = new byte[8192 > payloadSize ? payloadSize : 8192];
                int readbytes = this.in.read(data);
                if (readbytes == -1) {
                    throw new WMSCommunicationException("Stream Close");
                }
                baos.write(data, 0, readbytes);
                payloadSize -= readbytes;
            }
        }
        catch (IOException ioe) {
            throw new WMSCommunicationException("IOException on read");
        }
    }

    private void writeBytes(byte[] data) throws WMSCommunicationException {
        try {
            this.out.write(data);
            this.out.flush();
        }
        catch (IOException ioe) {
            throw new WMSCommunicationException("IOException on write");
        }
    }

    private byte[] getRandomBytes(int len) {
        byte[] rb = new byte[len];
        this.random.nextBytes(rb);
        return rb;
    }

    static class Status {
        public static final int CONNECTED = 1;
        public static final int NOT_CONNECTED = 0;
        public static final int CLOSED = -1;
        public static final int ABORTED = -2;
        public static final int ERROR = -3;

        Status() {
        }
    }

    static class OPCode {
        public static final int CONTINUATION = 0;
        public static final int TEXT = 1;
        public static final int BINARY = 2;
        public static final int CLOSE = 8;
        public static final int PING = 9;
        public static final int PONG = 10;

        OPCode() {
        }
    }

    class WriteFrame {
        private byte opcode;
        private byte[] data;

        public WriteFrame(int opcode, String strData) throws WMSCommunicationException {
            this(opcode, strData, true);
        }

        public WriteFrame(int opcode, String strData, boolean mask) throws WMSCommunicationException {
            try {
                this.opcode = (byte)opcode;
                this.data = this.prepareFrame(strData.getBytes("UTF-8"), mask);
            }
            catch (WMSCommunicationException wce) {
                throw wce;
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Unable to prepare write frame : " + e.getMessage());
            }
        }

        public byte[] getBytes() {
            return this.data;
        }

        private byte[] prepareFrame(byte[] rawData, boolean mask) throws WMSCommunicationException {
            try {
                ByteArrayOutputStream wf = new ByteArrayOutputStream(rawData.length + 10);
                wf.write((byte)(0x80 | this.opcode));
                int length = rawData.length;
                int lf = 0;
                if (length < 126) {
                    lf = length;
                    lf = mask ? 0x80 | lf : lf;
                    wf.write((byte)lf);
                } else if (length <= 65535) {
                    lf = 126;
                    lf = mask ? 0x80 | lf : lf;
                    wf.write((byte)lf);
                    byte[] b = new byte[]{(byte)(length >>> 8), (byte)(length & 0xFF)};
                    wf.write(b);
                } else if (length > 65535) {
                    long len = new Long(length);
                    lf = 127;
                    lf = mask ? 0x80 | lf : lf;
                    wf.write((byte)lf);
                    byte[] b = new byte[]{(byte)(len >>> 56), (byte)(len >>> 48), (byte)(len >>> 40), (byte)(len >>> 32), (byte)(len >>> 24), (byte)(len >>> 16), (byte)(len >>> 8), (byte)(len & 0xFFL)};
                    wf.write(b);
                }
                if (mask) {
                    byte[] maskValue = WebSocketQueryV13.this.getRandomBytes(4);
                    wf.write(maskValue);
                    for (int i = 0; i < rawData.length; ++i) {
                        int n = i;
                        rawData[n] = (byte)(rawData[n] ^ maskValue[i % 4]);
                    }
                }
                wf.write(rawData);
                return wf.toByteArray();
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Unable to prepare write frame : " + e.getMessage());
            }
        }

        public boolean isCloseFrame() {
            return this.opcode == 8;
        }
    }

    class ReadFrame {
        private int payloadSize = -1;
        private ByteArrayOutputStream baos;
        private int opcode = 0;
        private boolean finSet = true;

        ReadFrame() {
        }

        public int readFully() throws WMSCommunicationException {
            try {
                byte header = WebSocketQueryV13.this.readByte();
                this.finSet = (header >> 7 & 1) == 1;
                this.opcode = header & 0xF;
                if (this.opcode == 8) {
                    return 0;
                }
                byte plen = WebSocketQueryV13.this.readByte();
                if (plen > 0 && plen < 126) {
                    this.payloadSize = plen;
                } else if (plen == 126) {
                    this.payloadSize = (int)this.readSize(2);
                } else if (plen == 127) {
                    this.payloadSize = (int)this.readSize(8);
                }
                if (this.payloadSize < 1) {
                    return 0;
                }
                if (this.opcode == 2) {
                    this.payloadSize = this.handleBinaryResponse(this.payloadSize);
                } else {
                    this.baos = new ByteArrayOutputStream(this.payloadSize);
                    for (int i = 0; i < this.payloadSize; ++i) {
                        this.baos.write(WebSocketQueryV13.this.readByte());
                    }
                    WebSocketQueryV13.this.lastPingTime = System.currentTimeMillis();
                    if (this.baos.size() != this.payloadSize) {
                        throw new WMSCommunicationException("Corrupted Stream");
                    }
                }
                return this.payloadSize;
            }
            catch (WMSCommunicationException wce) {
                throw wce;
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Exception : " + e.getMessage());
            }
        }

        private int handleBinaryResponse(int payloadSize) throws WMSCommunicationException {
            int totalpayloadSize = payloadSize;
            this.baos = new ByteArrayOutputStream();
            WebSocketQueryV13.this.readByte(this.baos, payloadSize);
            WebSocketQueryV13.this.lastPingTime = System.currentTimeMillis();
            boolean proceed = true;
            while (proceed) {
                byte header = WebSocketQueryV13.this.readByte();
                this.finSet = (header >> 7 & 1) == 1;
                this.opcode = header & 0xF;
                if (this.opcode == 8) {
                    return 0;
                }
                if (this.opcode != 2) {
                    throw new WMSCommunicationException("IMPROPER RESPONSE FORMAT");
                }
                byte plen = WebSocketQueryV13.this.readByte();
                payloadSize = -1;
                if (plen > 0 && plen < 126) {
                    payloadSize = plen;
                } else if (plen == 126) {
                    payloadSize = (int)this.readSize(2);
                } else if (plen == 127) {
                    payloadSize = (int)this.readSize(8);
                }
                if (payloadSize < 1) {
                    if (totalpayloadSize > 1) {
                        throw new WMSCommunicationException("EMPTY RESPONSE IN BETWEEN READ");
                    }
                    return 0;
                }
                if (payloadSize == 1) {
                    if (WebSocketQueryV13.this.readByte() == 10) {
                        return totalpayloadSize;
                    }
                    throw new WMSCommunicationException("IMPROPER END RESPONSE");
                }
                WebSocketQueryV13.this.readByte(this.baos, payloadSize);
                WebSocketQueryV13.this.lastPingTime = System.currentTimeMillis();
                if (this.baos.size() == (totalpayloadSize += payloadSize)) continue;
                throw new WMSCommunicationException("Corrupted Stream");
            }
            return 0;
        }

        public boolean isSingleFrame() {
            return this.finSet;
        }

        public boolean isCloseFrame() {
            return this.opcode == 8;
        }

        public boolean isTextFrame() {
            return this.opcode == 1;
        }

        public boolean isBinaryFrame() {
            return this.opcode == 2;
        }

        public String getText() throws WMSCommunicationException {
            try {
                return this.baos.toString("UTF-8");
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Unable to get text : " + e.getMessage());
            }
        }

        private long readSize(int len) throws WMSCommunicationException {
            long size = 0L;
            for (int i = 0; i < len; ++i) {
                size = size << 8 | (long)(WebSocketQueryV13.this.readByte() & 0xFF);
            }
            return size;
        }

        public void clear() {
            this.baos = null;
        }
    }
}

