/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.websocket;

import com.adventnet.wms.common.exception.WMSCommunicationException;
import com.adventnet.wms.common.websocket.WebSocket;
import com.adventnet.wms.common.websocket.WebSocketQueryV13;
import com.adventnet.wms.common.websocket.WebSocketV13;

public class WebSocketFactory {
    public static final int NORMAL = 1;
    public static final int QUERY = 2;

    public static WebSocket createSocket(String url) throws WMSCommunicationException {
        return WebSocketFactory.createSocket(url, 1);
    }

    public static WebSocket createSocket(String url, boolean offerCompression) throws WMSCommunicationException {
        return WebSocketFactory.createSocket(url, 1, offerCompression);
    }

    public static WebSocket createSocket(String url, int type) throws WMSCommunicationException {
        return WebSocketFactory.createSocket(url, type, "v13");
    }

    public static WebSocket createSocket(String url, int type, boolean offerCompression) throws WMSCommunicationException {
        return WebSocketFactory.createSocket(url, type, "v13", offerCompression);
    }

    public static WebSocket createSocket(String url, int type, String version) throws WMSCommunicationException {
        return WebSocketFactory.createSocket(url, type, "v13", false);
    }

    public static WebSocket createSocket(String url, int type, String version, boolean offerCompression) throws WMSCommunicationException {
        if (version.equals("v13")) {
            if (type == 2) {
                return new WebSocketQueryV13(url);
            }
            return new WebSocketV13(url, offerCompression);
        }
        throw new WMSCommunicationException("Unsupported Version");
    }
}

