/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.websocket;

import com.adventnet.wms.common.exception.WMSCommunicationException;
import com.adventnet.wms.common.exception.WSRetryFailureException;
import com.adventnet.wms.common.websocket.WebSocketHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public abstract class WebSocket {
    protected boolean inprogress = false;
    protected int sendbuffersize = -1;
    protected Hashtable<String, String> headers = new Hashtable();

    public abstract void setHandler(WebSocketHandler var1);

    public void setSendBufferSize(int size) {
        this.sendbuffersize = size;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addHeaders(HashMap<String, String> headers) {
        for (String key : headers.keySet()) {
            this.addHeader(key, headers.get(key));
        }
    }

    public abstract void addCookie(String var1, String var2);

    public void addCookies(HashMap<String, String> cookies) {
        for (String key : cookies.keySet()) {
            this.addCookie(key, cookies.get(key));
        }
    }

    public abstract void connect() throws WMSCommunicationException;

    public abstract boolean write(String var1) throws WMSCommunicationException;

    public abstract boolean writeBinary(byte[] var1) throws WMSCommunicationException;

    public ArrayList processCommand(String msg) throws WMSCommunicationException, WSRetryFailureException {
        throw new WMSCommunicationException("Unsupported Operation");
    }

    public boolean isRequestInProgress() {
        return this.inprogress;
    }

    public abstract void close();

    public abstract void hold();

    public abstract void resume();
}

