/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.transcript;

import com.adventnet.wms.common.transcript.WMSAddlData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class ThreadCustomAddlData
implements WMSAddlData {
    private static final Logger LOGGER = Logger.getLogger(ThreadCustomAddlData.class.getName());

    @Override
    public int getAllocatedSize() {
        return 2048;
    }

    @Override
    public JSONObject performOperation(String operation, JSONObject operationalData, JSONObject originalData) {
        Operation operationEnum = null;
        try {
            operationEnum = Operation.valueOf(operation);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (operationEnum != null) {
                originalData = this.performDataAddtion(operationalData, originalData, operationEnum);
            } else {
                LOGGER.info("Unsupported operation for thread custom additional data. Operation :  " + operation);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Exception occured while performing operation for thread custom additional data ", ex);
        }
        return originalData;
    }

    private JSONObject performDataAddtion(JSONObject operationalData, JSONObject originalData, Operation operationEnum) {
        if (originalData == null || originalData.length() == 0) {
            originalData = new JSONObject();
        }
        if (operationalData != null) {
            originalData.put(operationEnum.getKey(), (Object)operationalData);
        }
        return originalData;
    }

    private static enum Operation {
        ADD_LINK_INFO("thread_link_info"),
        ADD_THREAD_STATE_INFO("thread_state_info");

        private String key;

        private Operation(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

