/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.pex.io;

import com.adventnet.wms.common.HttpDataWraper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.logging.Logger;

public class ProgressiveJSONOutputStream {
    private static Logger logger = Logger.getLogger(ProgressiveJSONOutputStream.class.getName());
    private long size = 0L;
    public static final String HTTP_HEADER = "x-pexpjson";
    private OutputStream os;

    public ProgressiveJSONOutputStream(OutputStream os) {
        this.os = os;
    }

    public int writeChunk(String name, Object data) throws IOException {
        try {
            if (data == null) {
                return 0;
            }
            Hashtable<String, Object> chunkWraper = new Hashtable<String, Object>();
            chunkWraper.put("chunk", name);
            chunkWraper.put("data", data);
            byte[] chunk = (HttpDataWraper.getString(chunkWraper) + ",").getBytes("UTF-8");
            byte[] chunklen = ("\r\n" + Integer.toHexString(chunk.length) + "\r\n").getBytes("UTF-8");
            this.size += (long)chunk.length;
            this.os.write(chunklen);
            this.os.write(chunk);
            this.os.flush();
            return chunk.length;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Unable to write to PJOS Stream");
        }
    }

    public long getSize() {
        return this.size;
    }

    public void close() {
        try {
            byte[] chunkclose = "\r\n0\r\n".getBytes("UTF-8");
            this.os.write(chunkclose);
            this.os.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

