/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.pex;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.pex.PEXErrorCodes;
import java.util.Hashtable;

public class PEXError {
    private int code;
    private String msg;
    private int rcode = -1;
    private String rmsg;

    public PEXError(Hashtable err) {
        this.code = Integer.parseInt("" + err.get("c"));
        this.msg = (String)err.get("m");
        this.rmsg = (String)err.get("rm");
        if (err.get("rc") != null) {
            this.rcode = Integer.parseInt((String)err.get("rc"));
        }
    }

    public PEXError(int code) {
        this.code = code;
        this.msg = PEXErrorCodes.getMessage(code);
    }

    public PEXError(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public PEXError(int code, String msg, int rcode, String rmsg) {
        this.code = code;
        this.msg = msg;
        this.rcode = rcode;
        this.rmsg = rmsg;
    }

    public String getString() {
        return HttpDataWraper.getString(this.getObject());
    }

    public Hashtable getObject() {
        Hashtable<String, String> error = new Hashtable<String, String>();
        error.put("c", "" + this.code);
        error.put("m", "" + this.msg);
        error.put("rc", "" + this.rcode);
        error.put("rm", "" + this.rmsg);
        return error;
    }
}

