/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.nio.tcp;

import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.common.exception.WMSSSLCertificateException;
import com.adventnet.wms.common.nio.tcp.PacketAssembler;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NetDataProcessor {
    private static LinkedBlockingQueue queue;
    private static LinkedBlockingQueue highpriorityqueue;
    private static ThreadPoolExecutor executor;
    private static ThreadPoolExecutor highpriorityexecutor;

    public static void initialize(int threadcount, int maxthreadcount) {
        NetDataProcessor.initialize(threadcount, maxthreadcount, -1, -1);
    }

    public static void initialize(int threadcount, int maxthreadcount, int highprioritythreadcount, int maxhighprioritythreadcount) {
        queue = new LinkedBlockingQueue();
        executor = new ThreadPoolExecutor(threadcount, maxthreadcount, 100L, TimeUnit.MILLISECONDS, queue);
        if (highprioritythreadcount != -1 && maxhighprioritythreadcount != -1) {
            highpriorityqueue = new LinkedBlockingQueue();
            highpriorityexecutor = new ThreadPoolExecutor(highprioritythreadcount, maxhighprioritythreadcount, 100L, TimeUnit.MILLISECONDS, highpriorityqueue);
        }
    }

    public static void process(SelectionKey key, int readyops) throws CancelledKeyException, WMSException {
        PacketAssembler pasm = (PacketAssembler)key.attachment();
        if (pasm == null || !pasm.isValid()) {
            try {
                key.channel().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                key.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (!key.isValid() || !((SocketChannel)key.channel()).isOpen()) {
            try {
                key.channel().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            key.cancel();
            readyops = -1;
        }
        if (pasm.isHighPriority()) {
            highpriorityexecutor.execute(new Processor(key, readyops));
        } else {
            executor.execute(new Processor(key, readyops));
        }
    }

    static class Processor
    implements Runnable {
        private SelectionKey key = null;
        private int readyops;

        public Processor(SelectionKey key, int readyops) {
            this.key = key;
            this.readyops = readyops;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PacketAssembler pasm = (PacketAssembler)this.key.attachment();
            if (pasm == null || !pasm.isValid()) {
                try {
                    this.key.channel().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.key.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            Object object = pasm.getLockObject();
            synchronized (object) {
                block54: {
                    try {
                        block55: {
                            if (this.readyops == -1 || !this.key.isValid() || !((SocketChannel)this.key.channel()).isOpen()) {
                                this.close(pasm);
                                return;
                            }
                            if ((this.readyops & 1) == 1) {
                                if (pasm.isSSL() || pasm.isTLS() && pasm.isHSStarted()) {
                                    if (!pasm.isHSDone()) {
                                        boolean status = pasm.doHandshake(this.key);
                                        if (status) {
                                            pasm.setHSDone();
                                            this.key.interestOps(1);
                                            pasm.onHandshake();
                                            pasm.readData(this.key);
                                        }
                                    } else {
                                        pasm.readData(this.key);
                                        this.key.interestOps(1);
                                    }
                                } else {
                                    pasm.readData(this.key);
                                    this.key.interestOps(1);
                                }
                                break block54;
                            }
                            if ((this.readyops & 4) == 4) {
                                if (pasm.isSSL() && !pasm.isHSDone() || pasm.isTLS() && pasm.isHSStarted() && !pasm.isHSDone()) {
                                    boolean hsstaus = pasm.doHandshake(this.key);
                                    if (hsstaus) {
                                        pasm.setHSDone();
                                        this.key.interestOps(1);
                                        pasm.onHandshake();
                                        pasm.readData(this.key);
                                    }
                                } else {
                                    pasm.handleWrite(this.key);
                                }
                                break block54;
                            }
                            if ((this.readyops & 8) != 8) break block54;
                            try {
                                if (pasm.getSocketChannel().finishConnect()) break block55;
                                if (pasm.isConnectRetryLimitExceeded()) {
                                    pasm.onConnectFailure(System.currentTimeMillis() - pasm.getInitConnectTime());
                                    if (this.key != null) {
                                        try {
                                            this.key.channel().close();
                                        }
                                        catch (Exception hsstaus) {
                                            // empty catch block
                                        }
                                        this.key.cancel();
                                        this.key.attach(null);
                                    }
                                    return;
                                }
                                this.key.interestOps(8);
                                pasm.incrementConnectRetry();
                                return;
                            }
                            catch (IOException ex) {
                                this.close(pasm);
                                try {
                                    pasm.onConnectFailure(System.currentTimeMillis() - pasm.getInitConnectTime());
                                    try {
                                        this.key.channel().close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    this.key.cancel();
                                    this.key.attach(null);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return;
                            }
                        }
                        if (pasm.isSSL()) {
                            if (!pasm.isHSDone()) {
                                boolean status = pasm.doHandshake(this.key);
                                if (status) {
                                    pasm.setHSDone();
                                    this.key.interestOps(1);
                                    pasm.onHandshake();
                                }
                            } else {
                                this.key.interestOps(1);
                                pasm.onConnect();
                            }
                        } else {
                            this.key.interestOps(1);
                            pasm.onConnect();
                        }
                    }
                    catch (ConnectException ce) {
                        this.close(pasm);
                        if (ce.getMessage() == null || !ce.getMessage().contains("Connection refused")) break block54;
                        try {
                            if (this.key != null) {
                                pasm.onDisconnect(-2);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        return;
                    }
                    catch (WMSSSLCertificateException excep) {
                        this.close(pasm);
                        if (this.key != null) {
                            this.key.cancel();
                            this.key.attach(null);
                            return;
                        }
                    }
                    catch (IOException ce) {
                        this.close(pasm);
                        if (ce.getMessage() != null && ce.getMessage().contains("Connection timed out")) {
                            try {
                                if (this.key != null) {
                                    pasm.onDisconnect(-2);
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            return;
                        }
                        pasm.onDisconnect(-1);
                        if (this.key != null) {
                            this.key.cancel();
                            this.key.attach(null);
                        }
                        return;
                    }
                    catch (Exception e) {
                        pasm.onDisconnect(-1);
                        if (this.key != null) {
                            try {
                                this.key.channel().close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.key.cancel();
                            this.key.attach(null);
                        }
                        return;
                    }
                }
                if (this.key != null && this.key.isValid() && this.key.interestOps() == 0) {
                    try {
                        this.key.interestOps(1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        private void close(PacketAssembler pasm) {
            try {
                pasm.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

