/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.nio;

import com.adventnet.wms.common.nio.SSLManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SSLWrapper {
    private SocketChannel sc;
    private ByteBuffer dataBuffer;
    private static int dataBBSize = 4096;
    protected SSLEngine sslEngine = null;
    private int appSize;
    private int netSize;
    private ByteBuffer inBB;
    private ByteBuffer outBB;
    private int max_size = 0x100000;
    private static ByteBuffer handShakeBB = ByteBuffer.allocate(0);
    private SSLEngineResult.HandshakeStatus sslHSStatus;
    private boolean sslHSComplete;
    private boolean close = false;
    private int sizecheckcounter = 0;

    public SSLWrapper(SocketChannel sc, SSLContext sslCntx, String host) throws IOException {
        this.sc = sc;
        sc.configureBlocking(false);
        this.sslEngine = sslCntx.createSSLEngine();
        try {
            String[] s = this.sslEngine.getEnabledProtocols();
            ArrayList<String> protocolSupportedList = new ArrayList<String>(Arrays.asList(s));
            if (host != null && SSLManager.ignoreSSLVersion(host)) {
                protocolSupportedList.removeAll(SSLManager.getSSLVersionIgnoreList());
                this.sslEngine.setEnabledProtocols(protocolSupportedList.toArray(new String[0]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.sslEngine.setUseClientMode(true);
        this.sslHSStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        this.sslHSComplete = false;
        this.netSize = this.sslEngine.getSession().getPacketBufferSize();
        this.inBB = ByteBuffer.allocate(this.netSize);
        this.outBB = ByteBuffer.allocate(this.netSize);
        this.outBB.position(0);
        this.outBB.limit(0);
        this.appSize = this.sslEngine.getSession().getApplicationBufferSize();
        this.dataBuffer = ByteBuffer.allocate(this.appSize);
    }

    private void resizeDataBB() {
        if (this.dataBuffer.remaining() < this.appSize && this.dataBuffer.capacity() > 0 && this.dataBuffer.capacity() < this.max_size) {
            ByteBuffer bb = ByteBuffer.allocate(this.dataBuffer.capacity() * 2);
            this.dataBuffer.flip();
            bb.put(this.dataBuffer);
            this.dataBuffer = bb;
        }
    }

    public void clearDataBuffer() {
        this.dataBuffer.clear();
    }

    private boolean flush(ByteBuffer bb) throws IOException {
        this.sc.write(bb);
        return !bb.hasRemaining();
    }

    public boolean doHandshake(SelectionKey sk) throws IOException {
        if (this.sslHSComplete) {
            return this.sslHSComplete;
        }
        if (this.outBB.hasRemaining()) {
            if (!this.flush(this.outBB)) {
                return false;
            }
            switch (this.sslHSStatus) {
                case FINISHED: {
                    this.sslHSComplete = true;
                }
                case NEED_UNWRAP: {
                    if (sk == null) break;
                    sk.interestOps(1);
                }
            }
            return this.sslHSComplete;
        }
        block4 : switch (this.sslHSStatus) {
            case NEED_UNWRAP: {
                SSLEngineResult result;
                if (this.sc.read(this.inBB) == -1) {
                    this.sslEngine.closeInbound();
                    return this.sslHSComplete;
                }
                block20: while (this.sslHSStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    this.inBB.flip();
                    result = this.sslEngine.unwrap(this.inBB, this.dataBuffer);
                    this.inBB.compact();
                    this.sslHSStatus = result.getHandshakeStatus();
                    switch (result.getStatus()) {
                        case OK: {
                            switch (this.sslHSStatus) {
                                case NOT_HANDSHAKING: {
                                    throw new IOException("SSL - Invalid handshake");
                                }
                                case NEED_TASK: {
                                    this.sslHSStatus = this.doTasks();
                                    break;
                                }
                                case FINISHED: {
                                    this.sslHSComplete = true;
                                    break block20;
                                }
                            }
                            continue block20;
                        }
                        case BUFFER_UNDERFLOW: {
                            if (sk == null) break block20;
                            sk.interestOps(1);
                            break block20;
                        }
                        default: {
                            throw new IOException("SSL - Invalid handshake " + (Object)((Object)result.getStatus()));
                        }
                    }
                }
                if (this.sslHSStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
            }
            case NEED_WRAP: {
                this.outBB.clear();
                SSLEngineResult result = this.sslEngine.wrap(handShakeBB, this.outBB);
                this.outBB.flip();
                this.sslHSStatus = result.getHandshakeStatus();
                switch (result.getStatus()) {
                    case OK: {
                        if (this.sslHSStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            this.sslHSStatus = this.doTasks();
                        }
                        if (sk == null) break block4;
                        sk.interestOps(4);
                        break block4;
                    }
                    default: {
                        throw new IOException("SSL Invalid handshake " + (Object)((Object)result.getStatus()));
                    }
                }
            }
            default: {
                throw new RuntimeException("SSL Invlaid hand shake state" + (Object)((Object)this.sslHSStatus));
            }
        }
        return this.sslHSComplete;
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    public int read() throws IOException {
        SSLEngineResult result;
        if (!this.sslHSComplete) {
            throw new IllegalStateException();
        }
        int pos = this.dataBuffer.position();
        if (pos > 25600) {
            ++this.sizecheckcounter;
            if (this.sizecheckcounter > 25) {
                throw new IOException("Looping");
            }
            return pos;
        }
        this.sizecheckcounter = 0;
        if (this.sc.read(this.inBB) == -1) {
            this.sslEngine.closeInbound();
            return -1;
        }
        int currentpos = this.dataBuffer.position();
        block3: do {
            this.resizeDataBB();
            this.inBB.flip();
            result = this.sslEngine.unwrap(this.inBB, this.dataBuffer);
            this.inBB.compact();
            currentpos = this.dataBuffer.position();
            switch (result.getStatus()) {
                case OK: 
                case BUFFER_UNDERFLOW: {
                    if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue block3;
                    this.doTasks();
                    break;
                }
                default: {
                    if (this.dataBuffer.position() - pos > 0) continue block3;
                    throw new IOException("SSL sslEngine error read " + (Object)((Object)result.getStatus()));
                }
            }
        } while (result.bytesProduced() != 0 && currentpos < this.max_size && this.inBB.position() != 0 && result.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW);
        return this.dataBuffer.position() - pos;
    }

    public ByteBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public int write(ByteBuffer src) throws IOException {
        if (!this.sslHSComplete) {
            throw new IllegalStateException("SSL Invalid Handshake state Write");
        }
        return this.completeWrite(src);
    }

    private int completeWrite(ByteBuffer src) throws IOException {
        int retValue = 0;
        if (this.outBB.hasRemaining() && !this.flush(this.outBB)) {
            return retValue;
        }
        this.outBB.clear();
        SSLEngineResult result = this.sslEngine.wrap(src, this.outBB);
        retValue = result.bytesConsumed();
        this.outBB.flip();
        switch (result.getStatus()) {
            case OK: {
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
                this.doTasks();
                break;
            }
            default: {
                throw new IOException("SSL slEngine error write " + (Object)((Object)result.getStatus()));
            }
        }
        if (this.outBB.hasRemaining()) {
            this.flush(this.outBB);
        }
        return retValue;
    }

    public boolean close() throws IOException {
        SSLEngineResult result = null;
        if (this.sslEngine.isOutboundDone()) {
            return true;
        }
        this.sslEngine.closeOutbound();
        this.outBB.clear();
        result = this.sslEngine.wrap(handShakeBB, this.outBB);
        if (result.getStatus() != SSLEngineResult.Status.CLOSED) {
            throw new SSLException("SSL Invalid close state");
        }
        this.outBB.flip();
        if (this.outBB.hasRemaining()) {
            this.flush(this.outBB);
        }
        return !this.outBB.hasRemaining() && result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP;
    }
}

