/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.nio;

import com.adventnet.wms.common.nio.SSLManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import javax.net.ssl.X509TrustManager;

public class SSLTrustManager
implements X509TrustManager {
    private KeyStore trustStore;
    private String domain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLTrustManager(String domain) {
        this.domain = domain;
        InputStream in = null;
        try {
            this.trustStore = KeyStore.getInstance("JKS");
            String jrehome = System.getProperty("jre.home");
            String password = "changeit";
            String path = jrehome + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
            in = new FileInputStream(path);
            this.trustStore.load(in, password.toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certs, String arg1) throws CertificateException {
        try {
            boolean valid;
            int certLen = x509Certs.length;
            Date d = new Date();
            for (int i = 0; i < certLen; ++i) {
                try {
                    x509Certs[i].checkValidity(d);
                    continue;
                }
                catch (Exception e) {
                    throw new CertificateException("Certificate Expired");
                }
            }
            String dname = x509Certs[0].getSubjectDN().getName();
            String name = null;
            int idx = dname.indexOf("CN=");
            if (idx == -1) {
                idx = dname.indexOf("cn=");
            }
            if (idx == -1) {
                throw new CertificateException("Subject DN not present");
            }
            String dtemp = dname.substring(idx + 3);
            name = dtemp.indexOf(",") != -1 ? dtemp.substring(0, dtemp.indexOf(",")) : dtemp.substring(0).trim();
            if (this.domain.equals("default")) {
                valid = false;
                if (SSLManager.getExternalDomains().contains(name)) {
                    valid = true;
                } else {
                    ArrayList extdomains = SSLManager.getExternalDomains();
                    for (String indomain : extdomains) {
                        if (name.equals(indomain) || name.replace("*.", "").equals(indomain)) {
                            valid = true;
                        }
                        if (!name.startsWith("*.") || !indomain.substring(indomain.indexOf(".") + 1).equals(name.replace("*.", ""))) continue;
                        valid = true;
                    }
                }
                if (!valid) {
                    throw new CertificateException("Subject DN Mismatch");
                }
            } else {
                valid = false;
                if (name.equals(this.domain) || name.replace("*.", "").equals(this.domain)) {
                    valid = true;
                }
                if (name.startsWith("*.") && this.domain.substring(this.domain.indexOf(".") + 1).equals(name.replace("*.", ""))) {
                    valid = true;
                }
                if (!valid) {
                    throw new CertificateException("Subject DN Mismatch");
                }
            }
            Principal authprincipal = null;
            for (int i = x509Certs.length - 1; i >= 0; --i) {
                X509Certificate cert = x509Certs[i];
                Principal issuer = cert.getIssuerDN();
                Principal subject = cert.getSubjectDN();
                if (authprincipal != null) {
                    if (issuer.equals(authprincipal)) {
                        try {
                            PublicKey publickey = x509Certs[i + 1].getPublicKey();
                            x509Certs[i].verify(publickey);
                        }
                        catch (GeneralSecurityException generalsecurityexception) {
                            throw new CertificateException("signature verification failed ");
                        }
                    } else {
                        throw new CertificateException("subject/issuer verification failed of ");
                    }
                }
                authprincipal = subject;
            }
        }
        catch (CertificateException cxe) {
            cxe.printStackTrace();
            throw cxe;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CertificateException("Unknown issue");
        }
    }
}

