/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.nio;

import com.adventnet.wms.common.nio.HttpRequest;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class EventDispatcher {
    private static LinkedBlockingQueue queue = new LinkedBlockingQueue();
    private static ThreadPoolExecutor executor;
    private static boolean initialized;

    public static synchronized void initialize(int threadCount) {
        if (initialized) {
            return;
        }
        executor = new ThreadPoolExecutor(threadCount, threadCount, 100L, TimeUnit.MILLISECONDS, queue);
        initialized = true;
    }

    public static void process(HttpRequest request, int eventcode) {
        if (!initialized) {
            EventDispatcher.initialize(2);
        }
        executor.execute(new RequestEventDispatcher(request, eventcode));
    }

    static {
        initialized = false;
    }

    static class RequestEventDispatcher
    implements Runnable {
        private HttpRequest request;
        private int eventcode;

        public RequestEventDispatcher(HttpRequest request, int eventcode) {
            this.request = request;
            this.eventcode = eventcode;
        }

        @Override
        public void run() {
            try {
                this.request.notifyListener(this.eventcode);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

