/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.encryption;

import com.adventnet.wms.common.Base64;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.spec.KeySpec;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class EncryptionFactory {
    private static final Logger LOGGER = Logger.getLogger(EncryptionFactory.class.getName());
    private KeySpec desKeySpec = null;
    private SecretKeyFactory desKeyFactory = null;

    private EncryptionFactory(String keyphrase) throws Exception {
        this.desKeySpec = new DESKeySpec(keyphrase.getBytes("UTF-8"));
        this.desKeyFactory = SecretKeyFactory.getInstance("DES");
    }

    public static EncryptionFactory getInstance(String keyphrase) throws Exception {
        return new EncryptionFactory(keyphrase);
    }

    public String encrypt(String value) throws Exception {
        return this.encrypt(null, value);
    }

    public String encrypt(String salt, String value) throws Exception {
        SecretKey key = this.desKeyFactory.generateSecret(this.desKeySpec);
        Cipher desCipher = Cipher.getInstance("DES");
        desCipher.init(1, key);
        byte[] cleartext = value.getBytes("UTF-8");
        byte[] ciphertext = desCipher.doFinal(cleartext);
        if (salt != null) {
            DESKeySpec dspec = new DESKeySpec(salt.getBytes("UTF-8"));
            key = this.desKeyFactory.generateSecret(dspec);
            desCipher.init(1, key);
            ciphertext = desCipher.doFinal(ciphertext);
        }
        return URLEncoder.encode(Base64.encodeByte(ciphertext), "UTF-8").replace("+", "%20");
    }

    public String decrypt(String salt, String value) throws Exception {
        Cipher desCipher = Cipher.getInstance("DES");
        SecretKey key = null;
        String ciphertext = URLDecoder.decode(value, "UTF-8");
        byte[] cleartext = Base64.decode(ciphertext.getBytes("UTF-8"));
        if (salt != null) {
            DESKeySpec dspec = new DESKeySpec(salt.getBytes("UTF-8"));
            key = this.desKeyFactory.generateSecret(dspec);
            desCipher.init(2, key);
            cleartext = desCipher.doFinal(cleartext);
        }
        key = this.desKeyFactory.generateSecret(this.desKeySpec);
        desCipher.init(2, key);
        byte[] ctext = desCipher.doFinal(cleartext);
        return new String(ctext, "UTF-8");
    }

    public String decrypt(String value) throws Exception {
        return this.decrypt(null, value);
    }

    public static void main(String[] a) throws Exception {
        long t = System.currentTimeMillis();
        String data = a[0];
        String keyphrase = a[1];
        String salt = null;
        if (a.length > 2) {
            salt = a[2];
        }
        String encdata = EncryptionFactory.getInstance(keyphrase).encrypt(salt, data);
        LOGGER.info("Enc->" + encdata);
        String decr_data = EncryptionFactory.getInstance(keyphrase).decrypt(salt, encdata);
        LOGGER.info("Dec-->" + decr_data);
        if (encdata.equals(decr_data)) {
            LOGGER.info("Success");
        } else {
            LOGGER.info("Failure");
        }
        LOGGER.info("Time-Taken--->" + (System.currentTimeMillis() - t));
    }
}

