/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net.util;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpConnection;
import com.adventnet.wms.common.components.net.WCPAPIDispatcher;
import com.adventnet.wms.common.components.net.WCPConfManager;
import com.adventnet.wms.common.components.net.WCPSessionManager;
import com.adventnet.wms.common.components.net.util.WCPSecurityProvider;
import com.adventnet.wms.common.components.net.util.WCPUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPAdminUtil {
    private static final Logger LOGGER = Logger.getLogger(WCPUtil.class.getName());
    private static String prd = "Unknown";
    private static Map<String, String> adminUrlMap = new HashMap<String, String>();
    private static Map<String, String> apiBuildLogMap = new HashMap<String, String>();
    private static HashMap<String, Long> refreshPoolNameMap = new HashMap();
    private static final long WCP_SEEDS_REFRESH_INTERVAL = 10000L;
    private static WCPSecurityProvider securityProvider = null;

    public static void setPrd(String prdId) {
        if (CommonUtil.isEmpty(prdId)) {
            LOGGER.warning("Prd is empty or null. Hence we are skipping.");
            return;
        }
        prd = prdId;
        LOGGER.info("Changed prd in WCPAdminUtil prd=" + prdId);
    }

    public static void registerSecurity(String apiName, String adminURL, String buildLog) {
        try {
            if (CommonUtil.isEmpty(buildLog)) {
                buildLog = "Unknown";
            }
            apiBuildLogMap.put(apiName, buildLog);
            adminUrlMap.put(apiName, adminURL);
            LOGGER.info("Successfully registered adminurl and buildLog apiName=" + apiName + " adminURL=" + adminURL + " buildLog=" + buildLog);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error inside registerSecurity apiName=" + apiName + " adminURL=" + adminURL + " buildLog=" + buildLog, e);
        }
    }

    public static boolean updateAccessToken(String apiName) {
        if (!adminUrlMap.containsKey(apiName)) {
            LOGGER.warning("Admin URL is null or empty. apiName=" + apiName);
            return false;
        }
        if (CommonUtil.isEmpty(prd)) {
            LOGGER.warning("prd is null or empty. apiName=" + apiName);
            return false;
        }
        String accessToken = null;
        if (securityProvider != null) {
            accessToken = securityProvider.getAccessToken(apiName, prd);
            if (CommonUtil.isEmpty(accessToken)) {
                LOGGER.warning("WMSAPIWARN--> Received accessToken empty or null from securityProvider. apiname=" + apiName + " prd=" + prd + " accessToken=" + accessToken);
                return false;
            }
            WCPConfManager.setAccessToken(apiName, accessToken);
            return true;
        }
        HttpConnection conn = null;
        try {
            Hashtable headers = new Hashtable();
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("prd", prd);
            params.put("apiname", apiName.toLowerCase());
            params.put("iscsignature", WCPSessionManager.getISCSign(apiName));
            conn = new HttpConnection("http://" + adminUrlMap.get(apiName) + "/getapiaccesstoken.do", 20000, 5000);
            accessToken = (String)conn.doPost(params, headers);
            if (conn.getStatusCode() != 200) {
                LOGGER.warning("WMSAPIWARN--> apiname=" + apiName + " prd=" + prd + " sttatus code=" + conn.getStatusCode());
            }
            if (CommonUtil.isEmpty(accessToken)) {
                LOGGER.warning("WMSAPIWARN--> Received accessToken empty or null. apiname=" + apiName + " prd=" + prd + " sttatus code=" + conn.getStatusCode() + " accessToken=" + accessToken);
                return false;
            }
            WCPConfManager.setAccessToken(apiName, accessToken);
            return true;
        }
        catch (Exception e) {
            if (conn != null) {
                LOGGER.log(Level.SEVERE, "NS--> Error while getting accessToken from admin. apiname=" + apiName + " prd=" + prd + " connection status code=" + conn.getStatusCode(), e);
            } else {
                LOGGER.log(Level.SEVERE, "WMSAPI--> GetAccessToken connection is not established. apiname=" + apiName + " prd=" + prd, e);
            }
            return false;
        }
    }

    private static List<String> getSeedsList(String apiName, String iscSignature) {
        if (!adminUrlMap.containsKey(apiName)) {
            LOGGER.warning("Admin URL is null or empty. apiName=" + apiName + " prd=" + prd + " adminUrl=" + adminUrlMap);
            return null;
        }
        if (CommonUtil.isEmpty(prd)) {
            LOGGER.warning("prd is null or empty. apiName=" + apiName + " prd=" + prd);
            return null;
        }
        if (securityProvider != null) {
            return securityProvider.getSeedsList(apiName, prd);
        }
        if (CommonUtil.isEmpty(iscSignature)) {
            LOGGER.warning("iscSignature is null or empty. apiName=" + apiName + " prd=" + prd + " iscSignature=" + iscSignature);
            return null;
        }
        try {
            Hashtable headers = new Hashtable();
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("prd", prd);
            params.put("apiname", apiName.toLowerCase());
            params.put("blog", apiBuildLogMap.containsKey(apiName) ? apiBuildLogMap.get(apiName) : "Unknown");
            params.put("iscsignature", iscSignature);
            params.put("withport", Boolean.toString(false));
            HttpConnection conn = new HttpConnection("http://" + adminUrlMap.get(apiName) + "/getseedsforapi.do", 20000, 5000);
            Map seedsMap = (Map)conn.doPost(params, headers);
            return (List)seedsMap.get("ips");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while getting seeds from admin. apiName=" + apiName + " prd=" + prd + " adminUrl=" + adminUrlMap.get(apiName), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshWCPDispatcherSeedsList(String poolName, String apiName, String context) {
        HashMap<String, Long> hashMap = refreshPoolNameMap;
        synchronized (hashMap) {
            Long lastRefreshTime = refreshPoolNameMap.get(poolName);
            if (lastRefreshTime == null) {
                refreshPoolNameMap.put(poolName, System.currentTimeMillis());
            } else if (System.currentTimeMillis() - lastRefreshTime < 10000L) {
                return;
            }
            try {
                ArrayList seeds_list = (ArrayList)WCPAdminUtil.getSeedsList(apiName, WCPSessionManager.getISCSign(apiName));
                WCPAPIDispatcher.setSeedList(poolName, seeds_list);
                refreshPoolNameMap.put(poolName, System.currentTimeMillis());
                LOGGER.info("WCP--> Seedlist set again " + seeds_list + " for poolname=" + poolName + " context=" + context);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "WCPERR--> Exception while resetting seeds; poolname=" + poolName + " context=" + context, e);
            }
        }
    }

    public static boolean registerInternalSeedsProvider(WCPSecurityProvider securityprovider) {
        if (securityProvider == null) {
            securityProvider = securityprovider;
            LOGGER.log(Level.INFO, "HB--> InternalSeedsProvider Registered");
            return true;
        }
        return false;
    }
}

