/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net.servlet;

import com.adventnet.wms.common.components.net.callback.WCPResponseCBListener;
import com.adventnet.wms.common.components.net.servlet.WCPRequest;
import com.adventnet.wms.common.components.net.servlet.WCPResponse;
import com.adventnet.wms.common.components.net.stats.WCPStats;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPFuture
implements Future {
    private static Logger logger = Logger.getLogger(WCPFuture.class.getName());
    protected boolean response_received = false;
    protected boolean req_canceled = false;
    protected final Condition resAvailable;
    protected final ReentrantLock lock;
    protected WCPResponseCBListener listener = null;
    protected WCPRequest req = null;
    protected WCPResponse res = null;
    protected String poolName = null;
    private long requestStartTime = System.currentTimeMillis();
    private long responseReceivedTime = 0L;

    public WCPFuture(WCPRequest req, WCPResponse res, WCPResponseCBListener listener, String poolName) {
        this.req = req;
        this.res = res;
        this.listener = listener;
        this.poolName = poolName;
        this.lock = new ReentrantLock();
        this.resAvailable = this.lock.newCondition();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.req_canceled = mayInterruptIfRunning;
        if (mayInterruptIfRunning) {
            this.lock.lock();
            try {
                this.resAvailable.signalAll();
            }
            catch (Exception ex) {
                logger.log(Level.FINE, "cancel", ex);
            }
            finally {
                this.lock.unlock();
            }
        }
        return mayInterruptIfRunning;
    }

    public WCPResponse get() {
        return this.get(this.req.getTimeOutInMillis(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WCPResponse get(long timeout, TimeUnit unit) {
        if (this.isCancelled()) {
            throw new CancellationException("WCPRequest canceled");
        }
        if (!this.response_received) {
            this.lock.lock();
            try {
                this.resAvailable.await(timeout, unit);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(WCPResponse res) {
        String responceCode = res.getResponseCode();
        this.res = res;
        this.response_received = true;
        this.calculateRequestTakenTime(responceCode);
        this.lock.lock();
        try {
            this.resAvailable.signalAll();
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "signal", ex);
        }
        finally {
            this.lock.unlock();
        }
        if (this.listener != null) {
            if (responceCode.equals("200")) {
                this.listener.onResponse(this.req, res);
            } else {
                this.listener.onError(this.req, res);
            }
        }
    }

    @Override
    public boolean isCancelled() {
        return this.req_canceled;
    }

    @Override
    public boolean isDone() {
        return this.response_received;
    }

    public WCPRequest getRequest() {
        return this.req;
    }

    public void setListener(WCPResponseCBListener listener) {
        this.listener = listener;
    }

    private void calculateRequestTakenTime(String resCode) {
        this.responseReceivedTime = System.currentTimeMillis() - this.requestStartTime;
        WCPStats.addWCPRequestTakenTime(this.poolName, this.req.getURI(), resCode, this.responseReceivedTime);
        this.res.setResponseTime(this.responseReceivedTime);
    }

    public long getResponseReceivedTime() {
        return this.responseReceivedTime;
    }
}

