/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net.connection;

import com.adventnet.wms.common.components.net.WCPClientConnPool;
import com.adventnet.wms.common.components.net.stats.WCPStats;
import com.adventnet.wms.common.components.net.util.WCPPacket;
import java.util.concurrent.atomic.AtomicLong;

public class WCPConnection {
    protected String remoteIp;
    protected AtomicLong packetId;
    protected WCPClientConnPool connPool;
    protected String sid;
    protected long connectionTime;
    protected String reason = null;
    protected String prd = null;
    protected String apiName = null;

    public WCPConnection(String prd, String apiName, String ip, long msgId, String sid, WCPClientConnPool connPool) {
        this.prd = prd;
        this.apiName = apiName;
        this.remoteIp = ip;
        this.packetId = new AtomicLong(0L);
        this.connPool = connPool;
        this.sid = sid;
        this.connectionTime = System.currentTimeMillis();
    }

    public String getRemoteIP() {
        return this.remoteIp;
    }

    public long getAvgMsgRecieveTime() {
        return 0L;
    }

    public void setWCPConnPool(WCPClientConnPool connPool) {
        this.connPool = connPool;
    }

    public void onConnect() {
    }

    public boolean writeData(WCPPacket packet) throws Exception {
        return false;
    }

    public void onMessage(byte[] data) {
    }

    public void interruptWriteThread() {
    }

    public void onClose() {
    }

    public void close() throws Exception {
    }

    public boolean isAlive() {
        return false;
    }

    public String getSID() {
        return this.sid;
    }

    public String getPrd() {
        return this.prd;
    }

    public String getApiname() {
        return this.apiName;
    }

    public long getMsgID() {
        return this.packetId.get();
    }

    protected void addConnStats(String status, String reason) {
        String poolName;
        long connLife = System.currentTimeMillis() - this.connectionTime;
        String string = poolName = this.connPool == null ? "serverconn" : this.connPool.getPoolName();
        if (reason == null) {
            reason = "object-null";
        }
        switch (status) {
            case "conn_onconnect": {
                WCPStats.addWCPConnection(this.prd, this.apiName, poolName, this.remoteIp, "conn_onconnect", "success", reason, connLife);
                break;
            }
            case "conn_onclose": {
                WCPStats.addWCPConnection(this.prd, this.apiName, poolName, this.remoteIp, "conn_onclose", "lifetime", reason, connLife);
                break;
            }
        }
    }

    public void setCloseReason(String closeReason) {
        if (this.reason == null) {
            this.reason = closeReason;
        }
    }
}

