/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net.callback;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.components.net.WCPClientConnPool;
import com.adventnet.wms.common.components.net.callback.WCPCBEvent;
import com.adventnet.wms.common.components.net.callback.WCPCBNotifyHandler;
import com.adventnet.wms.common.components.net.servlet.WCPFuture;
import com.adventnet.wms.common.components.net.servlet.WCPResponse;
import com.adventnet.wms.common.components.net.stats.WCPStats;
import com.adventnet.wms.common.components.net.util.WCPPacket;
import java.util.Hashtable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPResponseHandler {
    private Logger logger = Logger.getLogger(WCPCBNotifyHandler.class.getName());
    private ArrayBlockingQueue<Runnable> bq = null;
    private boolean closed = false;
    private WCPClientConnPool connPool = null;
    private ThreadPoolExecutor tpe = null;

    public WCPResponseHandler(WCPClientConnPool connPool, int queueSize) {
        this.connPool = connPool;
        this.bq = new ArrayBlockingQueue(queueSize);
        this.tpe = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, this.bq);
    }

    public void putData(String poolName, String ip, WCPPacket packet) {
        try {
            if (!this.closed) {
                this.tpe.execute(new WCPCallBackNotifier(new WCPCBEvent(poolName, ip, packet)));
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "putData", ex);
        }
    }

    public void closeCBNotifyHandler() {
        this.closed = true;
    }

    public void setPoolSize(int corePoolSize, int maxPoolSize) {
        this.tpe.setCorePoolSize(corePoolSize);
        this.tpe.setMaximumPoolSize(maxPoolSize);
    }

    public int getCorePoolSize() {
        return this.tpe.getCorePoolSize();
    }

    public int getMaxPoolSize() {
        return this.tpe.getMaximumPoolSize();
    }

    public long getQueueSize() {
        return this.bq.size();
    }

    class WCPCallBackNotifier
    implements Runnable {
        private Logger logger = Logger.getLogger(WCPCallBackNotifier.class.getName());
        WCPCBEvent cbe = null;

        public WCPCallBackNotifier(WCPCBEvent cbe) {
            this.cbe = cbe;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long execTime = System.currentTimeMillis();
            try {
                if (this.cbe.getWCPPacket().getPacketType() == 8) {
                    String id = this.cbe.getWCPPacket().getHeaderAsTable().get("reqid");
                    String[] splt = id.split("@");
                    String clusterName = splt[0];
                    String ip = splt[1];
                    String sid = splt[2];
                    String reqid = splt[3];
                    WCPFuture future = WCPResponseHandler.this.connPool.removeWCPFutureObj(reqid);
                    if (future != null) {
                        String data = new String(this.cbe.getWCPPacket().getPayLoadData(), "UTF-8");
                        Hashtable ht = (Hashtable)HttpDataWraper.getObject(data);
                        WCPResponse res = new WCPResponse(ht);
                        future.setResponse(res);
                    } else {
                        this.logger.info("[WCP][No WCPFutureObject][" + WCPResponseHandler.this.connPool.getPoolName() + "][" + clusterName + "][" + ip + "][" + sid + "][" + reqid + "]");
                    }
                } else {
                    this.logger.warning("Invalid packet inside WCPResponse Handler; packetType=" + this.cbe.getWCPPacket().getPacketType() + " ConnPool=" + WCPResponseHandler.this.connPool.getPoolName());
                }
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "While execute Notify", ex);
            }
            finally {
                WCPStats.addExecutionTime("WCPResponseHandler", WCPResponseHandler.this.connPool.getApiName(), WCPResponseHandler.this.connPool.getPrd(), WCPResponseHandler.this.connPool.getPoolName(), System.currentTimeMillis() - execTime);
            }
        }
    }
}

