/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.components.net.WCPAPIDispatcher;
import com.adventnet.wms.common.components.net.WCPConfManager;
import com.adventnet.wms.common.components.net.callback.WCPCBListener;
import com.adventnet.wms.common.components.net.callback.WCPMetaListener;
import com.adventnet.wms.common.components.net.servlet.WCPRequest;
import com.adventnet.wms.common.components.net.servlet.WCPResponse;
import com.adventnet.wms.common.components.net.servlet.WCPServlet;
import com.adventnet.wms.common.components.net.servlet.WCPServletMapper;
import com.adventnet.wms.common.components.net.stats.WCPStats;
import com.adventnet.wms.common.components.net.util.WCPAdminUtil;
import com.adventnet.wms.common.components.net.util.WCPPacket;
import com.adventnet.wms.common.components.net.util.WCPPacketizer;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPSessionManager {
    private static Logger logger = Logger.getLogger(WCPSessionManager.class.getName());
    private static boolean initialized = false;
    private static Hashtable<String, WCPCBListener> cbListenerMap = null;
    private static Hashtable<String, String> cbRequestIdMap = null;
    private static Hashtable<String, WCPMetaListener> metaListenerMap = null;

    public static boolean initialize() {
        if (!initialized) {
            cbListenerMap = new Hashtable();
            metaListenerMap = new Hashtable();
            cbRequestIdMap = new Hashtable();
            initialized = true;
        }
        logger.info("[WCPSessionManager - Initilized!!]");
        return initialized;
    }

    public static boolean registerCBListener(String context, WCPCBListener listnr) {
        if (!initialized) {
            return false;
        }
        if (listnr != null && context != null) {
            if (!cbListenerMap.containsKey(context)) {
                cbListenerMap.put(context, listnr);
                logger.info("[WCPSessionManager][NewListener Registered][" + context + "]");
                return true;
            }
            logger.info("HB_ERR--> CBListener already registered for context=" + context);
        }
        return false;
    }

    public static boolean registerMetaListener(String apiName, WCPMetaListener listnr) {
        if (!initialized) {
            return false;
        }
        if (listnr != null) {
            if (!metaListenerMap.containsKey(listnr)) {
                metaListenerMap.put(apiName, listnr);
                return true;
            }
            logger.info("HB_ERR--> metaListener already registered for apiName=" + apiName);
        }
        return false;
    }

    public static void returnErrorMsg(String apiName, String context, String cluster, int dataType, byte[] data, String reason) {
        try {
            WCPSessionManager.returnErrorMsg(apiName, context, cluster, dataType, new String(data, "UTF-8"), reason);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void returnErrorMsg(String apiName, String context, String poolName, int dataType, String data, String reason) {
        if (!initialized) {
            return;
        }
        if (!cbListenerMap.containsKey(context)) {
            logger.info("HB_ERR--> cbListener not found. apiName=" + apiName + " context=" + context);
            return;
        }
        long currTime = System.currentTimeMillis();
        cbListenerMap.get(context).onError(poolName, dataType, data, reason);
        WCPStats.addWCPListenerStats("on_error", poolName, System.currentTimeMillis() - currTime);
    }

    public static void processNotifyPackets(String context, String source, String ip, String data) throws Exception {
        if (!initialized) {
            return;
        }
        if (!cbListenerMap.containsKey(context)) {
            throw new Exception("CBListener Not Found");
        }
        long currTime = System.currentTimeMillis();
        cbListenerMap.get(context).onNotify(source, ip, data);
        WCPStats.addWCPListenerStats("on_notify", source, System.currentTimeMillis() - currTime);
    }

    public static void processMetaPackets(String apiName, String context, String poolName, int metaType, String data) throws Exception {
        if (!initialized) {
            return;
        }
        if (!metaListenerMap.containsKey(apiName)) {
            throw new Exception("Meta Listener Not Found");
        }
        long currTime = System.currentTimeMillis();
        switch (metaType) {
            case 1: {
                WCPAdminUtil.refreshWCPDispatcherSeedsList(poolName, apiName, context);
            }
        }
        metaListenerMap.get(apiName).onNotification(context, poolName, metaType, data);
        WCPStats.addWCPListenerStats("meta", poolName, System.currentTimeMillis() - currTime);
    }

    public static String getISCSign(String apiName) {
        if (metaListenerMap.containsKey(apiName)) {
            return metaListenerMap.get(apiName).getISCSecuritySign();
        }
        return null;
    }

    public static void sendCBResponsePacket(String resid, String reqid, String data) throws Exception {
        if (!initialized) {
            return;
        }
        cbRequestIdMap.remove(reqid);
        String[] splt = resid.split("@");
        String remoteIp = splt[0];
        String poolName = splt[1];
        if (poolName != null) {
            Hashtable<String, String> ht = new Hashtable<String, String>();
            ht.put("reqid", reqid);
            WCPPacket packet = WCPPacketizer.getPacketFromData(-1L, 15, 0L, ht, -1, data);
            try {
                if (!WCPAPIDispatcher.sendPacket(poolName, remoteIp, packet)) {
                    logger.log(Level.INFO, "Send CBResponse Packet failed");
                }
                if (WCPConfManager.isCBRequestLogsEnabled()) {
                    logger.log(Level.INFO, "WCPCB--> CBRespose sent. reqid={0} resid={1} poolName={2} remoteIp={3}", new Object[]{reqid, resid, poolName, remoteIp});
                }
            }
            catch (Exception e) {
                WCPStats.addWCPErrorStats("Exception-sendCBResponse", WCPAPIDispatcher.getApiName(poolName), WCPAPIDispatcher.getPrd(poolName), poolName, e.getMessage());
                logger.log(Level.SEVERE, "WCPERR--> Exception while sending CBResponse. reqId=" + reqid + " resId=" + resid, e);
            }
        } else {
            throw new Exception("PoolName is null. poolName=" + poolName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleWCPCBRequest(String poolName, String remoteServerType, String remoteIp, Hashtable<String, String> packetHeaders, String sid, byte[] byteArray) {
        String reqid = packetHeaders.get("reqid");
        if (!initialized) {
            logger.log(Level.WARNING, "WCP Not Initialised");
            WCPStats.addWCPErrorStats("handleWCPCBRequest-WCPNotInitialised", WCPAPIDispatcher.getApiName(poolName), WCPAPIDispatcher.getPrd(poolName), poolName, "WCPNotInitialised");
            return;
        }
        String data = null;
        try {
            data = new String(byteArray, "UTF-8");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WCPERR--> Error while converting byte array to String. reqid=" + reqid + " remoteip=" + remoteIp + " remoteservertype=" + remoteServerType, e);
            return;
        }
        Hashtable ht = (Hashtable)HttpDataWraper.getObject(data);
        WCPRequest req = new WCPRequest(ht);
        req.setRemoteIp(remoteIp);
        String resId = remoteIp + "@" + poolName;
        WCPResponse res = new WCPResponse(reqid, resId);
        cbRequestIdMap.put(reqid, resId);
        String status = null;
        WCPServlet servlet = null;
        if (WCPConfManager.isCBRequestLogsEnabled()) {
            logger.log(Level.INFO, "WCPCB--> CBRequest receiveed. servlet={0} reqid={1} poolName={2} remoteIp={3} sid={4}", new Object[]{req.getURI(), reqid, poolName, remoteIp, sid});
        }
        long currTime = System.currentTimeMillis();
        try {
            servlet = WCPServletMapper.getServlet(req.getURI());
            if (servlet != null) {
                try {
                    servlet.wcpService(req, res);
                    status = "Success";
                }
                catch (Exception e) {
                    status = "ServletException";
                    WCPStats.addWCPErrorStats(status, WCPAPIDispatcher.getApiName(poolName), WCPAPIDispatcher.getPrd(poolName), poolName, e.getMessage());
                    logger.log(Level.SEVERE, "WCPERR--> Exception in wcpService. reqid=" + reqid + " remoteip=" + remoteIp + " remoteservertype=" + remoteServerType, e);
                }
            } else {
                status = "ServletNotFound";
                WCPStats.servletNotFound(WCPAPIDispatcher.getApiName(poolName), WCPAPIDispatcher.getPrd(poolName), remoteServerType, req.getURI(), remoteIp);
                res.setResponseStr(status);
                res.setResponseCode(404);
                res.sendResponse();
            }
        }
        catch (Exception ex) {
            WCPStats.addWCPErrorStats("handleWCPCBRequest", WCPAPIDispatcher.getApiName(poolName), WCPAPIDispatcher.getPrd(poolName), poolName, ex.getMessage());
            logger.log(Level.SEVERE, "WCPERR--> Error while checking servlet mapping; poolName=" + poolName + " reqid=" + reqid + " remoteip=" + remoteIp + " remoteservertype=" + remoteServerType + " sid=" + sid, ex);
        }
        finally {
            WCPStats.addWCPCBRequestHits(WCPAPIDispatcher.getApiName(poolName), WCPAPIDispatcher.getPrd(poolName), remoteServerType, remoteIp, req.getURI(), status, System.currentTimeMillis() - currTime);
        }
    }
}

