/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net;

import com.adventnet.wms.common.components.net.WCPSessionManager;
import com.adventnet.wms.common.components.net.util.WCPAdminUtil;
import com.adventnet.wms.common.components.net.util.WCPUtil;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPConfManager {
    private static final Logger LOGGER = Logger.getLogger(WCPConfManager.class.getName());
    private static String serverIp = null;
    private static int wcpPort = 7070;
    private static boolean sslEnabled = false;
    private static String wcpURI = "/wcpapi";
    private static int wcpIPQueueSize = 1000;
    private static int wcpMaxDataPerConn = 300;
    private static int wcpMaxDataAddRetryCount = 3;
    private static int notifyHandlerCorePoolSize = 1;
    private static int responseHandlerCorePoolSize = 1;
    private static int notifyHandlerMaximumPoolSize = 1;
    private static int responseHandlerMaximumPoolSize = 1;
    private static long wcpMaxRetryTime = 60000L;
    private static long wcpMaxConnIdelTime = 180000L;
    private static long wcpMaxAckRetryTime = 30000L;
    private static int newConnectionThreshold = 30;
    private static long requestTimeOutInMillis = 10000L;
    private static String wcpLBTechnique = "rr";
    private static boolean isDebugLogsEnabled = false;
    private static boolean isCBRequestLogsEnabled = false;
    private static long wcpMaxAcceptableDataSize = 0xA00000L;
    private static Hashtable<String, String> accessTokenMap = new Hashtable();
    private static Hashtable<String, Long> lastUpdatedAccesskeyTime = new Hashtable();

    public static boolean initialize() {
        try {
            serverIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER.info("[WCP] WCP Conf Manager initialised successfully. ");
        return true;
    }

    public static int getWCPPort() {
        return wcpPort;
    }

    public static boolean isSSLEnabled() {
        return sslEnabled;
    }

    public static String getWCPURI() {
        return wcpURI;
    }

    public static int getWCPIPQueueSize() {
        return wcpIPQueueSize;
    }

    public static int getWCPMaxDataPerConn() {
        return wcpMaxDataPerConn;
    }

    public static int getNotifyHandlerCorePoolSize() {
        return notifyHandlerCorePoolSize;
    }

    public static int getNotifyHandlerMaximumPoolSize() {
        return notifyHandlerMaximumPoolSize;
    }

    public static int getResponseHandlerCorePoolSize() {
        return responseHandlerCorePoolSize;
    }

    public static int getResponseHandlerMaximumPoolSize() {
        return responseHandlerMaximumPoolSize;
    }

    public static int getWCPMaxDataAddRetryCount() {
        return wcpMaxDataAddRetryCount;
    }

    public static String getWCPLBTechnique() {
        return wcpLBTechnique;
    }

    public static String getServerIp() {
        return serverIp;
    }

    public static void setWCPMaxRetryTimeInMillis(long maxRetryTime) {
        wcpMaxRetryTime = maxRetryTime;
    }

    public static long getWCPMaxRetryTime() {
        return wcpMaxRetryTime;
    }

    public static int getNewConnectionThreshold() {
        return newConnectionThreshold;
    }

    public static long getWCPMaxConnIdelTime() {
        return wcpMaxConnIdelTime;
    }

    public static long getWCPMaxAckRetryTime() {
        return wcpMaxAckRetryTime;
    }

    public static boolean isDebugLogsEnabled() {
        return isDebugLogsEnabled;
    }

    public static void setDebugLogStatus(boolean status) {
        isDebugLogsEnabled = status;
    }

    public static long getWcpMaxAcceptableDataSize() {
        return wcpMaxAcceptableDataSize;
    }

    public static void setWcpMaxAcceptableDataSize(long size) {
        wcpMaxAcceptableDataSize = size;
    }

    public static void setWCPRequestTimeOut(long timeOutInMillis) {
        LOGGER.info("HB--> setWCPRequestTimeOut=" + timeOutInMillis + "ms");
        requestTimeOutInMillis = timeOutInMillis;
    }

    public static long getWCPRequestTimeOut() {
        return requestTimeOutInMillis;
    }

    public static void setAccessToken(String apiName, String accessToken) {
        accessTokenMap.put(apiName, accessToken);
    }

    public static void updateAccessToken(String apiName) {
        WCPConfManager.getAccessToken(apiName, true, false);
    }

    public static String getAccessToken(String apiName) {
        return WCPConfManager.getAccessToken(apiName, false, false);
    }

    public static String getAccessToken(String apiName, boolean isDomainBased) {
        return WCPConfManager.getAccessToken(apiName, false, isDomainBased);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static String getAccessToken(String apiName, boolean forceUpdate, boolean isDomainBased) {
        block17: {
            if (isDomainBased) {
                return WCPSessionManager.getISCSign(apiName);
            }
            if (!forceUpdate && WCPConfManager.accessTokenMap.containsKey(apiName)) {
                return WCPConfManager.accessTokenMap.get(apiName);
            }
            try {
                if (WCPConfManager.lastUpdatedAccesskeyTime.containsKey(apiName)) {
                    time = WCPConfManager.lastUpdatedAccesskeyTime.get(apiName);
                    if (System.currentTimeMillis() - time < 10000L) {
                        var5_6 = WCPConfManager.accessTokenMap.get(apiName);
                        return var5_6;
                    }
                }
                time = WCPUtil.getObjLock(apiName);
                // MONITORENTER : time
                if (WCPConfManager.lastUpdatedAccesskeyTime.containsKey(apiName)) {
                    time = WCPConfManager.lastUpdatedAccesskeyTime.get(apiName);
                    if (System.currentTimeMillis() - time < 10000L) {
                        var6_9 = WCPConfManager.accessTokenMap.get(apiName);
                        // MONITOREXIT : time
                        return var6_9;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [6 : 155->209)] { 
            }
lbl31:
            // 2 sources

            catch (Exception e) {
                WCPConfManager.LOGGER.log(Level.SEVERE, "WCPAPI--> Exception while getting accessToken. apiName=" + apiName, e);
                return null;
            }
            finally {
                WCPUtil.releaseObjLock(apiName);
            }
lbl-1000:
            // 1 sources

            {
                if (!WCPAdminUtil.updateAccessToken(apiName)) break block17;
                WCPConfManager.LOGGER.log(Level.INFO, "WCPAPI--> AccessToken updated successfully. apiName={0}", new Object[]{apiName});
                WCPConfManager.lastUpdatedAccesskeyTime.put(apiName, System.currentTimeMillis());
                var4_8 = WCPConfManager.accessTokenMap.get(apiName);
                // MONITOREXIT : time
            }
            WCPUtil.releaseObjLock(apiName);
            return var4_8;
        }
        WCPUtil.releaseObjLock(apiName);
        return null;
    }

    public static boolean isCBRequestLogsEnabled() {
        return isCBRequestLogsEnabled;
    }

    public static void enableCBRequestLogs() {
        LOGGER.info("WCP--> CBRequest Logs Enabled");
        isCBRequestLogsEnabled = true;
    }

    public static void disableCBRequestLogs() {
        LOGGER.info("WCP--> CBRequest Logs Disabled");
        isCBRequestLogsEnabled = false;
    }

    static {
        WCPConfManager.initialize();
    }
}

