/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.components.net.WCPAPIDispatcher;
import com.adventnet.wms.common.components.net.WCPClientConnPool;
import com.adventnet.wms.common.components.net.WCPConfManager;
import java.util.ArrayList;
import java.util.List;

public class WCPClientConnPoolConfig {
    private int port = WCPConfManager.getWCPPort();
    private int maxConn = 1;
    private int ipQueueSize = WCPConfManager.getWCPIPQueueSize();
    private int maxDataPerConn = WCPConfManager.getWCPMaxDataPerConn();
    private int newConnThreshold = WCPConfManager.getNewConnectionThreshold();
    private int maxDataAddRetryCount = WCPConfManager.getWCPMaxDataAddRetryCount();
    private int notifyHandlerCorePoolSize = WCPConfManager.getNotifyHandlerCorePoolSize();
    private int responseHandlerCorePoolSize = WCPConfManager.getResponseHandlerCorePoolSize();
    private int notifyHandlerMaximumPoolSize = WCPConfManager.getNotifyHandlerMaximumPoolSize();
    private int responseHandlerMaximumPoolSize = WCPConfManager.getResponseHandlerMaximumPoolSize();
    private String prd;
    private String uri = WCPConfManager.getWCPURI();
    private String domain = null;
    private String context;
    private String apiName;
    private String poolName;
    private String adminURL = null;
    private String buildLog = "Unknown";
    private String servingMode;
    private boolean isDomainBased = false;
    private boolean isCustomAuth = false;
    private WCPClientConnPool connPool = null;
    private List<String> seeds = new ArrayList<String>();

    public WCPClientConnPoolConfig(String poolName, String context, String prd, String apiName) {
        this.poolName = poolName;
        this.context = context;
        this.prd = prd;
        this.apiName = apiName;
    }

    public void create() throws Exception {
        WCPAPIDispatcher.createWCPConnPool(this);
    }

    public WCPClientConnPoolConfig setAdminURL(String adminURL) {
        this.adminURL = adminURL;
        return this;
    }

    WCPClientConnPoolConfig setConnPool(WCPClientConnPool connPoolMap) {
        this.connPool = connPoolMap;
        return this;
    }

    public WCPClientConnPoolConfig setBuildLog(String buildLog) {
        this.buildLog = buildLog;
        return this;
    }

    public WCPClientConnPoolConfig setIpQueueSize(int ipQueueSize) {
        this.ipQueueSize = ipQueueSize;
        return this;
    }

    public WCPClientConnPoolConfig setNewConnThreshold(int newConnThreshold) {
        this.newConnThreshold = newConnThreshold;
        return this;
    }

    public WCPClientConnPoolConfig setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public WCPClientConnPoolConfig setPort(int port) {
        this.port = port;
        return this;
    }

    public WCPClientConnPoolConfig setMaxDataPerConn(int maxDataPerConn) {
        if (this.connPool != null) {
            this.connPool.setMaxDataPerConn(maxDataPerConn);
        }
        return this;
    }

    public WCPClientConnPoolConfig setMaxDataAddRetryCount(int maxDataAddRetryCount) {
        if (this.connPool != null) {
            this.connPool.setMaxDataAddRetryCount(maxDataAddRetryCount);
        }
        return this;
    }

    public WCPClientConnPoolConfig setSeeds(List<String> seeds) throws Exception {
        if (this.connPool == null) {
            throw new Exception("WCPConnPool Not Initialized!! poolname=" + this.poolName + " seeds=" + seeds);
        }
        if (CommonUtil.isEmpty(seeds)) {
            throw new Exception("empty seeds" + this.poolName + " seeds=" + seeds);
        }
        this.connPool.manageConnections(seeds);
        this.seeds = seeds;
        return this;
    }

    public WCPClientConnPoolConfig setNotifyHandlerPoolSize(int corePoolSize, int maximumPoolSize) {
        this.connPool.setNotifyHandlerPoolSize(corePoolSize, maximumPoolSize);
        this.notifyHandlerCorePoolSize = corePoolSize;
        this.notifyHandlerMaximumPoolSize = maximumPoolSize;
        return this;
    }

    public WCPClientConnPoolConfig setResponseHandlerPoolSize(int corePoolSize, int maximumPoolSize) {
        this.connPool.setResponseHandlerPoolSize(corePoolSize, maximumPoolSize);
        this.responseHandlerCorePoolSize = corePoolSize;
        this.responseHandlerMaximumPoolSize = maximumPoolSize;
        return this;
    }

    public WCPClientConnPoolConfig setMaxConn(int maxConn) {
        this.maxConn = maxConn;
        return this;
    }

    public WCPClientConnPoolConfig setDomain(String domain) {
        this.domain = domain;
        this.isDomainBased = true;
        return this;
    }

    public WCPClientConnPoolConfig enableCustomAuth() {
        this.isCustomAuth = true;
        return this;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getContext() {
        return this.context;
    }

    public String getPrd() {
        return this.prd;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getAdminURL() {
        return this.adminURL;
    }

    public String getBuildLog() {
        return this.buildLog;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getMaxConn() {
        return this.maxConn;
    }

    public int getIpQueueSize() {
        return this.ipQueueSize;
    }

    public int getNewConnThreshold() {
        return this.newConnThreshold;
    }

    public String getUri() {
        return this.uri;
    }

    public int getPort() {
        return this.port;
    }

    public int getMaxDataPerConn() {
        return this.maxDataPerConn;
    }

    public int getMaxDataAddRetryCount() {
        return this.maxDataAddRetryCount;
    }

    public String getServingMode() {
        return this.servingMode;
    }

    public List<String> getSeeds() {
        return this.seeds;
    }

    public int getNotifyCorePoolSize() {
        return this.notifyHandlerCorePoolSize;
    }

    public int getNotifyMaximumPoolSize() {
        return this.notifyHandlerMaximumPoolSize;
    }

    public int getResponseCorePoolSize() {
        return this.responseHandlerCorePoolSize;
    }

    public int getResponseMaximumPoolSize() {
        return this.responseHandlerMaximumPoolSize;
    }

    public boolean isDomainBased() {
        return this.isDomainBased;
    }

    public boolean isCustomAuth() {
        return this.isCustomAuth;
    }
}

