/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.components.net.WCPAPIDispatcher;
import com.adventnet.wms.common.components.net.WCPClientConnPool;
import com.adventnet.wms.common.components.net.util.WCPAdminUtil;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

class SessionMonitor
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(SessionMonitor.class.getName());
    int retryLimit = 4;
    long monitorInterval = 20000L;
    long initialInterval = 45000L;

    SessionMonitor() {
    }

    @Override
    public void run() {
        LOGGER.info("WCP--> SessionMonitor Started.");
        try {
            Thread.sleep(this.initialInterval);
            block3: while (true) {
                Hashtable<String, AtomicInteger> connPoolRetryCount = new Hashtable<String, AtomicInteger>();
                int retryCount = 1;
                while (true) {
                    if (retryCount > this.retryLimit) continue block3;
                    Hashtable<String, WCPClientConnPool> connPoolMap = WCPAPIDispatcher.getConnPoolMap();
                    if (!CommonUtil.isEmpty(connPoolMap)) {
                        for (String poolName : connPoolMap.keySet()) {
                            if (WCPAPIDispatcher.getConnPoolConfig(poolName) != null && WCPAPIDispatcher.getConnPoolConfig(poolName).isDomainBased()) continue;
                            connPoolRetryCount.putIfAbsent(poolName, new AtomicInteger(0));
                            if (connPoolMap.get(poolName).hasConnections() || ((AtomicInteger)connPoolRetryCount.get(poolName)).incrementAndGet() != this.retryLimit) continue;
                            LOGGER.info("WCP--> SessionMonitor found that no sessions available for past " + (long)retryCount * this.monitorInterval / 1000L + "secs. poolName=" + poolName);
                            WCPAdminUtil.refreshWCPDispatcherSeedsList(poolName, WCPAPIDispatcher.getApiName(poolName), "ServerNotReachable");
                        }
                    }
                    Thread.sleep(this.monitorInterval);
                    ++retryCount;
                }
                break;
            }
        }
        catch (InterruptedException connPoolRetryCount) {
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while monitoring sessions.", e);
        }
    }
}

