/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.constants;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ComponentConstants {
    public static final Map<Integer, String> MODULE_MAP;
    public static final Map<Integer, HashMap<Integer, String>> ERROR_CODE_MAP;
    public static final Map<Integer, HashMap<Integer, String>> ERROR_MESSAGE_MAP;

    public static Map<Integer, String> getModuleCodeMap() {
        return MODULE_MAP;
    }

    public static Map<Integer, HashMap<Integer, String>> getErrorCodeMap() {
        return ERROR_CODE_MAP;
    }

    public static Map<Integer, HashMap<Integer, String>> getErrorMessageMap() {
        return ERROR_MESSAGE_MAP;
    }

    static {
        HashMap<Integer, String> moduleMap = new HashMap<Integer, String>();
        HashMap errorCodeMap = new HashMap();
        HashMap errorMessageMap = new HashMap();
        moduleMap.put(StatsDB.getModuleCode(), StatsDB.getModuleName());
        HashMap statsDBMap = new HashMap();
        Arrays.stream(StatsDB.values()).forEach(statsDB -> statsDBMap.put(statsDB.getErrorCode(), statsDB.toString()));
        errorCodeMap.put(StatsDB.getModuleCode(), statsDBMap);
        HashMap statsdbMap = new HashMap();
        Arrays.stream(StatsDB.values()).forEach(statsDB -> statsdbMap.put(statsDB.getErrorCode(), statsDB.getErrorMessage()));
        errorMessageMap.put(StatsDB.getModuleCode(), statsdbMap);
        MODULE_MAP = Collections.unmodifiableMap(moduleMap);
        ERROR_CODE_MAP = Collections.unmodifiableMap(errorCodeMap);
        ERROR_MESSAGE_MAP = Collections.unmodifiableMap(errorMessageMap);
    }

    public static enum StatsDB {
        INF_PROP_FILE_NOT_FOUND(1, "influxstats properties file not found"),
        STATSCONF_NOT_INITIALIZED(2, "StatsConf not initialized"),
        STATRECORD_MALFORMED(3, "StatRecord is malformed"),
        STATRECORD_NOT_INITIALIZED(4, "StatRecord is not initialized"),
        STATRECORD_COL_HEADER_MALFORMED(5, "Error in addKeyBytes"),
        STATRECORD_ERR_IN_ADD_DATA(21, "Error in addData"),
        STATRECORD_OUTOFBOUNDSEXCEPTION_IN_ADD_DATA(22, "OutOfBoundsException, either array is not defined, or extra value"),
        STATRECORD_DISPTACH_UNKNOWN_ERR(23, "Unknown error in sendData to Dispatcher method"),
        STATRECORD_STRING_TO_BYTE_CONVERSION_ERROR(24, "String to byte conversion error"),
        STATRECORD_SEND_DATA_TO_DISPATCHER_ERROR(25, "Error in sendData to Dispatcher"),
        STATRECORD_ARRAY_OUT_OF_BOUNDS_EXCEPTION(29, "OutOfBoundsException, either array is not defined, or extra value"),
        ENCODE_VALUE_EXCEPTION(30, "Encode value exception");

        private final int errorCode;
        private final String errorMessage;

        private StatsDB(int errorCode, String errorMessage) {
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public static String getModuleName() {
            return "StatsDB";
        }

        public static int getModuleCode() {
            return 100;
        }
    }
}

