/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.api.stats;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApiStats {
    private static final Logger LOGGER = Logger.getLogger(ApiStats.class.getName());
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>>>> hitCount = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, AtomicLong> retrymap = new ConcurrentHashMap();

    public static void hit(String remoteip, String url, String opr, long timetaken) {
        try {
            AtomicLong hits;
            ConcurrentHashMap<String, AtomicLong> oprmap;
            ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> urlmap;
            ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>>> remteipmap;
            if (opr == null || opr.isEmpty()) {
                opr = "unknown";
            }
            if ((remteipmap = hitCount.get(remoteip)) == null) {
                remteipmap = new ConcurrentHashMap();
                hitCount.put(remoteip, remteipmap);
            }
            if ((urlmap = remteipmap.get(url)) == null) {
                urlmap = new ConcurrentHashMap();
                remteipmap.put(url, urlmap);
            }
            if ((oprmap = urlmap.get(opr)) == null) {
                oprmap = new ConcurrentHashMap();
                urlmap.put(opr, oprmap);
            }
            if ((hits = oprmap.get("hitscount")) == null) {
                hits = new AtomicLong();
                oprmap.put("hitscount", hits);
            }
            hits.incrementAndGet();
            AtomicLong hitstime = oprmap.get("hitstime");
            if (hitstime == null) {
                hitstime = new AtomicLong();
                oprmap.put("hitstime", hitstime);
            }
            hitstime.addAndGet(timetaken);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Unable to update wms stats map", e);
        }
    }

    public static void addRetry(String ip) {
        try {
            AtomicLong counter = retrymap.get(ip);
            if (counter == null) {
                counter = new AtomicLong();
                retrymap.put(ip, counter);
            }
            counter.incrementAndGet();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Unable to update wms stats map", e);
        }
    }

    public static ConcurrentHashMap resetAndGetMap() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, Serializable>> retmap = new ConcurrentHashMap<String, ConcurrentHashMap<String, Serializable>>();
        if (!hitCount.isEmpty()) {
            ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>>>> temphitmap = hitCount;
            hitCount = new ConcurrentHashMap();
            retmap.put("hitdata", temphitmap);
        }
        if (!retrymap.isEmpty()) {
            ConcurrentHashMap<String, AtomicLong> tempretrymap = retrymap;
            retrymap = new ConcurrentHashMap();
            retmap.put("retrydata", tempretrymap);
        }
        return retmap;
    }
}

