/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.components.event.WmsEventMetricListener;
import com.adventnet.wms.common.components.event.constants.WmsEventStatsConstants;
import com.adventnet.wms.common.exception.WMSEventException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.logging.Logger;

public class WmsEvent
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(WmsEvent.class.getName());
    private static WmsEventMetricListener wmsEventListener = null;
    private Hashtable header = null;
    private Hashtable data = null;
    private long ctime = -1L;
    private int signature = 0;

    public static boolean registerEventListner(WmsEventMetricListener eventListener) {
        if (wmsEventListener != null) {
            LOGGER.warning("Wms Event listener already registered.. " + wmsEventListener);
            return false;
        }
        wmsEventListener = eventListener;
        LOGGER.warning("Wms Event listener registered successfully.. " + wmsEventListener);
        return true;
    }

    private void recordEventCreation(WmsEventStatsConstants.EventCreation ec) {
        if (wmsEventListener != null) {
            wmsEventListener.onCreation(ec, this);
        }
    }

    private void recordEventWrap(WmsEventStatsConstants.EventWrap ew) {
        if (wmsEventListener != null) {
            wmsEventListener.onWrap(ew, this);
        }
    }

    private void recordMethodUsage(WmsEventStatsConstants.EventMethodInvocation emi) {
        if (wmsEventListener != null) {
            wmsEventListener.onMethodInvocation(emi, this);
        }
    }

    public WmsEvent() {
        this.header = new Hashtable();
        this.data = new Hashtable();
        this.ctime = System.currentTimeMillis();
        this.recordEventCreation(WmsEventStatsConstants.EventCreation.NEW);
    }

    public WmsEvent(Hashtable event) {
        this.header = (Hashtable)event.get("header");
        this.data = (Hashtable)event.get("data");
        this.ctime = event.containsKey("ctime") ? (Long)event.get("ctime") : System.currentTimeMillis();
        if (event.containsKey("signature")) {
            this.signature = (Integer)event.get("signature");
        }
        this.recordEventCreation(WmsEventStatsConstants.EventCreation.OTHERS);
    }

    public WmsEvent(Hashtable event, WmsEventStatsConstants.EventCreation ec) {
        this.header = (Hashtable)event.get("header");
        this.data = (Hashtable)event.get("data");
        this.ctime = event.containsKey("ctime") ? (Long)event.get("ctime") : System.currentTimeMillis();
        if (event.containsKey("signature")) {
            this.signature = (Integer)event.get("signature");
        }
        this.recordEventCreation(ec);
    }

    public Hashtable wrap() {
        return this.wrap(WmsEventStatsConstants.EventWrap.OTHERS);
    }

    protected Hashtable wrap(WmsEventStatsConstants.EventWrap ew) {
        Hashtable<String, Serializable> event = new Hashtable<String, Serializable>();
        event.put("header", this.header);
        event.put("data", this.data);
        event.put("ctime", Long.valueOf(this.ctime));
        event.put("signature", Integer.valueOf(this.sign()));
        this.recordEventWrap(ew);
        return event;
    }

    public void setTaskPriority(int priority) {
        this.putHeader("tpriority", Integer.toString(priority));
    }

    public int getTaskPriority() {
        if (this.getHeader("tpriority") != null) {
            return Integer.parseInt(this.getHeader("tpriority"));
        }
        return 0;
    }

    public void setDispatchPriority(int priority) {
        this.putHeader("dpriority", Integer.toString(priority));
    }

    public int getDispatchPriority() {
        if (this.getHeader("dpriority") != null) {
            return Integer.parseInt(this.getHeader("dpriority"));
        }
        return 0;
    }

    public void updateCreatedTime() {
        this.ctime = System.currentTimeMillis();
    }

    public long getCreatedTime() {
        return this.ctime;
    }

    public long getAge() {
        return System.currentTimeMillis() - this.ctime;
    }

    public void putHeader(String key, String value) {
        this.header.put(key, value);
    }

    public void putHeader(String key, Object value) {
        this.header.put(key, value);
    }

    public String getHeader(String key) {
        return (String)this.header.get(key);
    }

    public Object getHeaderAsObject(String key) {
        return this.header.get(key);
    }

    public Object removeHeader(String key) {
        return this.header.remove(key);
    }

    public void enableTrace() {
        this.header.put("tracelogging", "true");
    }

    public boolean isTraceEnabled() {
        if (this.getHeader("tracelogging") == null) {
            return false;
        }
        return this.getHeader("tracelogging").equals("true");
    }

    public void setBounceDetails(Hashtable details) {
        this.header.put("bounce", details);
    }

    public Hashtable getBounceDetails() {
        return (Hashtable)this.header.remove("bounce");
    }

    public void putData(String key, Object value) {
        this.data.put(key, value);
    }

    public boolean isBounced() {
        return this.header.containsKey("bounce");
    }

    public void reroute() throws WMSEventException {
        String strCount = (String)this.header.get("reroute");
        if (strCount == null) {
            strCount = "0";
        }
        int count = new Integer(strCount);
        if (++count >= 3) {
            throw new WMSEventException("Max Reroute exceeded");
        }
        this.header.put("reroute", Integer.toString(count));
    }

    public void updateRetryTime() {
        this.header.put("retrytime", Long.toString(System.currentTimeMillis()));
    }

    public long getRetryTime() {
        String retrytime = (String)this.header.get("retrytime");
        if (retrytime == null) {
            return 0L;
        }
        return Long.parseLong(retrytime);
    }

    public long getRetryDuration() {
        String retrytime = (String)this.header.get("retrytime");
        if (retrytime == null) {
            return 0L;
        }
        return System.currentTimeMillis() - Long.parseLong(retrytime);
    }

    public boolean isDataExists(String key) {
        return this.data.containsKey(key);
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    public String getDataAsString(String key) {
        return (String)this.getData(key);
    }

    public long getDataAsLong(String key) {
        return new Long(this.getDataAsString(key));
    }

    public Object removeData(String key) {
        return this.data.remove(key);
    }

    public void setRCV(String rcv) {
        this.header.put("rcv", rcv);
    }

    public String getRCV() {
        return (String)this.header.get("rcv");
    }

    public void setOpr(String opr) {
        this.header.put("opr", opr);
        String[] oprArray = opr.split("\\.");
        if (oprArray.length == 2) {
            this.setTaskEngine(oprArray[0]);
            this.setTask(oprArray[1]);
        }
    }

    public String getOpr() {
        return (String)this.header.get("opr");
    }

    public void setManager(String manager) {
        this.header.put("tmname", manager);
    }

    public String getManager() {
        return (String)this.header.get("tmname");
    }

    public void setTaskEngine(String taskEngine) {
        this.header.put("_tename", taskEngine);
    }

    public String getTaskEngine() {
        return (String)this.header.get("_tename");
    }

    public void setTask(String taskName) {
        this.header.put("_taskname", taskName);
    }

    public String getTaskName() {
        return (String)this.header.get("_taskname");
    }

    public void setSeqID(String seqID) {
        this.header.put("seqID", seqID);
    }

    public String getSeqID() {
        return (String)this.header.get("seqID");
    }

    public void setExpiryTime(long time) {
        this.header.put("_expirytime", time);
    }

    public long getExpiryTime() {
        try {
            if (this.header.containsKey("_expirytime")) {
                return (Long)this.header.get("_expiryTime");
            }
            return 0L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public void clearRKey() {
        this.removeHeader("rkey");
    }

    public void setRKey(String rkey) {
        this.header.put("rkey", rkey);
    }

    public void addRKey(String rkey) {
        String oldrkey = (String)this.header.get("rkey");
        if (oldrkey == null) {
            this.header.put("rkey", rkey);
        } else {
            Hashtable rkeys = CommonUtil.getHash(oldrkey);
            rkeys.put(rkey, "");
            this.header.put("rkey", CommonUtil.getString(rkeys));
        }
    }

    public void setEntityId(String entityid) {
        this.data.put("eid", entityid);
    }

    public void addEntityID(String entityid) {
        String oldeid = (String)this.data.get("eid");
        if (oldeid == null) {
            this.data.put("eid", entityid);
        } else {
            Hashtable eids = CommonUtil.getHash(oldeid);
            eids.put(entityid, "");
            this.data.put("eid", CommonUtil.getString(eids));
        }
    }

    public String getEntityId() {
        return (String)this.data.get("eid");
    }

    public void clearEntityId() {
        this.removeData("eid");
    }

    public String getRKey() {
        return (String)this.header.get("rkey");
    }

    public void updateRoute(String route) {
        String rpath = (String)this.header.get("rpath");
        try {
            if (rpath.length() > 0) {
                rpath = rpath + "," + route;
            }
        }
        catch (NullPointerException npe) {
            rpath = route;
        }
        this.header.put("rpath", rpath);
    }

    public String getRPath() {
        return (String)this.header.get("rpath");
    }

    public String getMessage() {
        Hashtable<String, Object> msg = new Hashtable<String, Object>();
        msg.put("prd", this.getData("prd"));
        msg.put("mtype", this.getData("mtype"));
        msg.put("msg", this.getData("msg"));
        if (this.getData("mdsessions") != null) {
            msg.put("mdsessions", this.getData("mdsessions"));
        }
        if (this.getData("_meta") != null) {
            msg.put("meta", this.getData("_meta"));
        }
        return HttpDataWraper.getString(msg);
    }

    public Hashtable getMessageObj() {
        return (Hashtable)HttpDataWraper.getObject(this.getMessage());
    }

    public boolean isValidMessage() {
        return this.data.containsKey("opr") && this.data.containsKey("prd") && this.data.containsKey("msg");
    }

    public WmsEvent duplicate() {
        return new WmsEvent((Hashtable)HttpDataWraper.getObject(HttpDataWraper.getString(this.wrap(WmsEventStatsConstants.EventWrap.DUPLICATION))), WmsEventStatsConstants.EventCreation.DUPLICATION);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append("header=").append(this.header).append(" data=").append(this.data).append(" ctime=").append(this.ctime).append(" sign=").append(this.sign());
        this.recordMethodUsage(WmsEventStatsConstants.EventMethodInvocation.TO_STRING);
        return sb.toString();
    }

    public String getDebugString() {
        this.recordMethodUsage(WmsEventStatsConstants.EventMethodInvocation.GET_DEBUG_STRING);
        return "header=" + this.header + " ctime=" + this.ctime + " opr=" + this.getOpr() + " mtype=" + this.getData("mtype") + " prd=" + this.getData("prd") + " sid=" + this.getData("sid") + " wmsid=" + this.getData("wmsid") + " mdsessions=" + this.getData("mdsessions");
    }

    public void trackOpr(String exec_type) {
        if (this.header.get("opr_path") != null) {
            this.header.put("opr_path", this.header.get("opr_path") + "," + exec_type + "-" + this.header.get("opr"));
        } else {
            this.header.put("opr_path", exec_type + "-" + this.header.get("opr"));
        }
        this.recordMethodUsage(WmsEventStatsConstants.EventMethodInvocation.TRACK_OPR);
    }

    public int sign() {
        this.signature = this.header.hashCode() + this.data.hashCode();
        return this.signature;
    }

    public boolean isTampered() {
        return this.sign() != this.header.hashCode() + this.data.hashCode();
    }
}

