/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class RoutingCluster {
    private String version;
    private int crange;
    private ArrayList<String> serverlist = new ArrayList();
    private SortedMap<Integer, String> circle = new TreeMap<Integer, String>();
    private SortedMap<String, String> servers = new TreeMap<String, String>();

    public RoutingCluster(Hashtable details) {
        this.version = (String)details.get("rcv");
        this.crange = new Integer((String)details.get("crange"));
        ArrayList iplist = (ArrayList)details.get("ips_v1");
        if (iplist != null) {
            Iterator it = iplist.iterator();
            while (it.hasNext()) {
                String[] key = ((String)it.next()).split("@");
                String node = key[0];
                this.servers.put(node, "");
                int replicas = new Integer(key[1]);
                for (int i = 0; i < replicas; ++i) {
                    this.circle.put(this.getHashCode(node + i), node);
                }
            }
        } else {
            Hashtable ips = (Hashtable)details.get("ips");
            Enumeration e = ips.keys();
            while (e.hasMoreElements()) {
                String node = (String)e.nextElement();
                this.servers.put(node, "");
                int replicas = new Integer((String)ips.get(node));
                for (int i = 0; i < replicas; ++i) {
                    this.circle.put(this.getHashCode(node + i), node);
                }
            }
        }
        this.serverlist = new ArrayList<String>(this.servers.keySet());
        System.out.println(" rcv :" + this.circle + " servers :" + this.servers);
    }

    private Integer getHashCode(String str) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(str.getBytes());
            return Math.abs(new BigInteger(1, md5.digest()).intValue()) % this.crange;
        }
        catch (Exception e) {
            return str.hashCode();
        }
    }

    public String getServer(String key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        int hashCode = this.getHashCode(key);
        if (!this.circle.containsKey(hashCode)) {
            SortedMap<Integer, String> tailMap = this.circle.tailMap(hashCode);
            hashCode = tailMap.isEmpty() ? this.circle.firstKey().intValue() : tailMap.firstKey().intValue();
        }
        return (String)this.circle.get(hashCode);
    }

    public String getBackupServer(String server) {
        if (this.servers.isEmpty()) {
            return null;
        }
        SortedMap<String, String> headMap = this.servers.headMap(server);
        if (headMap.isEmpty()) {
            return this.servers.lastKey();
        }
        return headMap.lastKey();
    }

    public String getAlternateServer(String server) {
        if (this.servers.isEmpty()) {
            return null;
        }
        SortedMap<String, String> headMap = this.servers.headMap(server);
        if (headMap.isEmpty()) {
            return this.servers.lastKey();
        }
        return headMap.lastKey();
    }

    public Set getServers() {
        return Collections.unmodifiableSet(this.servers.keySet());
    }

    public String getRandomServer() {
        if (this.serverlist.size() == 1) {
            return this.serverlist.get(0);
        }
        return this.serverlist.get(new Random().nextInt(this.serverlist.size() - 1));
    }

    public boolean isMember(String wnet) {
        return this.servers.containsKey(wnet);
    }

    public int getAvailableNodesCount() {
        return this.servers.size();
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isSameVersion(RoutingCluster rc) {
        return this.getVersion().equals(rc.getVersion());
    }

    public String toString() {
        return "version=" + this.version + " circle=" + this.circle;
    }
}

