/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class LockManager {
    private ConcurrentHashMap<String, AtomicInteger> lmap = new ConcurrentHashMap();
    private int max = 0;

    public synchronized Object lock(String str) {
        AtomicInteger lock = this.lmap.get(str);
        if (lock == null) {
            lock = new AtomicInteger();
        } else {
            lock.incrementAndGet();
        }
        this.lmap.put(str, lock);
        this.max = this.lmap.size() > this.max ? this.lmap.size() : this.max;
        return lock;
    }

    public synchronized void release(String str) {
        AtomicInteger lock = this.lmap.get(str);
        if (lock != null) {
            if (lock.intValue() == 0) {
                this.lmap.remove(str);
            } else {
                lock.decrementAndGet();
            }
        }
    }

    public int getMax() {
        return this.max;
    }

    public int size() {
        return this.lmap.size();
    }
}

