/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.common.components.event.constants.WmsEventStatsConstants;
import com.adventnet.wms.common.service.callback.WMSServiceCBEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpDataWraper {
    private static final Logger LOGGER = Logger.getLogger(HttpDataWraper.class.getName());

    public static String getString(Object obj) {
        try {
            if (obj instanceof WmsEvent) {
                return HttpDataWraper.constructJSON(((WmsEvent)obj).wrap(WmsEventStatsConstants.EventWrap.HTTP_DATA_WRAPER), false).toString();
            }
            if (obj instanceof Hashtable) {
                return HttpDataWraper.constructJSON((Hashtable)obj, false).toString();
            }
            if (obj instanceof ArrayList) {
                return HttpDataWraper.constructJSON((ArrayList)obj, false).toString();
            }
            if (obj instanceof Map) {
                return HttpDataWraper.constructJSON((Map)obj, false).toString();
            }
            if (obj instanceof WMSServiceCBEvent) {
                return HttpDataWraper.constructJSON(((WMSServiceCBEvent)obj).wrap(), false).toString();
            }
            return obj.toString();
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Error inside getString obj=" + obj, exp);
            return null;
        }
    }

    public static String getValuesAsString(Object obj) {
        try {
            if (obj instanceof WmsEvent) {
                return HttpDataWraper.constructJSON(((WmsEvent)obj).wrap(WmsEventStatsConstants.EventWrap.HTTP_DATA_WRAPER), true).toString();
            }
            if (obj instanceof Hashtable) {
                return HttpDataWraper.constructJSON((Hashtable)obj, true).toString();
            }
            if (obj instanceof ArrayList) {
                return HttpDataWraper.constructJSON((ArrayList)obj, true).toString();
            }
            if (obj instanceof Map) {
                return HttpDataWraper.constructJSON((Map)obj, true).toString();
            }
            return obj.toString();
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Error inside getValuesAsString obj=" + obj, exp);
            return null;
        }
    }

    public static Object clone(Object obj) {
        try {
            if (obj instanceof Hashtable) {
                return (Hashtable)HttpDataWraper.getObject(HttpDataWraper.getString(obj));
            }
            if (obj instanceof ArrayList) {
                return (ArrayList)HttpDataWraper.getObject(HttpDataWraper.getString(obj));
            }
            return obj;
        }
        catch (Exception exp) {
            return null;
        }
    }

    private static JSONObject constructJSON(Hashtable ht, boolean converttostr) throws Exception {
        JSONObject obj = new JSONObject();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = ht.get(key);
            if (value instanceof WmsEvent) {
                obj.put("" + key, (Object)HttpDataWraper.constructJSON(((WmsEvent)value).wrap(WmsEventStatsConstants.EventWrap.HTTP_DATA_WRAPER), converttostr));
                continue;
            }
            if (value instanceof Hashtable) {
                obj.put("" + key, (Object)HttpDataWraper.constructJSON((Hashtable)value, converttostr));
                continue;
            }
            if (value instanceof ArrayList) {
                obj.put("" + key, (Object)HttpDataWraper.constructJSON((ArrayList)value, converttostr));
                continue;
            }
            if (value instanceof Map) {
                obj.put("" + key, (Object)HttpDataWraper.constructJSON((Map)value, converttostr));
                continue;
            }
            obj.put("" + key, converttostr ? "" + value : value);
        }
        return obj;
    }

    private static JSONObject constructJSON(Map hm, boolean converttostr) throws Exception {
        JSONObject obj = new JSONObject();
        for (Object key : hm.keySet()) {
            Object value = hm.get(key);
            if (value instanceof WmsEvent) {
                obj.put("" + key, (Object)HttpDataWraper.constructJSON(((WmsEvent)value).wrap(WmsEventStatsConstants.EventWrap.HTTP_DATA_WRAPER), converttostr));
                continue;
            }
            if (value instanceof Hashtable) {
                obj.put("" + key, (Object)HttpDataWraper.constructJSON((Hashtable)value, converttostr));
                continue;
            }
            if (value instanceof Map) {
                obj.put("" + key, (Object)HttpDataWraper.constructJSON((Map)value, converttostr));
                continue;
            }
            if (value instanceof ArrayList) {
                obj.put("" + key, (Object)HttpDataWraper.constructJSON((ArrayList)value, converttostr));
                continue;
            }
            obj.put("" + key, converttostr ? "" + value : value);
        }
        return obj;
    }

    private static JSONArray constructJSON(ArrayList al, boolean converttostr) throws Exception {
        JSONArray ar = new JSONArray();
        for (Object value : al) {
            if (value instanceof WmsEvent) {
                ar.put((Object)HttpDataWraper.constructJSON(((WmsEvent)value).wrap(WmsEventStatsConstants.EventWrap.HTTP_DATA_WRAPER), converttostr));
                continue;
            }
            if (value instanceof Hashtable) {
                ar.put((Object)HttpDataWraper.constructJSON((Hashtable)value, converttostr));
                continue;
            }
            if (value instanceof ArrayList) {
                ar.put((Object)HttpDataWraper.constructJSON((ArrayList)value, converttostr));
                continue;
            }
            if (value instanceof Map) {
                ar.put((Object)HttpDataWraper.constructJSON((Map)value, converttostr));
                continue;
            }
            ar.put(converttostr ? "" + value : value);
        }
        return ar;
    }

    public static Object getObject(String jstr) {
        try {
            if (jstr.startsWith("{")) {
                return HttpDataWraper.getObject(new JSONObject(jstr));
            }
            if (jstr.startsWith("[")) {
                return HttpDataWraper.getObject(new JSONArray(jstr));
            }
            return jstr;
        }
        catch (Exception exp) {
            return null;
        }
    }

    private static Hashtable getObject(JSONObject jo) throws Exception {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        Iterator it = jo.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = jo.get(key);
            if (value instanceof JSONObject) {
                ht.put(key, HttpDataWraper.getObject((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                ht.put(key, HttpDataWraper.getObject((JSONArray)value));
                continue;
            }
            ht.put(key, value);
        }
        return ht;
    }

    private static ArrayList getObject(JSONArray ja) throws Exception {
        ArrayList<Object> al = new ArrayList<Object>();
        for (int i = 0; i < ja.length(); ++i) {
            Object value = ja.get(i);
            if (value instanceof JSONObject) {
                al.add(HttpDataWraper.getObject((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                al.add(HttpDataWraper.getObject((JSONArray)value));
                continue;
            }
            al.add(value);
        }
        return al;
    }

    public static WmsEvent getEvent(String jstr) {
        return new WmsEvent((Hashtable)HttpDataWraper.getEventObject(jstr), WmsEventStatsConstants.EventCreation.HTTP_DATA_WRAPER);
    }

    public static WMSServiceCBEvent getWMSServiceCBEvent(String jstr) {
        return new WMSServiceCBEvent((Hashtable)HttpDataWraper.getEventObject(jstr));
    }

    private static Object getEventObject(String jstr) {
        try {
            if (jstr.startsWith("{")) {
                return HttpDataWraper.getEventObject(new JSONObject(jstr));
            }
            if (jstr.startsWith("[")) {
                return HttpDataWraper.getEventObject(new JSONArray(jstr));
            }
            return jstr;
        }
        catch (Exception exp) {
            return null;
        }
    }

    private static Hashtable getEventObject(JSONObject jo) throws Exception {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        Iterator it = jo.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = jo.get(key);
            if (value instanceof JSONObject) {
                ht.put(key, HttpDataWraper.getEventObject((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                ht.put(key, HttpDataWraper.getEventObject((JSONArray)value));
                continue;
            }
            if (value == JSONObject.NULL) continue;
            ht.put(key, value);
        }
        return ht;
    }

    private static ArrayList getEventObject(JSONArray ja) throws Exception {
        ArrayList<Object> al = new ArrayList<Object>();
        for (int i = 0; i < ja.length(); ++i) {
            Object value = ja.get(i);
            if (value instanceof JSONObject) {
                al.add(HttpDataWraper.getEventObject((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                al.add(HttpDataWraper.getEventObject((JSONArray)value));
                continue;
            }
            if (value == JSONObject.NULL) {
                al.add(null);
                continue;
            }
            al.add(value);
        }
        return al;
    }
}

