/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.WmsResponse;
import com.adventnet.wms.common.exception.WMSCommunicationException;
import com.adventnet.wms.common.exception.WMSException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpConnection {
    private static final Logger logger = Logger.getLogger(HttpConnection.class.getName());
    protected String url;
    protected Hashtable params = new Hashtable();
    protected Hashtable headers = new Hashtable();
    protected int connectTimeOut = 3000;
    protected int readTimeOut = 20000;
    protected int statuscode = 0;
    private String trackingId;
    private static AtomicLong counter = new AtomicLong();
    private boolean noproxy = true;
    private Proxy proxy = null;
    private String postStringBody = "";
    private byte[] postByteBody = new byte[0];

    public HttpConnection(String url) {
        this.url = url;
        this.noproxy = System.getProperty("wms.noproxy") == null || System.getProperty("wms.noproxy").equals("true");
    }

    public HttpConnection(String url, int readTimeOut) {
        this(url);
        this.readTimeOut = readTimeOut;
        this.noproxy = System.getProperty("wms.noproxy") == null || System.getProperty("wms.noproxy").equals("true");
    }

    public HttpConnection(String url, int readTimeOut, int connectTimeOut) {
        this(url, readTimeOut);
        this.connectTimeOut = connectTimeOut;
        this.noproxy = System.getProperty("wms.noproxy") == null || System.getProperty("wms.noproxy").equals("true");
    }

    public void addParameter(String key, Object value) {
        this.params.put(key, HttpDataWraper.getString(value));
    }

    public void addHeader(String key, String value) {
        if (value == null) {
            return;
        }
        this.headers.put(key, "" + value);
    }

    public void addTrackingId(String ip) {
        this.trackingId = ip + "_" + counter;
        counter.incrementAndGet();
        this.addHeader("Tracking-Id", this.trackingId);
    }

    public void setProxy(Proxy proxy) {
        this.noproxy = false;
        this.proxy = proxy;
    }

    public WmsResponse getRequest() throws WMSException {
        Object response = this.doGet();
        return new WmsResponse(this.statuscode, response);
    }

    public Object doGet() throws WMSException {
        return this.doGet(null, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doGet(Hashtable params, Hashtable headers) throws WMSException {
        Object object;
        StringBuilder response;
        block16: {
            HttpURLConnection uc;
            block15: {
                response = new StringBuilder();
                BufferedReader reader = null;
                uc = null;
                try {
                    String paramstring;
                    if (params != null) {
                        this.params = params;
                    }
                    if (headers != null) {
                        this.headers = headers;
                    }
                    uc = !CommonUtil.isEmpty(paramstring = this.getParamString()) ? this.openConnection(this.url + "?" + paramstring) : this.openConnection(this.url);
                    uc.setReadTimeout(this.readTimeOut);
                    uc.setConnectTimeout(this.connectTimeOut);
                    uc.setDoInput(true);
                    uc.setDoOutput(true);
                    uc.setUseCaches(false);
                    this.setHeaders(uc);
                    this.statuscode = uc.getResponseCode();
                    uc.connect();
                    reader = new BufferedReader(new InputStreamReader(uc.getInputStream(), "UTF-8"));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    if (reader == null) break block15;
                }
                catch (WMSException we) {
                    try {
                        logger.log(Level.WARNING, "WMSException in doGet", we);
                        throw we;
                        catch (IOException ie) {
                            if (uc == null) throw new WMSCommunicationException("Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
                            throw new WMSCommunicationException(this.statuscode, this.getErrorStream(uc), "Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
                        }
                        catch (Exception exp) {
                            throw new WMSException("Communication Error : doGet : {0}", this.getRestrainedURL(this.url));
                        }
                    }
                    catch (Throwable throwable) {
                        if (reader == null) {
                            this.disconnect(uc);
                            throw throwable;
                        }
                        try {
                            reader.close();
                            throw throwable;
                        }
                        catch (Exception exp) {
                            this.disconnect(uc);
                            throw throwable;
                        }
                    }
                }
                try {
                    reader.close();
                }
                catch (Exception exp) {
                    this.disconnect(uc);
                }
                break block16;
            }
            this.disconnect(uc);
        }
        Object data = HttpDataWraper.getObject(response.toString());
        if (data != null) {
            object = data;
            return object;
        }
        object = response.toString();
        return object;
    }

    public WmsResponse postRequest() throws WMSException {
        Object response = this.doPost();
        return new WmsResponse(this.statuscode, response);
    }

    public Object doPost() throws WMSException {
        return this.doPost((Hashtable)null, null);
    }

    public Object doPostAndBufferResponse(String responseDelimiter) throws WMSException {
        StringBuilder response = new StringBuilder();
        ArrayList<Object> bufferedResponseList = new ArrayList<Object>();
        BufferedReader reader = null;
        HttpURLConnection uc = null;
        try {
            uc = this.openConnection(this.url);
            uc.setReadTimeout(this.readTimeOut);
            uc.setConnectTimeout(this.connectTimeOut);
            uc.setDoInput(true);
            uc.setDoOutput(true);
            uc.setUseCaches(false);
            this.setHeaders(uc);
            uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            OutputStreamWriter writer = new OutputStreamWriter(uc.getOutputStream());
            writer.write(this.getParamString());
            writer.flush();
            writer.close();
            this.statuscode = uc.getResponseCode();
            reader = new BufferedReader(new InputStreamReader(uc.getInputStream(), "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.equals(responseDelimiter)) {
                    try {
                        Object dat = HttpDataWraper.getObject(response.toString());
                        bufferedResponseList.add(dat);
                        response = new StringBuilder();
                        continue;
                    }
                    catch (Exception xc) {
                        logger.log(Level.WARNING, "Exception in doPostAndBufferResponse", xc);
                    }
                }
                response.append(line);
            }
        }
        catch (WMSException we) {
            throw we;
        }
        catch (IOException ie) {
            if (uc != null) {
                throw new WMSCommunicationException(this.statuscode, this.getErrorStream(uc), "Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
            }
            throw new WMSCommunicationException("Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
        }
        catch (Exception exp) {
            logger.fine("Communication Error : doPost : " + this.getRestrainedURL(this.url) + " : " + this.getExceptionCause(exp));
            throw new WMSException("Communication Error : doPost : {0}", this.getRestrainedURL(this.url));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exp) {
                    this.disconnect(uc);
                }
            } else {
                this.disconnect(uc);
            }
        }
        if (bufferedResponseList.size() > 0) {
            return bufferedResponseList;
        }
        Object data = HttpDataWraper.getObject(response.toString());
        return data != null ? data : response.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doPost(Hashtable params, Hashtable headers) throws WMSException {
        Object object;
        StringBuilder response;
        block16: {
            HttpURLConnection uc;
            block15: {
                response = new StringBuilder();
                BufferedReader reader = null;
                uc = null;
                try {
                    if (params != null) {
                        this.params = params;
                    }
                    if (headers != null) {
                        this.headers = headers;
                    }
                    uc = this.openConnection(this.url);
                    uc.setReadTimeout(this.readTimeOut);
                    uc.setConnectTimeout(this.connectTimeOut);
                    uc.setDoInput(true);
                    uc.setDoOutput(true);
                    uc.setUseCaches(false);
                    this.setHeaders(uc);
                    uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                    OutputStreamWriter writer = new OutputStreamWriter(uc.getOutputStream());
                    writer.write(this.getParamString());
                    writer.flush();
                    writer.close();
                    this.statuscode = uc.getResponseCode();
                    reader = new BufferedReader(new InputStreamReader(uc.getInputStream(), "UTF-8"));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    if (reader == null) break block15;
                }
                catch (WMSException we) {
                    try {
                        throw we;
                        catch (IOException ie) {
                            if (uc == null) throw new WMSCommunicationException("Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
                            throw new WMSCommunicationException(this.statuscode, this.getErrorStream(uc), "Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
                        }
                        catch (Exception exp) {
                            logger.fine("Communication Error : doPost : " + this.getRestrainedURL(this.url) + " : " + this.getExceptionCause(exp));
                            throw new WMSException("Communication Error : doPost : {0}", this.getRestrainedURL(this.url));
                        }
                    }
                    catch (Throwable throwable) {
                        if (reader == null) {
                            this.disconnect(uc);
                            throw throwable;
                        }
                        try {
                            reader.close();
                            throw throwable;
                        }
                        catch (Exception exp) {
                            this.disconnect(uc);
                            throw throwable;
                        }
                    }
                }
                try {
                    reader.close();
                }
                catch (Exception exp) {
                    this.disconnect(uc);
                }
                break block16;
            }
            this.disconnect(uc);
        }
        Object data = HttpDataWraper.getObject(response.toString());
        if (data != null) {
            object = data;
            return object;
        }
        object = response.toString();
        return object;
    }

    public Object doPost(Hashtable params, Hashtable headers, String body) throws WMSException {
        return this.doPost(params, headers, body, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doPost(Hashtable params, Hashtable headers, String body, String contentType) throws WMSException {
        Object object;
        StringBuilder response;
        block19: {
            HttpURLConnection uc;
            block18: {
                response = new StringBuilder();
                BufferedReader reader = null;
                uc = null;
                try {
                    OutputStreamWriter writer;
                    String paramstring;
                    if (params != null) {
                        this.params = params;
                    }
                    if (headers != null) {
                        this.headers = headers;
                    }
                    uc = !CommonUtil.isEmpty(paramstring = this.getParamString()) ? this.openConnection(this.url + "?" + paramstring) : this.openConnection(this.url);
                    uc.setReadTimeout(this.readTimeOut);
                    uc.setConnectTimeout(this.connectTimeOut);
                    uc.setDoInput(true);
                    uc.setDoOutput(true);
                    uc.setUseCaches(false);
                    this.setHeaders(uc);
                    if (!CommonUtil.isEmpty(body)) {
                        if (!CommonUtil.isEmpty(contentType)) {
                            uc.setRequestProperty("Content-Type", contentType);
                        } else {
                            uc.setRequestProperty("Content-Type", "text/html; charset=utf-8");
                        }
                        uc.setRequestProperty("Content-Length", "" + body.getBytes("UTF-8").length);
                        writer = new OutputStreamWriter(uc.getOutputStream());
                        writer.write(body);
                        writer.flush();
                        writer.close();
                    } else {
                        uc.setRequestProperty("Content-Type", "text/html; charset=utf-8");
                        uc.setRequestProperty("Content-Length", "0");
                        writer = new OutputStreamWriter(uc.getOutputStream());
                        writer.close();
                    }
                    this.statuscode = uc.getResponseCode();
                    reader = new BufferedReader(new InputStreamReader(uc.getInputStream(), "UTF-8"));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    if (reader == null) break block18;
                }
                catch (IOException ie) {
                    try {
                        if (uc == null) throw new WMSCommunicationException("Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
                        throw new WMSCommunicationException(this.statuscode, this.getErrorStream(uc), "Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
                        catch (Exception exp) {
                            logger.fine("Communication Error : doPost : " + this.getRestrainedURL(this.url) + " : " + this.getExceptionCause(exp));
                            throw new WMSException("Communication Error : doPost : {0}", this.getRestrainedURL(this.url));
                        }
                    }
                    catch (Throwable throwable) {
                        if (reader == null) {
                            this.disconnect(uc);
                            throw throwable;
                        }
                        try {
                            reader.close();
                            throw throwable;
                        }
                        catch (Exception exp) {
                            this.disconnect(uc);
                            throw throwable;
                        }
                    }
                }
                try {
                    reader.close();
                }
                catch (Exception exp) {
                    this.disconnect(uc);
                }
                break block19;
            }
            this.disconnect(uc);
        }
        Object data = HttpDataWraper.getObject(response.toString());
        if (data != null) {
            object = data;
            return object;
        }
        object = response.toString();
        return object;
    }

    public Object doDelete() throws WMSException {
        return this.doDelete(null, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doDelete(Hashtable params, Hashtable headers) throws WMSException {
        Object object;
        StringBuilder response;
        block15: {
            HttpURLConnection uc;
            block14: {
                response = new StringBuilder();
                BufferedReader reader = null;
                uc = null;
                try {
                    String paramstring;
                    if (params != null) {
                        this.params = params;
                    }
                    if (headers != null) {
                        this.headers = headers;
                    }
                    uc = !CommonUtil.isEmpty(paramstring = this.getParamString()) ? this.openConnection(this.url + "?" + paramstring) : this.openConnection(this.url);
                    uc.setRequestMethod("DELETE");
                    uc.setReadTimeout(this.readTimeOut);
                    uc.setConnectTimeout(this.connectTimeOut);
                    uc.setUseCaches(false);
                    this.setHeaders(uc);
                    this.statuscode = uc.getResponseCode();
                    reader = new BufferedReader(new InputStreamReader(uc.getInputStream(), "UTF-8"));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    if (reader == null) break block14;
                }
                catch (IOException ie) {
                    try {
                        if (uc == null) throw new WMSCommunicationException("Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
                        throw new WMSCommunicationException(this.statuscode, this.getErrorStream(uc), "Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
                        catch (Exception exp) {
                            logger.fine("Communication Error : doDelete : " + this.getRestrainedURL(this.url) + " : " + this.getExceptionCause(exp));
                            throw new WMSException("Communication Error : doDelete : {0}", this.getRestrainedURL(this.url));
                        }
                    }
                    catch (Throwable throwable) {
                        if (reader == null) {
                            this.disconnect(uc);
                            throw throwable;
                        }
                        try {
                            reader.close();
                            throw throwable;
                        }
                        catch (Exception exp) {
                            this.disconnect(uc);
                            throw throwable;
                        }
                    }
                }
                try {
                    reader.close();
                }
                catch (Exception exp) {
                    this.disconnect(uc);
                }
                break block15;
            }
            this.disconnect(uc);
        }
        Object data = HttpDataWraper.getObject(response.toString());
        if (data != null) {
            object = data;
            return object;
        }
        object = response.toString();
        return object;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doPut(String body, Hashtable headers) throws WMSException {
        Object object;
        StringBuilder response;
        block14: {
            HttpURLConnection uc;
            block13: {
                response = new StringBuilder();
                BufferedReader reader = null;
                uc = null;
                try {
                    String paramstring;
                    if (headers != null) {
                        this.headers = headers;
                    }
                    uc = !CommonUtil.isEmpty(paramstring = this.getParamString()) ? this.openConnection(this.url + "?" + paramstring) : this.openConnection(this.url);
                    uc.setRequestMethod("PUT");
                    uc.setReadTimeout(this.readTimeOut);
                    uc.setConnectTimeout(this.connectTimeOut);
                    uc.setDoInput(true);
                    uc.setDoOutput(true);
                    uc.setUseCaches(false);
                    this.setHeaders(uc);
                    OutputStreamWriter writer = new OutputStreamWriter(uc.getOutputStream());
                    writer.write(body);
                    writer.flush();
                    writer.close();
                    this.statuscode = uc.getResponseCode();
                    reader = new BufferedReader(new InputStreamReader(uc.getInputStream(), "UTF-8"));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    if (reader == null) break block13;
                }
                catch (IOException ie) {
                    try {
                        if (uc == null) throw new WMSCommunicationException("Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
                        throw new WMSCommunicationException(this.statuscode, this.getErrorStream(uc), "Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
                        catch (Exception exp) {
                            logger.fine("Communication Error : doPut : " + this.getRestrainedURL(this.url) + " : " + this.getExceptionCause(exp));
                            throw new WMSException("Communication Error : doPut : {0}", this.getRestrainedURL(this.url));
                        }
                    }
                    catch (Throwable throwable) {
                        if (reader == null) {
                            this.disconnect(uc);
                            throw throwable;
                        }
                        try {
                            reader.close();
                            throw throwable;
                        }
                        catch (Exception exp) {
                            this.disconnect(uc);
                            throw throwable;
                        }
                    }
                }
                try {
                    reader.close();
                }
                catch (Exception exp) {
                    this.disconnect(uc);
                }
                break block14;
            }
            this.disconnect(uc);
        }
        Object data = HttpDataWraper.getObject(response.toString());
        if (data != null) {
            object = data;
            return object;
        }
        object = response.toString();
        return object;
    }

    private void setPostBody(String body) {
        this.postStringBody = body;
    }

    private void setPostBody(byte[] body) {
        this.postByteBody = body;
    }

    public Object doPost(String body, Hashtable headers) throws WMSException {
        this.setPostBody(body);
        return this.doPost(headers);
    }

    public Object doPost(byte[] body, Hashtable headers) throws WMSException {
        this.setPostBody(body);
        return this.doPost(headers);
    }

    public Hashtable getHeaders() {
        return this.headers;
    }

    public Object doPost(Hashtable headers) throws WMSException {
        StringBuilder response = new StringBuilder();
        BufferedReader reader = null;
        HttpURLConnection uc = null;
        if (!this.postStringBody.equals("") && this.postByteBody.length > 0) {
            throw new WMSException("PostBody set multiple times");
        }
        try {
            Closeable writer;
            if (headers != null) {
                this.headers = headers;
            }
            uc = this.openConnection(this.url);
            uc.setReadTimeout(this.readTimeOut);
            uc.setConnectTimeout(this.connectTimeOut);
            uc.setDoInput(true);
            uc.setDoOutput(true);
            uc.setUseCaches(false);
            this.setHeaders(uc);
            if (!this.headers.containsKey("Content-Type")) {
                uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            }
            if (this.postByteBody.length > 0) {
                writer = uc.getOutputStream();
                ((OutputStream)writer).write(this.postByteBody);
                ((OutputStream)writer).flush();
                ((OutputStream)writer).close();
            } else {
                writer = new OutputStreamWriter(uc.getOutputStream());
                if (!this.postStringBody.equals("")) {
                    ((Writer)writer).write(this.postStringBody);
                } else {
                    ((Writer)writer).write("");
                }
                ((OutputStreamWriter)writer).flush();
                ((OutputStreamWriter)writer).close();
            }
            this.statuscode = uc.getResponseCode();
            reader = new BufferedReader(new InputStreamReader(uc.getInputStream(), "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        catch (IOException ie) {
            if (uc != null) {
                throw new WMSCommunicationException(this.statuscode, this.getErrorStream(uc), "Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
            }
            throw new WMSCommunicationException("Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
        }
        catch (Exception exp) {
            logger.fine("Communication Error : doPost : " + this.getRestrainedURL(this.url) + " : " + this.getExceptionCause(exp));
            throw new WMSException("Communication Error : doPost : {0}", this.getRestrainedURL(this.url));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exp) {
                    this.disconnect(uc);
                }
            } else {
                this.disconnect(uc);
            }
        }
        Object data = HttpDataWraper.getObject(response.toString());
        return data != null ? data : response.toString();
    }

    public Object doPost(String body) throws WMSException {
        StringBuilder response = new StringBuilder();
        BufferedReader reader = null;
        HttpURLConnection uc = null;
        try {
            uc = this.openConnection(this.url);
            uc.setReadTimeout(this.readTimeOut);
            uc.setConnectTimeout(this.connectTimeOut);
            uc.setDoInput(true);
            uc.setDoOutput(true);
            uc.setUseCaches(false);
            this.setHeaders(uc);
            if (!this.headers.containsKey("Content-Type")) {
                uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            }
            OutputStreamWriter writer = new OutputStreamWriter(uc.getOutputStream());
            writer.write(body);
            writer.flush();
            writer.close();
            this.statuscode = uc.getResponseCode();
            reader = new BufferedReader(new InputStreamReader(uc.getInputStream(), "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        catch (IOException ie) {
            if (uc != null) {
                throw new WMSCommunicationException(this.statuscode, this.getErrorStream(uc), "Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
            }
            throw new WMSCommunicationException("Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
        }
        catch (Exception exp) {
            logger.fine("Communication Error : doPost : " + this.getRestrainedURL(this.url) + " : " + this.getExceptionCause(exp));
            throw new WMSException("Communication Error : doPost : {0}", this.getRestrainedURL(this.url));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exp) {
                    this.disconnect(uc);
                }
            } else {
                this.disconnect(uc);
            }
        }
        Object data = HttpDataWraper.getObject(response.toString());
        return data != null ? data : response.toString();
    }

    public InputStream getStream() throws WMSException {
        HttpURLConnection uc = null;
        try {
            String paramstring = this.getParamString();
            uc = !CommonUtil.isEmpty(paramstring) ? this.openConnection(this.url + "?" + paramstring) : this.openConnection(this.url);
            uc.setReadTimeout(this.readTimeOut);
            uc.setConnectTimeout(this.connectTimeOut);
            uc.setDoInput(true);
            uc.setDoOutput(true);
            uc.setUseCaches(false);
            this.setHeaders(uc);
            this.statuscode = uc.getResponseCode();
            if (this.statuscode == 404 || this.statuscode == 409 || this.statuscode == 503) {
                throw new WMSException("" + this.statuscode);
            }
            uc.connect();
            return uc.getInputStream();
        }
        catch (WMSException we) {
            logger.log(Level.WARNING, "WMSException in getStream", we);
            throw we;
        }
        catch (IOException ie) {
            if (uc != null) {
                throw new WMSCommunicationException(this.statuscode, this.getErrorStream(uc), "Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
            }
            throw new WMSCommunicationException("Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
        }
        catch (Exception exp) {
            logger.fine("Communication Error : getStream : " + this.getRestrainedURL(this.url) + " : " + this.getExceptionCause(exp));
            throw new WMSException("Communication Error : getStream : {0}", this.getRestrainedURL(this.url));
        }
    }

    public URLConnection getConnection() throws WMSException {
        return this.getConnection(false);
    }

    public URLConnection getConnection(boolean includeparams) throws WMSException {
        HttpURLConnection uc = null;
        try {
            String paramstring = this.getParamString();
            uc = includeparams && !CommonUtil.isEmpty(paramstring) ? this.openConnection(this.url + "?" + paramstring) : this.openConnection(this.url);
            uc.setReadTimeout(this.readTimeOut);
            uc.setConnectTimeout(this.connectTimeOut);
            uc.setDoInput(true);
            uc.setDoOutput(true);
            uc.setUseCaches(false);
            this.setHeaders(uc);
            uc.connect();
            return uc;
        }
        catch (IOException ie) {
            throw new WMSCommunicationException("Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
        }
        catch (Exception exp) {
            logger.fine("Communication Error : getOutputStream : " + this.url + " : " + this.getExceptionCause(exp));
            throw new WMSException("Communication Error : getStream : {0}", this.getRestrainedURL(this.url));
        }
    }

    protected void setHeaders(URLConnection uc) {
        Enumeration e = this.headers.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.headers.get(key);
            uc.setRequestProperty(key, value);
        }
    }

    protected String getParamString() throws WMSException {
        StringBuffer pstr = new StringBuffer();
        if (this.params == null) {
            return "";
        }
        Enumeration e = this.params.keys();
        String key = null;
        String value = null;
        try {
            if (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = (String)this.params.get(key);
                pstr.append(URLEncoder.encode(key, "UTF-8"));
                pstr.append("=");
                pstr.append(URLEncoder.encode(value, "UTF-8"));
            }
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = (String)this.params.get(key);
                pstr.append("&");
                pstr.append(URLEncoder.encode(key, "UTF-8"));
                pstr.append("=");
                pstr.append(URLEncoder.encode(value, "UTF-8"));
            }
        }
        catch (Exception exp) {
            throw new WMSException("Invalid param / value [" + key + "]=" + value);
        }
        return pstr.toString();
    }

    public int getStatusCode() {
        return this.statuscode;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    protected HttpURLConnection openConnection(String url) throws Exception {
        if (this.noproxy) {
            return (HttpURLConnection)new URL(url).openConnection(Proxy.NO_PROXY);
        }
        if (this.proxy == null) {
            return (HttpURLConnection)new URL(url).openConnection();
        }
        return (HttpURLConnection)new URL(url).openConnection(this.proxy);
    }

    public static void main(String[] args) throws Exception {
        HttpConnection con = new HttpConnection("http://localhost:6060/testsv1");
        con.addParameter("p1", "v1");
        con.addParameter("p2", "v2");
        System.out.println(con.doPost());
    }

    protected String getRestrainedURL(String url) {
        return this.eraseURI(url);
    }

    private String eraseURI(String url) {
        try {
            return url.replaceAll("[?][-a-zA-Z0-9+&@#?/%=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]", "");
        }
        catch (Exception exception) {
            return "";
        }
    }

    private InputStream getErrorStream(HttpURLConnection uc) {
        try {
            StringBuilder error_response = new StringBuilder();
            InputStream stream = uc.getErrorStream();
            BufferedReader err_reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            String line = null;
            while ((line = err_reader.readLine()) != null) {
                error_response.append(line);
            }
            return new ByteArrayInputStream(error_response.toString().getBytes("UTF-8"));
        }
        catch (Exception exception) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private void disconnect(HttpURLConnection uc) {
        if (uc != null) {
            // empty if block
        }
    }

    protected String getExceptionCause(Exception ex) {
        return this.eraseURI("" + ex);
    }

    public HttpURLConnection getStreamingConnection(boolean includeparams, long contentLength) throws WMSException, HttpRetryException {
        HttpURLConnection uc = null;
        try {
            String paramstring = this.getParamString();
            uc = includeparams && !CommonUtil.isEmpty(paramstring) ? this.openConnection(this.url + "?" + paramstring) : this.openConnection(this.url);
            uc.setReadTimeout(this.readTimeOut);
            uc.setConnectTimeout(this.connectTimeOut);
            uc.setFixedLengthStreamingMode(contentLength);
            uc.setDoInput(true);
            uc.setDoOutput(true);
            uc.setUseCaches(false);
            this.setHeaders(uc);
            uc.connect();
            return uc;
        }
        catch (HttpRetryException hr) {
            logger.log(Level.WARNING, "Http Retry Exception: ", hr);
            throw new WMSException("HTTP Retry Exception - " + hr);
        }
        catch (IOException ie) {
            throw new WMSCommunicationException("Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
        }
        catch (Exception exp) {
            logger.fine("Communication Error : getOutputStream : " + this.url + " : " + this.getExceptionCause(exp));
            throw new WMSException("Communication Error : getStream : {0}", this.getRestrainedURL(this.url));
        }
    }

    public HttpURLConnection getChunkedStreamingConnection(boolean includeparams) throws WMSException {
        HttpURLConnection uc = null;
        try {
            String paramstring = this.getParamString();
            uc = includeparams && !CommonUtil.isEmpty(paramstring) ? this.openConnection(this.url + "?" + paramstring) : this.openConnection(this.url);
            uc.setReadTimeout(this.readTimeOut);
            uc.setConnectTimeout(this.connectTimeOut);
            uc.setChunkedStreamingMode(10000);
            uc.setDoInput(true);
            uc.setDoOutput(true);
            uc.setUseCaches(false);
            this.setHeaders(uc);
            uc.connect();
            return uc;
        }
        catch (HttpRetryException hr) {
            logger.log(Level.WARNING, "Http Retry Exception: ", hr);
            throw new WMSException("HTTP Retry Exception - " + hr);
        }
        catch (IOException ie) {
            throw new WMSCommunicationException("Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
        }
        catch (Exception exp) {
            logger.fine("Communication Error : getOutputStream : " + this.url + " : " + this.getExceptionCause(exp));
            throw new WMSException("Communication Error : getStream : {0}", this.getRestrainedURL(this.url));
        }
    }
}

