/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common;

public class ChatId {
    private String chid = "-1";
    private String wmschid = "-1";
    private String prd;
    private String restorekey;
    private String threadid;

    public ChatId(String parentChatid, String threadChatid) {
        String[] ids = parentChatid.split("_", 3);
        if (ids.length == 3) {
            this.prd = ids[0];
            this.restorekey = ids[2];
        }
        this.wmschid = threadChatid;
        this.chid = parentChatid + "-T-" + threadChatid;
        this.threadid = threadChatid;
    }

    public ChatId(String prd, String wmschid, String restorekey) {
        this.prd = prd;
        this.wmschid = wmschid;
        this.restorekey = restorekey;
        this.chid = prd + "_" + wmschid + "_" + restorekey;
    }

    public ChatId(String chid) {
        this.chid = chid;
        if (chid.indexOf("-T-") != -1) {
            String[] ids = chid.split("-T-");
            String[] keys = ids[0].split("_");
            if (keys.length == 3) {
                this.prd = keys[0];
                this.restorekey = keys[2];
            }
            this.wmschid = ids[1];
            this.threadid = ids[1];
        } else {
            String[] ids = chid.split("_", 3);
            if (ids.length == 3) {
                this.prd = ids[0];
                this.wmschid = ids[1];
                this.restorekey = ids[2];
            } else {
                this.wmschid = chid;
            }
        }
    }

    public ChatId(int chid) {
        this("" + chid);
    }

    public String getPrd() {
        return this.prd;
    }

    public String getWmsChid() {
        return this.wmschid;
    }

    public String getRestoreKey() {
        return this.restorekey;
    }

    public String get() {
        return this.chid;
    }

    public static String parseRestoreKey(String id) {
        String[] ids;
        String[] keys;
        if (id.indexOf("-T-") != -1 && (keys = (ids = id.split("-T-"))[0].split("_")).length == 3) {
            return keys[2];
        }
        ids = id.split("_", 3);
        if (ids.length == 3) {
            return ids[2];
        }
        return null;
    }

    public static String parsePrd(String id) {
        String[] ids;
        String[] keys;
        if (id.indexOf("-T-") != -1 && (keys = (ids = id.split("-T-"))[0].split("_")).length == 3) {
            return keys[2];
        }
        ids = id.split("_", 3);
        if (ids.length == 3) {
            return ids[0];
        }
        return null;
    }

    public static String parseWmsChid(String id) {
        if (id.indexOf("-T-") != -1) {
            String[] ids = id.split("-T-");
            return ids[1];
        }
        String[] ids = id.split("_", 3);
        if (ids.length == 3) {
            return ids[1];
        }
        return id;
    }

    public static String parseUniqueId(String id) {
        if (id.indexOf("-T-") != -1) {
            return ChatId.getThreadId(id);
        }
        return ChatId.parseWmsChid(id);
    }

    public static ChatId valueOf(String id) {
        return new ChatId(id);
    }

    public static boolean isValid(String id) {
        String[] ids = id.split("_", 3);
        return ids.length == 3 || ids.length == 1;
    }

    public static String getThreadId(String id) {
        if (id.indexOf("-T-") != -1) {
            String[] ids = id.split("-T-");
            return ids[1];
        }
        return null;
    }

    public static boolean isThreadChat(String chid) {
        return chid.indexOf("-T-") > 0;
    }

    public static String getRoutingChid(String chid) {
        if (ChatId.isThreadChat(chid)) {
            return chid.split("-T-")[0];
        }
        return chid;
    }
}

