/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.wfs.cassandra;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxManager;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.wfs.WFSConfManager;
import com.adventnet.wms.servercommon.wfs.stats.WFSStats;
import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WFSCassandraManager {
    private static Logger logger = Logger.getLogger(WFSCassandraManager.class.getName());
    public static final String CLUSTER_NAME = "WFS";
    private static String cassandraloc;
    private static String cassandradc;
    private static String cassandraUserName;
    private static String cassandraPassword;
    private static String cassandraProtocolVersion;
    private static String cassandrakeyspace;
    private static Map<String, ProtocolVersion> protocolVersionHash;
    private static DatastaxSession session;

    public static boolean initialize() {
        try {
            cassandraloc = WFSConfManager.getCassandraloc();
            cassandrakeyspace = WFSConfManager.getCassandrakeyspace();
            cassandradc = WFSConfManager.getCassandradc();
            cassandraUserName = WFSConfManager.getCassandraUserName();
            cassandraPassword = WFSConfManager.getCassandraPassword();
            cassandraProtocolVersion = WFSConfManager.getCassandraProtocolVersion();
            protocolVersionHash = Collections.unmodifiableMap(new Hashtable<String, ProtocolVersion>(){
                {
                    this.put("v1", ProtocolVersion.V1);
                    this.put("v2", ProtocolVersion.V2);
                    this.put("v3", ProtocolVersion.V3);
                    this.put("v4", ProtocolVersion.V4);
                }
            });
            if (session == null) {
                Hashtable<DatastaxManager.ClusterProp, Object> clusterprops = new Hashtable<DatastaxManager.ClusterProp, Object>();
                clusterprops.put(DatastaxManager.ClusterProp.CLUSTERNAME, CLUSTER_NAME);
                clusterprops.put(DatastaxManager.ClusterProp.CONTACTPOINTS, cassandraloc.split(","));
                clusterprops.put(DatastaxManager.ClusterProp.PROTOCOLVERSION, protocolVersionHash.get(cassandraProtocolVersion));
                clusterprops.put(DatastaxManager.ClusterProp.COMPRESSION, ProtocolOptions.Compression.NONE);
                clusterprops.put(DatastaxManager.ClusterProp.LOADBALANCINGPOLICY, new TokenAwarePolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withLocalDc(cassandradc).build()));
                clusterprops.put(DatastaxManager.ClusterProp.QUERYOPTIONS, new QueryOptions().setConsistencyLevel(ConsistencyLevel.ONE));
                if (!CommonUtil.isEmpty((String)cassandraUserName) && !CommonUtil.isEmpty((String)cassandraPassword)) {
                    clusterprops.put(DatastaxManager.ClusterProp.AUTHPROVIDER, new PlainTextAuthProvider(cassandraUserName, cassandraPassword));
                } else {
                    clusterprops.put(DatastaxManager.ClusterProp.AUTHPROVIDER, AuthProvider.NONE);
                }
                session = DatastaxManager.initialize(CLUSTER_NAME, cassandrakeyspace, clusterprops, false);
            }
            logger.log(Level.INFO, "WFS--> Initializing cassandra cluster:{0}", new Object[]{session});
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WFS-->[WFSEXCEPTION] Error initializing CassandraManager ", e);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_CASSANDRA_NOTINITIALIZE.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_CASSANDRA_NOTINITIALIZE");
            return false;
        }
    }

    public static DatastaxSession getSession() {
        if (session == null) {
            WFSCassandraManager.initialize();
        }
        return session;
    }

    static {
        cassandradc = "DC1";
        cassandraProtocolVersion = "v4";
        cassandrakeyspace = "\"WFS\"";
        protocolVersionHash = new Hashtable<String, ProtocolVersion>();
    }
}

