/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.wfs;

import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.wfs.WFD;
import com.adventnet.wms.servercommon.wfs.WFSConfManager;
import com.adventnet.wms.servercommon.wfs.cassandra.WFSAtticCF;
import com.adventnet.wms.servercommon.wfs.cassandra.WFSUtil;
import com.adventnet.wms.servercommon.wfs.dfs.DFS;
import com.adventnet.wms.servercommon.wfs.stats.WFSStats;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WFSCleanupManager {
    private static Logger logger = Logger.getLogger(WFSCleanupManager.class.getName());
    private static WFSCleanupManager instance = null;
    private static boolean isShutDown = false;
    private static Hashtable<String, Long> atticCleanup = new Hashtable();
    private static Hashtable<String, WFSCleanup> cleanupHandler = new Hashtable();

    private WFSCleanupManager() {
        for (String key : atticCleanup.keySet()) {
            String[] data = key.split("_");
            if (data.length != 2 || cleanupHandler.get(key) != null) continue;
            WFSCleanup cleanup = new WFSCleanup(data[0], data[1], (long)atticCleanup.get(key));
            cleanup.start();
            cleanupHandler.put(key, cleanup);
        }
    }

    public static void close() {
        isShutDown = true;
        instance = null;
    }

    public static boolean initialize() {
        WFSCleanupManager cleanup;
        WFSCleanupManager.close();
        if (WFSConfManager.getAtticCleanupConf() != null) {
            atticCleanup = WFSConfManager.getAtticCleanupConf();
        }
        if ((cleanup = WFSCleanupManager.getInstance()) != null) {
            logger.log(Level.INFO, "WFS--> WFSCleanup initialized");
            return true;
        }
        return false;
    }

    private static WFSCleanupManager getInstance() {
        isShutDown = false;
        if (instance == null) {
            instance = new WFSCleanupManager();
        }
        return instance;
    }

    private class WFSCleanup
    extends Thread {
        private String storage;
        private String folderName;
        private long cleanupInterval;

        WFSCleanup(String storage, String folderName, long cleanupInterval) {
            this.storage = storage;
            this.folderName = folderName;
            this.cleanupInterval = cleanupInterval;
        }

        @Override
        public void run() {
            while (!isShutDown) {
                int atticCassandraLimit;
                long dTime = System.currentTimeMillis() - this.cleanupInterval;
                UUID end = WFSUtil.Cassandra.getTimeUUID(dTime);
                ArrayList result = WFSAtticCF.getData(this.storage, this.folderName, null, end, null, null, atticCassandraLimit = WFSConfManager.getAtticCassandraLimit());
                if (result.size() == 0) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                ExecutorService worker_threadPool = Executors.newFixedThreadPool(WFSConfManager.getAtticThreadCount());
                for (int i = 0; i < result.size(); ++i) {
                    Hashtable value = (Hashtable)result.get(i);
                    WFD wfd = new WFD((String)value.get("data"));
                    if (wfd.getScopeID() == null || wfd.getEntityID() == null || value.get("date") == null || value.get("dtime") == null) continue;
                    worker_threadPool.submit(new AtticClean(wfd, (String)value.get("date"), (String)value.get("dtime")));
                }
                try {
                    worker_threadPool.shutdown();
                    if (worker_threadPool.awaitTermination(10L, TimeUnit.MINUTES)) continue;
                    worker_threadPool.shutdownNow();
                }
                catch (InterruptedException ex) {
                    worker_threadPool.shutdownNow();
                }
            }
        }
    }

    class AtticClean
    extends Thread {
        WFD wfd = null;
        String date = null;
        String dtime = null;

        AtticClean(WFD wfd, String date, String dtime) {
            this.wfd = wfd;
            this.date = date;
            this.dtime = dtime;
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            if (DFS.deleteFile(this.wfd.getScopeID(), this.wfd.getBlockID(), this.wfd.getDfsFilePath())) {
                WFSStats.addWFSOverallStat(DC.getServertype(), this.wfd.getStorage(), this.wfd.getFolderName(), "DFS", "DELETE", System.currentTimeMillis() - startTime);
                WFSAtticCF.delete(this.wfd.getStorage(), this.wfd.getFolderName(), this.date, UUID.fromString(this.dtime), this.wfd.getEntityID(), this.wfd.getSourcePath());
            }
        }
    }
}

