/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.wfs;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.wfs.WFSConfManager;
import java.util.Hashtable;

public class WFD {
    private static final String STORAGEID = "storageID";
    private static final String ENTITYID = "entityID";
    private static final String SOURCEPATH = "sourcePath";
    private static final String FOLDERNAME = "folderName";
    private static final String DFSFILEPATH = "dfsFilePath";
    private static final String BLOCKID = "blockID";
    private static final String SIZE = "size";
    private static final String TUUID = "tuuid";
    private static final String SCOPEID = "scopeID";
    private static final String ISENCRYPT = "isEncrypt";
    private Hashtable<String, String> data = new Hashtable();

    public WFD(String storageID, String entityID, String sourcePath, String folderName, String dfsFilePath, String blockID, long size, String tuuid, String scopeID, boolean isEncrypt) {
        this.data.put(STORAGEID, storageID);
        this.data.put(ENTITYID, entityID);
        this.data.put(SOURCEPATH, sourcePath);
        this.data.put(FOLDERNAME, folderName);
        this.data.put(DFSFILEPATH, dfsFilePath);
        this.data.put(BLOCKID, blockID);
        this.data.put(SIZE, Long.toString(size));
        this.data.put(TUUID, tuuid);
        this.data.put(SCOPEID, scopeID);
        this.data.put(ISENCRYPT, Boolean.toString(isEncrypt));
    }

    public WFD(String dataString) {
        if (dataString != null && HttpDataWraper.getObject((String)dataString) != null && HttpDataWraper.getObject((String)dataString) instanceof Hashtable) {
            this.data = (Hashtable)HttpDataWraper.getObject((String)dataString);
            if (this.data.get(ISENCRYPT) == null) {
                this.data.put(ISENCRYPT, Boolean.toString(WFSConfManager.isFileEncryptionEnabled()));
            }
        }
    }

    public String toString() {
        return HttpDataWraper.getString(this.data);
    }

    public Hashtable<String, String> getData() {
        return this.data;
    }

    public String getStorage() {
        return this.data.get(STORAGEID);
    }

    public String getEntityID() {
        return this.data.get(ENTITYID);
    }

    public String getSourcePath() {
        return this.data.get(SOURCEPATH);
    }

    public String getFolderName() {
        return this.data.get(FOLDERNAME);
    }

    public String getDfsFilePath() {
        return this.data.get(DFSFILEPATH);
    }

    public long getSize() {
        return this.data.get(SIZE) != null ? Long.parseLong(this.data.get(SIZE)) : 0L;
    }

    public String getTuuid() {
        return this.data.get(TUUID);
    }

    public String getScopeID() {
        return this.data.get(SCOPEID);
    }

    public String getBlockID() {
        return this.data.get(BLOCKID);
    }

    public boolean isEncrypt() {
        return Boolean.parseBoolean(this.data.get(ISENCRYPT));
    }
}

