/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class TarUtil {
    private static final Logger LOGGER = Logger.getLogger(TarUtil.class.getName());

    private TarUtil() {
    }

    public static void compress(String tarFile, File ... files) throws IOException {
        try (TarArchiveOutputStream out = TarUtil.getTarArchiveOutputStream(tarFile);){
            for (File file : files) {
                TarUtil.addToArchiveCompression(out, file, ".");
            }
        }
    }

    public static void decompress(String in, File out) throws IOException {
        try (TarArchiveInputStream fin = new TarArchiveInputStream((InputStream)new FileInputStream(in));){
            TarArchiveEntry entry;
            while ((entry = fin.getNextTarEntry()) != null) {
                if (entry.isDirectory()) continue;
                File curfile = new File(out, entry.getName());
                File parent = curfile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                IOUtils.copy((InputStream)fin, (OutputStream)new FileOutputStream(curfile));
            }
        }
    }

    private static TarArchiveOutputStream getTarArchiveOutputStream(String name) throws IOException {
        TarArchiveOutputStream taos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(name));
        taos.setBigNumberMode(1);
        taos.setLongFileMode(2);
        taos.setAddPaxHeadersForNonAsciiNames(true);
        return taos;
    }

    private static void addToArchiveCompression(TarArchiveOutputStream out, File file, String dir) throws IOException {
        String entry = dir + File.separator + file.getName();
        if (file.isFile()) {
            out.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(file, entry));
            try (FileInputStream in = new FileInputStream(file);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            out.closeArchiveEntry();
        } else if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    TarUtil.addToArchiveCompression(out, child, entry);
                }
            }
        } else {
            LOGGER.log(Level.WARNING, "{0} is not supported", file.getName());
        }
    }
}

