/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUtil {
    private static final Logger LOGGER = Logger.getLogger(FileUtil.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(String filePath) {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(new File(filePath));
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            br = new BufferedReader(isr);
            String line = null;
            StringBuilder content = new StringBuilder();
            while ((line = br.readLine()) != null) {
                content.append(line + "\r\n");
            }
            String string = content.toString();
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
            try {
                isr.close();
            }
            catch (Exception exception) {}
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getFileAsProperties(String filePath) {
        FileInputStream fis = null;
        Properties props = new Properties();
        try {
            fis = new FileInputStream(filePath);
            props.load(fis);
            Properties properties = props;
            return properties;
        }
        catch (Exception exception) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public static File[] getFolders(String path, boolean desc) {
        File dir = new File(path);
        File[] list = null;
        list = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (desc) {
            Arrays.sort(list, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return Long.valueOf(f2.lastModified()).compareTo(f1.lastModified());
                }
            });
        }
        return list;
    }

    public static File[] getFileList(String path, String filterstr, boolean desc) {
        File dir = new File(path);
        File[] list = null;
        final String match = filterstr;
        list = filterstr != null ? dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().indexOf(match) > -1;
            }
        }) : dir.listFiles();
        if (desc) {
            Arrays.sort(list, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return Long.valueOf(f2.lastModified()).compareTo(f1.lastModified());
                }
            });
        }
        return list;
    }

    public static boolean isFileExists(String fpath) {
        File f = new File(fpath);
        return f.exists();
    }

    public static byte[] readAllBytes(File file) {
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "NS_ERR--> Error while reading from file " + file.toPath(), e);
            return null;
        }
    }

    public static boolean writeAllBytes(byte[] fileContent, File file) {
        File dir = new File(file.getParent());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            Path path = Paths.get(file.getAbsolutePath(), new String[0]);
            Files.write(path, fileContent, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "NS_ERR--> Error while writing from file " + file.toPath(), e);
            return false;
        }
    }

    public static InputStream getInputStream(String filePath) throws FileNotFoundException {
        return FileUtil.getInputStream(new File(filePath));
    }

    public static InputStream getInputStream(File file) throws FileNotFoundException {
        FileInputStream inputStream = null;
        inputStream = new FileInputStream(file);
        return inputStream;
    }

    public static boolean fileTransfer(InputStream is, OutputStream os, int streamSize) throws Exception {
        if (is == null || os == null) {
            throw new NullPointerException();
        }
        if (streamSize < 1) {
            throw new Exception("invalid streamSize");
        }
        byte[] buffer = new byte[streamSize];
        try {
            int length;
            while ((length = is.read(buffer)) > -1) {
                os.write(buffer, 0, length);
                os.flush();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, " Error while tranferring file. ", e);
            throw e;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, " Error while closing input stream. ", e);
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, " Error while closing output stream. ", e);
            }
        }
    }

    public static long getDirSize(File directory) {
        if (directory == null || !directory.isDirectory()) {
            return -1L;
        }
        long size = 0L;
        for (File file : directory.listFiles()) {
            if (file.isFile()) {
                size += file.length();
                continue;
            }
            size += FileUtil.getDirSize(file);
        }
        return size;
    }

    public static int getFilesCount(File directory) {
        if (directory == null || !directory.isDirectory()) {
            return -1;
        }
        File[] files = directory.listFiles();
        int count = 0;
        for (File f : files) {
            if (f.isDirectory()) {
                count += FileUtil.getFilesCount(f);
                continue;
            }
            ++count;
        }
        return count;
    }

    public static void clearDir(File directory) throws Exception {
        if (!directory.isDirectory()) {
            throw new Exception(directory.toString() + " is not a directory");
        }
        if (!directory.exists()) {
            throw new Exception("Directory does not exist");
        }
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                FileUtil.clearDir(file);
            }
            file.delete();
        }
    }
}

