/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.tpexecutor;

import com.adventnet.wms.servercommon.tpexecutor.TPEStats;
import com.adventnet.wms.servercommon.tpexecutor.TPExecutorFactory;
import com.adventnet.wms.servercommon.tpexecutor.TPExecutorTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TPExecutor {
    private static Logger logger = Logger.getLogger(TPExecutor.class.getName());

    public static void execute(String tpe_name, TPExecutorTask task) throws Exception {
        TPEStats.addTPERateStats(tpe_name, 1);
        try {
            ThreadPoolExecutor tpe = TPExecutorFactory.getTPExecutor(tpe_name);
            if (tpe == null) {
                throw new Exception(tpe_name + " - Not Initialized");
            }
            tpe.execute(new CustomExecutor(tpe_name, task));
        }
        catch (Exception ex) {
            TPEStats.addTPERateStats(tpe_name, 3);
            TPEStats.addTPEFailedStats(tpe_name);
            throw ex;
        }
    }

    static class CustomExecutor
    implements Runnable {
        private TPExecutorTask task;
        private String tpe_name;

        public CustomExecutor(String tpe_name, TPExecutorTask task) {
            this.tpe_name = tpe_name;
            this.task = task;
        }

        @Override
        public void run() {
            long stime = System.currentTimeMillis();
            try {
                this.task.process();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "[Exception][TPExecutorTask - process]", ex);
            }
            TPEStats.addTPEExeTimeStats(this.tpe_name, System.currentTimeMillis() - stime);
            TPEStats.addTPERateStats(this.tpe_name, 2);
        }
    }
}

