/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.stats.influx;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.LBQWithoutDuplicates;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.StatsDBQueue;
import com.adventnet.wms.servercommon.stats.influx.StatsDispatchManager;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

class StatsDispatcher
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(StatsDispatcher.class.getName());
    private String stattype;
    private Hashtable<String, StatsDBQueue> statsDBQueueMap = new Hashtable();
    private LBQWithoutDuplicates<StatsDBQueue> lbqwd = new LBQWithoutDuplicates();
    private boolean isconnected = true;
    private String wnetAddress;
    private String auth;
    private String ip;
    private int port = -1;
    private Hashtable<String, String> urls = new Hashtable();
    private static Hashtable<String, Hashtable<String, Hashtable<Integer, AtomicLong>>> errorresponsecodes = new Hashtable();
    private AtomicLong disconnectedCounts = new AtomicLong();
    private static File directory = new File(ServerUtil.dataHome + "statsqueue/debug");
    private static String statsAccessKey = null;
    private static final int STREAM_SIZE = 32768;

    static void setStatsAccessKey(String statsaccesskey) {
        statsAccessKey = statsaccesskey;
    }

    public StatsDispatcher(String statType) {
        this.setName("Stats/StatsDispatcher_" + statType);
        this.stattype = statType;
        this.wnetAddress = StatsConf.getWnet(statType);
        this.ip = this.wnetAddress.split(":")[0];
        try {
            this.port = Integer.parseInt(this.wnetAddress.split(":")[1]);
        }
        catch (Exception e) {
            LOGGER.severe("PS --> StatsDispatcher port exception... with wNetAddress -> " + this.wnetAddress);
        }
        if (!CommonUtil.isEmpty((String)StatsConf.getAuth(statType))) {
            this.auth = "&" + StatsConf.getAuth(statType);
        }
    }

    protected void add(String db, String rp, byte[] data) {
        String key = db;
        if (rp != null && !rp.isEmpty()) {
            key = db + "_" + rp;
        }
        try {
            StatsDBQueue queue = this.statsDBQueueMap.get(key);
            if (queue == null) {
                queue = new StatsDBQueue(key, db, rp);
                this.updateUrl(queue);
                this.statsDBQueueMap.put(key, queue);
                LOGGER.info("PS --> StatsDispatchManager : New StatsDispatcher Started for key : " + key);
            }
            this.lbqwd.add(queue);
            queue.add(data);
            queue.add("\n".getBytes());
        }
        catch (Exception e) {
            LOGGER.severe("PS --> StatsDispatchManager : StatsDispatcher data cannot be recorder : " + key + " due to " + e.toString());
        }
    }

    private void updateUrl(StatsDBQueue dbq) {
        try {
            String url = "http://" + this.wnetAddress + "/write?db=" + dbq.database();
            if (!CommonUtil.isEmpty((String)dbq.rp())) {
                url = url + "&rp=" + dbq.rp();
            }
            if (!CommonUtil.isEmpty((String)this.auth)) {
                url = url + this.auth;
            }
            this.urls.put(dbq.key(), url);
        }
        catch (Exception e) {
            LOGGER.severe("PS --> Exception in StatsDispatchManager.UpdateUrl... with db -> " + dbq.database() + " :: rp -> " + dbq.rp());
        }
    }

    protected void updateConfig() {
        this.wnetAddress = StatsConf.getWnet(this.stattype);
        this.ip = this.wnetAddress.split(":")[0];
        try {
            this.port = Integer.parseInt(this.wnetAddress.split(":")[1]);
        }
        catch (Exception e) {
            LOGGER.severe("PS --> StatsDispatcher port exception in updateConfig... with wNetAddress -> " + this.wnetAddress);
        }
        if (!CommonUtil.isEmpty((String)StatsConf.getAuth(this.stattype))) {
            this.auth = "&" + StatsConf.getAuth(this.stattype);
        }
        Enumeration<StatsDBQueue> enu = this.statsDBQueueMap.elements();
        while (enu.hasMoreElements()) {
            StatsDBQueue dbq = enu.nextElement();
            this.updateUrl(dbq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkNetworkAvailability() {
        try {
            Socket socket = new Socket();
            try {
                try {
                    LOGGER.info("StatsDB network check initiated for dispatcher " + this.wnetAddress);
                    socket.connect(new InetSocketAddress(this.ip, this.port), StatsConf.getHttpConnectTimeout());
                }
                catch (IOException e) {
                    LOGGER.info("StatsDB network check ended for dispatcher " + this.wnetAddress);
                }
                if (!socket.isConnected()) return false;
                LOGGER.info("StatsDB upload resumes for dispatcher " + this.wnetAddress);
                boolean e = true;
                return e;
            }
            catch (Exception e) {
                LOGGER.severe("PS --> Exception in StatsDispatchManager.checkNetworkAvailability...");
                return false;
            }
            finally {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            LOGGER.severe("PS --> Exception in StatsDispatchManager.checkNetworkAvailability... with exception -> " + e.getMessage());
        }
        return false;
    }

    @Override
    public void run() {
        try {
            StatsDispatchManager.addDispatcherThreadStatus(this.stattype, true, System.currentTimeMillis());
            while (StatsConf.isStatsEnabled()) {
                block36: {
                    try {
                        StatsDBQueue sdbQueue;
                        if (!this.isconnected) {
                            if (this.checkNetworkAvailability()) {
                                this.isconnected = true;
                            } else {
                                try {
                                    Thread.sleep(StatsConf.getNetworkCheckerInterval());
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                        }
                        if ((sdbQueue = this.lbqwd.take()).size() <= 0) break block36;
                        byte[] data = sdbQueue.remove();
                        if (DC.isExternal()) {
                            URL url = new URL("https://" + DC.getAdminUrl() + "/uploadstats.do");
                            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
                            urlConn.addRequestProperty("x-statsackey", statsAccessKey);
                            urlConn.setReadTimeout(StatsConf.getHttpReadTimeout());
                            urlConn.setConnectTimeout(StatsConf.getHttpConnectTimeout());
                            urlConn.setDoOutput(true);
                            urlConn.setDoInput(true);
                            urlConn.setUseCaches(false);
                            urlConn.setFixedLengthStreamingMode(data.length);
                            urlConn.addRequestProperty("country", DC.getCountry());
                            urlConn.addRequestProperty("region", DC.getRegion());
                            urlConn.addRequestProperty("cluster", DC.getCluster());
                            urlConn.addRequestProperty("stattype", this.stattype);
                            urlConn.addRequestProperty("database", sdbQueue.database());
                            urlConn.addRequestProperty("rp", sdbQueue.rp());
                            OutputStream os = urlConn.getOutputStream();
                            int responseCode = 0;
                            try {
                                ByteArrayInputStream is = new ByteArrayInputStream(data);
                                StatsDispatcher.streamData(is, os, 32768);
                                responseCode = urlConn.getResponseCode();
                                if (responseCode != 200) {
                                    throw new Exception("PS --> responseCode error : " + responseCode);
                                }
                                LOGGER.info("PS --> Updated with responseCode" + responseCode);
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.SEVERE, "PS --> Exception while transferring statsData with response code - " + responseCode, e);
                            }
                            break block36;
                        }
                        int responseCode = -1;
                        HttpURLConnection httpURLConnection = null;
                        try {
                            httpURLConnection = (HttpURLConnection)new URL(this.urls.get(sdbQueue.key())).openConnection();
                            httpURLConnection.setDoOutput(true);
                            httpURLConnection.setConnectTimeout(StatsConf.getHttpConnectTimeout());
                            httpURLConnection.setReadTimeout(StatsConf.getHttpReadTimeout());
                            httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
                            httpURLConnection.getOutputStream().write(data);
                            responseCode = httpURLConnection.getResponseCode();
                            sdbQueue.setLastPolledTime(System.currentTimeMillis());
                        }
                        catch (IOException e) {
                            sdbQueue.addToNewFile(data);
                            LOGGER.log(Level.INFO, "PS --> StatsDB upload stopped for dispatcher " + this.wnetAddress + " data length : " + data.length + " due to ", e);
                            this.isconnected = false;
                            this.disconnectedCounts.incrementAndGet();
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.INFO, " Unable to send statsData ", e);
                        }
                        if (sdbQueue.size() > 0) {
                            this.lbqwd.add(sdbQueue);
                        }
                        try {
                            String influxError;
                            if (responseCode == 204) break block36;
                            String string = influxError = httpURLConnection != null ? httpURLConnection.getHeaderField("X-InfluxDB-Error") : "httpUrlConnection is NULL";
                            if (responseCode == -1 || influxError == null) {
                                LOGGER.info("Error with InfluxResponseCode -> " + responseCode + " :: influxError -> " + influxError + ":: With query : " + new String(data));
                                continue;
                            }
                            LOGGER.severe("INFLUX_HEADER_ERROR --> " + influxError);
                            if (StatsConf.isDataDebugEnabled()) {
                                this.saveToFile(data, responseCode, sdbQueue.database());
                            }
                            this.updateErrorStatusMap(this.wnetAddress, sdbQueue.database(), responseCode);
                            LOGGER.info(" Unable to send statsdata : db --> " + sdbQueue.database() + " : key --> " + sdbQueue.key() + ": responseCode --> " + responseCode + " : query --> " + new String(data));
                            String errorResponse = null;
                            if (responseCode == 400) {
                                StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.HTTP_FIELD_TYPE_CAST_ERR_400.getErrorCode(), 1L);
                                LOGGER.severe("INFLUX_ERROR --> 400 BAD_REQUEST in : Database --> " + sdbQueue.database() + " : query --> " + new String(data) + " --> may write different value type for field");
                                errorResponse = "400 -> may field value differ";
                            } else if (responseCode == 404) {
                                StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.HTTP_DB_DOES_NOT_EXISTS_ERR_404.getErrorCode(), 1L);
                                LOGGER.severe("INFLUX_ERROR --> 404 HTTP_NOT_FOUND : " + sdbQueue.database() + " not exists.");
                                errorResponse = "404 -> DB not exists";
                            } else if (responseCode == 500) {
                                StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.HTTP_WRITE_IN_RP_DOES_NOT_EXISTS_ERR_500.getErrorCode(), 1L);
                                LOGGER.severe("INFLUX_ERROR --> 500 HTTP_INTERNAL_ERROR : Influx system overloaded, or writes in retention policy, that doesn't exists.  For Database --> " + sdbQueue.database() + " : query --> " + new String(data));
                                errorResponse = "500 -> inf sys overload, or rp does not exist";
                            } else if (responseCode == 401) {
                                StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.HTTP_INFLUX_UNAUTHORIZED_ERR_401.getErrorCode(), 1L);
                                LOGGER.severe("INFLUX_ERROR --> 401 HTTP_UNAUTHORIZED : Invalid authentication credentials.");
                                errorResponse = "401 -> Invalid inf auth";
                            }
                            if (!sdbQueue.key().equals("statsdb") && !CommonUtil.isEmpty(errorResponse)) {
                                StatsDB.addData("statsdberror", sdbQueue.key(), errorResponse, DC.getCluster(), DC.getServertype(), "influx_http_error", 1);
                                break block36;
                            }
                            if (CommonUtil.isEmpty(errorResponse)) {
                                LOGGER.severe("PS --> Error in InfluxStatsDB with response code : " + responseCode);
                                break block36;
                            }
                            LOGGER.info("PS --> Error in statsDBError key itself with response code : " + responseCode);
                        }
                        catch (Exception e) {
                            if (!sdbQueue.key().equals("statsdb")) {
                                StatsDB.addData("statsdberror", sdbQueue.key(), "exception_caught", DC.getCluster(), DC.getServertype(), "influx_http_error", 1);
                            } else {
                                LOGGER.info("PS --> Error in statsDBError key itself inside catch with response code : " + responseCode);
                            }
                            LOGGER.log(Level.INFO, "PS --> Unable to send statsdata errorcode db[" + sdbQueue.database() + "], key[" + sdbQueue.key() + "] responseCode[" + responseCode + "]", e);
                        }
                    }
                    catch (InterruptedException e) {
                        if (StatsDB.isDrainMode()) {
                            LOGGER.info("PS --> StatsDB is in Drain mode, triggered interrupt exception for statType : " + this.stattype);
                        } else {
                            LOGGER.log(Level.INFO, "PS --> Caught Interrupt Exception for statType : " + this.stattype, e);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.INFO, "PS --> Unable to send statsdata ", e);
                    }
                }
                if (!StatsDB.isDrainMode() || this.lbqwd.size() != 0) continue;
                StatsDispatchManager.notifyComplete(this.stattype);
                break;
            }
        }
        catch (Error error) {
            StatsDispatchManager.addDispatcherThreadStatus(this.stattype, false, System.currentTimeMillis());
            LOGGER.severe("PS --> Error in StatsDispatcher.. With Error " + error);
            StatsDispatchManager.removeDispatcher(this.stattype);
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(byte[] data, int response, String database) {
        try {
            if (!directory.exists()) {
                directory.mkdirs();
            }
            File file = new File(directory, response + database + new Date() + ".txt");
            file.createNewFile();
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(file);
                try {
                    if (data != null) {
                        fout.write(data);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                LOGGER.severe("PS --> Exception in StatsDispatchManager.saveToFile...");
            }
            finally {
                try {
                    if (fout != null) {
                        fout.close();
                    }
                }
                catch (Exception exception) {}
            }
            fout = null;
        }
        catch (Exception e) {
            LOGGER.severe("PS --> Exception in StatsDispatchManager.saveToFile...");
        }
    }

    private void updateErrorStatusMap(String ip, String db, int response) {
        AtomicLong counter;
        Hashtable<Integer, AtomicLong> dbmap;
        Hashtable<String, Hashtable<Integer, AtomicLong>> ipmap = errorresponsecodes.get(ip);
        if (ipmap == null) {
            ipmap = new Hashtable();
            errorresponsecodes.put(ip, ipmap);
        }
        if ((dbmap = ipmap.get(db)) == null) {
            dbmap = new Hashtable();
            ipmap.put(db, dbmap);
        }
        if ((counter = dbmap.get(response)) == null) {
            counter = new AtomicLong(0L);
            dbmap.put(response, counter);
        }
        counter.incrementAndGet();
    }

    private static void streamData(InputStream is, OutputStream os, int streamSize) throws Exception {
        if (is == null || os == null) {
            throw new NullPointerException();
        }
        if (streamSize < 1) {
            throw new Exception("invalid streamSize");
        }
        byte[] buffer = new byte[streamSize];
        try {
            int length;
            while ((length = is.read(buffer)) > -1) {
                os.write(buffer, 0, length);
                os.flush();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, " Error while transferring statsData. ", e);
            throw e;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, " Error while closing input stream. ", e);
            }
            try {
                os.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, " Error while closing output stream. ", e);
            }
        }
    }

    protected String getStatType() {
        return this.stattype;
    }

    protected String getWnetAddress() {
        return this.wnetAddress;
    }

    protected boolean isConnected() {
        return this.isconnected;
    }

    protected static Hashtable getErrorResponseCodes() {
        return errorresponsecodes;
    }

    protected long getDisConnectedCount() {
        return this.disconnectedCounts.get();
    }
}

