/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.stats.influx;

import com.adventnet.wms.servercommon.LockManager;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.StatsDispatcher;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import com.adventnet.wms.servercommon.util.WMSUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatsDispatchManager {
    private static final Logger LOGGER = Logger.getLogger(StatsDispatchManager.class.getName());
    private static Hashtable<String, StatsDispatcher> dispatcherMap = new Hashtable();
    private static ConcurrentHashMap<String, ArrayList<Object>> dispatcherStatusMap = new ConcurrentHashMap();
    private static LockManager statTypeLock = new LockManager();
    private static Semaphore semaphore;
    private static final ReentrantLock MODULE_LOCK;
    private static final Condition MODULE_COMPLETED;

    public static void setStatsAccessKey(String statsAccessKey) {
        StatsDispatcher.setStatsAccessKey(statsAccessKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean dispatch(String db, String rp, String stattype, byte[] str, String msr, String statDataType) {
        try {
            StatsDispatcher dispatcher = dispatcherMap.get(stattype);
            if (dispatcher == null) {
                try {
                    Object object = statTypeLock.lock(stattype);
                    synchronized (object) {
                        if (!dispatcherMap.containsKey(stattype)) {
                            if (StatsConf.getWnet(stattype) == null) {
                                LOGGER.severe("PS --> StatsDispatchManager : StatsDispatcher cannot be created , StatsServer for stattype is not configured " + stattype);
                                boolean bl = false;
                                return bl;
                            }
                            dispatcher = new StatsDispatcher(stattype);
                            dispatcherMap.put(stattype, dispatcher);
                            LOGGER.info("PS --> StatsDispatchManager : Started thread for statType : " + stattype);
                            dispatcher.start();
                        }
                    }
                }
                finally {
                    statTypeLock.release(stattype);
                }
            }
            try {
                if (rp.isEmpty()) {
                    StatsDB.addData("influx_write_usage", stattype, db, "-", msr, statDataType, DC.getServertype(), 1);
                } else {
                    StatsDB.addData("influx_write_usage", stattype, db, rp, msr, statDataType, DC.getServertype(), 1);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "PS --> Error for influx_usage [ statType : " + stattype + " ] [ db : " + db + " ] [ rp : " + rp + " ] [ msr : " + msr + " ] [ statDataType : " + statDataType + " ]", e);
            }
            if (dispatcher != null) {
                dispatcher.add(db, rp, str);
                return true;
            }
            LOGGER.log(Level.SEVERE, "PS --> Dispatcher is null");
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    static boolean removeStatTypeFromDispatcher(String statType) {
        try {
            StatsDispatcher statsDispatcher = dispatcherMap.remove(statType);
            statsDispatcher.interrupt();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "PS --> Interrupt thread for : " + statType, e);
        }
        return true;
    }

    static Set<String> listStatTypeFromDispatcher() {
        return dispatcherMap.keySet();
    }

    static void resetDispatcherConfigs() {
        Enumeration<StatsDispatcher> enu = dispatcherMap.elements();
        while (enu.hasMoreElements()) {
            try {
                enu.nextElement().updateConfig();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "PS --> Exception in resetDispatcherConfig...", e);
            }
        }
    }

    protected static Hashtable getErrorStats() {
        return StatsDispatcher.getErrorResponseCodes();
    }

    protected static Hashtable getNetworkStats() {
        Hashtable details = new Hashtable();
        Enumeration<StatsDispatcher> enu = dispatcherMap.elements();
        while (enu.hasMoreElements()) {
            StatsDispatcher dispatcher = enu.nextElement();
            Hashtable<String, String> wnetdetails = new Hashtable<String, String>();
            wnetdetails.put("stattype", dispatcher.getStatType());
            wnetdetails.put("wnet", dispatcher.getWnetAddress());
            wnetdetails.put("disconnected", dispatcher.getDisConnectedCount() + " times");
            wnetdetails.put("status", dispatcher.isConnected() ? "CONNECTED" : "DISCONNECTED");
            details.put(dispatcher.getWnetAddress(), wnetdetails);
        }
        return details;
    }

    static Hashtable getDispatcherThreadStatus() {
        Hashtable statusMap = new Hashtable();
        for (String statType : dispatcherStatusMap.keySet()) {
            Hashtable<String, Object> status = new Hashtable<String, Object>();
            status.put("status", dispatcherStatusMap.get(statType).get(0));
            status.put("time", WMSUtil.HumanReadable.getTime((Long)dispatcherStatusMap.get(statType).get(1)));
            statusMap.put(statType, status);
        }
        return statusMap;
    }

    protected static void addDispatcherThreadStatus(String statType, boolean threadStatus, long timeStamp) {
        if (dispatcherStatusMap != null) {
            ArrayList<Object> statusList = dispatcherStatusMap.get(statType);
            if (statusList == null) {
                statusList = new ArrayList();
                statusList.add(threadStatus);
                statusList.add(timeStamp);
            } else {
                statusList.set(0, threadStatus);
                statusList.set(1, timeStamp);
            }
            dispatcherStatusMap.put(statType, statusList);
        } else {
            LOGGER.severe("PS --> ThreadStatusMap in StatsDispatchManager is null...");
        }
    }

    static void removeDispatcher(String statType) {
        LOGGER.info("PS --> StatsDispatchManager : removed thread for statType : " + statType);
        dispatcherMap.remove(statType);
    }

    static void interrupt() {
        try {
            MODULE_LOCK.lock();
            semaphore = new Semaphore(dispatcherMap.size());
            for (String statType : dispatcherMap.keySet()) {
                try {
                    semaphore.acquire();
                    dispatcherMap.get(statType).interrupt();
                }
                catch (InterruptedException e) {
                    LOGGER.severe("PS --> Got interrupt exception while drain stats for statsDispatchManager");
                }
            }
            boolean status = MODULE_COMPLETED.await(15L, TimeUnit.SECONDS);
            LOGGER.info("PS --> Drain statsDispatchManager status for await : " + status);
            StatsDB.notifyComplete("StatsDispatchManger");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "PS --> Exception while drain statsDispatchManger", e);
        }
        finally {
            MODULE_LOCK.unlock();
        }
    }

    static void notifyComplete(String statType) {
        LOGGER.info("PS --> Release lock for statType : " + statType);
        semaphore.release();
        if (semaphore.availablePermits() == dispatcherMap.size()) {
            try {
                MODULE_LOCK.lock();
                LOGGER.info("PS --> Completed all the statType");
                MODULE_COMPLETED.signal();
            }
            catch (Exception exp) {
                LOGGER.log(Level.SEVERE, "PS --> Error during updateStatus for drain for Module : StatsDispatchManger", exp);
            }
            finally {
                MODULE_LOCK.unlock();
            }
        }
    }

    static {
        MODULE_LOCK = new ReentrantLock();
        MODULE_COMPLETED = MODULE_LOCK.newCondition();
    }
}

