/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.stats.influx;

import com.adventnet.wms.servercommon.stats.influx.AppStats;
import com.adventnet.wms.servercommon.stats.influx.StatRecord;
import com.adventnet.wms.servercommon.stats.influx.StatsByteArrayUploader;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.SystemStats;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import com.adventnet.wms.servercommon.util.WMSUtil;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatsCollector
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(StatsCollector.class.getName());
    private static long lastExecutedTime = -1L;
    private static boolean isStatsCollectorRunning = false;

    public StatsCollector() {
        this.setName("Stats/StatsCollector");
    }

    static long getTimeKey(boolean isPeriodicCollector) {
        Calendar cal = Calendar.getInstance();
        if (!isPeriodicCollector) {
            cal.set(12, cal.get(12) + 1);
        }
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    protected static Hashtable<String, Object> getStatus() {
        Hashtable<String, Object> statsCollectorStatus = new Hashtable<String, Object>();
        statsCollectorStatus.put("is Running", isStatsCollectorRunning);
        statsCollectorStatus.put("last Executed Time", WMSUtil.HumanReadable.getTime(lastExecutedTime));
        return statsCollectorStatus;
    }

    @Override
    public void run() {
        if (isStatsCollectorRunning) {
            LOGGER.severe("PS --> StatsCollector is already running...");
            return;
        }
        isStatsCollectorRunning = true;
        while (StatsConf.isStatsEnabled()) {
            try {
                if (StatsConf.collectAtStartofMin()) {
                    Calendar nextMinute = Calendar.getInstance();
                    nextMinute.set(12, nextMinute.get(12) + 1);
                    nextMinute.set(13, 0);
                    nextMinute.set(14, 0);
                    long diff = nextMinute.getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
                    LOGGER.fine("PS --> Sleep for this time : " + diff + " :: collectAtStartofMin : true");
                    Thread.sleep(diff);
                } else {
                    LOGGER.fine("PS --> Sleep for this time : " + StatsConf.getProfilerInterval() + " :: collectAtStartofMin : false");
                    Thread.sleep(StatsConf.getProfilerInterval());
                }
            }
            catch (InterruptedException e) {
                LOGGER.fine("PS --> Exception in StatsCollector...");
            }
            lastExecutedTime = System.currentTimeMillis();
            try {
                long timems = StatsCollector.getTimeKey(StatsConf.collectAtStartofMin());
                SystemStats systemstats = new SystemStats(timems);
                StatsByteArrayUploader.add(systemstats);
                ConcurrentHashMap statMap = StatsDB.getStatsMap();
                Enumeration enu = statMap.elements();
                while (enu.hasMoreElements()) {
                    try {
                        StatRecord stat = (StatRecord)enu.nextElement();
                        if (stat.isInstantDispatch()) continue;
                        if (stat.isSampleTimeAvailable()) {
                            ConcurrentHashMap statmapwithtime = stat.getStatsData();
                            Enumeration timekeyenum = statmapwithtime.keys();
                            while (timekeyenum.hasMoreElements()) {
                                String timeStrKey = (String)timekeyenum.nextElement();
                                long time = Long.parseLong(timeStrKey);
                                AppStats appstats = new AppStats(time * stat.getSampleTimeInMills(), stat, (ConcurrentHashMap)statmapwithtime.get(timeStrKey));
                                StatsByteArrayUploader.add(appstats);
                            }
                            continue;
                        }
                        AppStats appstats = new AppStats(timems, stat, stat.getStatsData());
                        StatsByteArrayUploader.add(appstats);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.INFO, "PS --> StatsCollector Unable to collect data", e);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "PS --> StatsCollector Unable to collect data", e);
            }
            catch (Error e) {
                isStatsCollectorRunning = false;
                LOGGER.log(Level.SEVERE, "PS --> Error in StatsCollector Try/Catch...", e);
                throw e;
            }
            if (!StatsDB.isDrainMode()) continue;
            StatsDB.notifyComplete("StatsCollector");
            break;
        }
    }
}

