/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.stats.influx;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.servercommon.runtime.WmsRuntime;
import com.adventnet.wms.servercommon.stats.influx.StatsCollector;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.StatsDispatchManager;
import com.adventnet.wms.servercommon.util.WMSUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatsCLIRuntime
extends WmsRuntime {
    private static final Logger LOGGER = Logger.getLogger(StatsCLIRuntime.class.getName());

    /*
     * Unable to fully structure code
     */
    @Override
    public Hashtable getInfo(Hashtable params) {
        block34: {
            details = new Hashtable<String, String>();
            try {
                opr = (String)params.get("opr");
                if (opr == null) {
                    StatsCLIRuntime.getStatsDBStatus(details);
                    break block34;
                }
                var6_5 = opr;
                var7_6 = -1;
                switch (var6_5.hashCode()) {
                    case -892481550: {
                        if (!var6_5.equals("status")) break;
                        var7_6 = 0;
                        break;
                    }
                    case 1318382152: {
                        if (!var6_5.equals("statkeys")) break;
                        var7_6 = 1;
                        break;
                    }
                    case 3076010: {
                        if (!var6_5.equals("data")) break;
                        var7_6 = 2;
                        break;
                    }
                    case 93832333: {
                        if (!var6_5.equals("block")) break;
                        var7_6 = 3;
                        break;
                    }
                    case -293212780: {
                        if (!var6_5.equals("unblock")) break;
                        var7_6 = 4;
                        break;
                    }
                    case -24865409: {
                        if (!var6_5.equals("blklist")) break;
                        var7_6 = 5;
                        break;
                    }
                    case 861647757: {
                        if (!var6_5.equals("unblockall")) break;
                        var7_6 = 6;
                        break;
                    }
                    case -838846263: {
                        if (!var6_5.equals("update")) break;
                        var7_6 = 7;
                        break;
                    }
                    case -2069799011: {
                        if (!var6_5.equals("statvalue")) break;
                        var7_6 = 8;
                        break;
                    }
                    case -382572803: {
                        if (!var6_5.equals("liststattypefromdispatcher")) break;
                        var7_6 = 9;
                        break;
                    }
                    case 36010883: {
                        if (!var6_5.equals("readqlogthres")) break;
                        var7_6 = 10;
                    }
                }
                switch (var7_6) {
                    case 0: {
                        StatsCLIRuntime.getStatsDBStatus(details);
                        break;
                    }
                    case 1: {
                        details.put("StatKeys", (String)StatsDB.getStatKeys());
                        break;
                    }
                    case 2: {
                        statKey = "" + params.get("statkey");
                        details.put("statKey", (String)StatsDB.getStats(statKey));
                        break;
                    }
                    case 3: {
                        statKey = (String)params.get("statkey");
                        if (!CommonUtil.isEmpty((String)statKey)) {
                            StatsCLIRuntime.blockStatkey(statKey, (String)params.get("_zuid"), details);
                            break;
                        }
                        details.put("Block stats", "No statsKey provided. Use -sk with comma separated statsKey (if needed) along with -opr key");
                        break;
                    }
                    case 4: {
                        statKey = (String)params.get("statkey");
                        if (!CommonUtil.isEmpty((String)statKey)) {
                            StatsCLIRuntime.unblockStatKey(statKey, details);
                            break;
                        }
                        details.put("UnBlock stats", "No statsKey provided. Use -sk with comma separated statsKey (if needed) along with -opr key");
                        break;
                    }
                    case 5: {
                        StatsCLIRuntime.listBlockedStatsKey(details);
                        break;
                    }
                    case 6: {
                        StatsCLIRuntime.clearAllBlockedStatsKey(details);
                        break;
                    }
                    case 7: {
                        statKey = (String)params.get("statkey");
                        statValue = (String)params.get("statvalue");
                        if (!CommonUtil.isEmpty((String)statKey) && !CommonUtil.isEmpty((String)statValue)) {
                            StatsDB.loadInStatsDB(statKey, statValue, details);
                            break;
                        }
                        details.put("Update stats", "-sk -> statKey && -sv -> statValue should not be empty");
                        break;
                    }
                    case 8: {
                        statKey = (String)params.get("statkey");
                        this.showStatValues(statKey, details);
                        break;
                    }
                    case 9: {
                        details.put("StatType", (String)StatsDispatchManager.listStatTypeFromDispatcher());
                        break;
                    }
                    case 10: {
                        if (!params.containsKey("time")) ** GOTO lbl119
                        try {
                            time = Integer.parseInt(params.get("time") + "");
                            if (time < 10 || time > 60) ** GOTO lbl112
                            StatsDB.setReadQueryLogThreshold(time);
                            ** GOTO lbl121
lbl112:
                            // 1 sources

                            details.put("Error", "-time should be between 10 and 60");
                        }
                        catch (Exception e) {
                            details.put("Error", "-time should be between 10 and 60");
                        }
                        ** GOTO lbl121
lbl119:
                        // 1 sources

                        details.put("Error", "-time must be provided to set threshold and should be between 10 and 60");
lbl121:
                        // 4 sources

                        details.put("readqlogthres", StatsDB.getReadQueryLogThreshold() + " secs");
                    }
                }
            }
            catch (Exception e) {
                StatsCLIRuntime.LOGGER.log(Level.SEVERE, "PS --> Something went wrong", e);
                details.put("Error", "Exception occurred");
            }
        }
        return details;
    }

    private void showStatValues(String statKeyList, Hashtable details) {
        if (!CommonUtil.isEmpty((String)statKeyList)) {
            for (String statKey : CommonUtil.getList((String)statKeyList)) {
                String statValue = StatsDB.getStatsValue(statKey);
                if (!CommonUtil.isEmpty((String)statValue)) {
                    details.put(statKey, statValue);
                    continue;
                }
                details.put(statKey, "Not defined...");
            }
        } else {
            details.put("Show statValue", "-sk -> statKey should not be empty");
        }
    }

    private static void getStatsDBStatus(Hashtable details) {
        details.put("Network Status", StatsDispatchManager.getNetworkStats());
        details.put("Error Details", StatsDispatchManager.getErrorStats());
        details.put("Dispatcher Status", StatsDispatchManager.getDispatcherThreadStatus());
        details.put("Stats Collector", StatsCollector.getStatus());
    }

    private static void blockStatkey(String statsKeyList, String zuid, Hashtable<String, String> details) {
        try {
            for (String statKey : CommonUtil.getList((String)statsKeyList)) {
                if (CommonUtil.isEmpty((String)statKey)) continue;
                StatsDB.blockStatKey(statKey, zuid, details);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "STATS_ERROR --> Error in " + exception.getStackTrace()[0].getMethodName() + " method with param of statKey -> " + statsKeyList + " :: with exception ", exception);
            details.put("Exception", "Cannot add to block stats list while adding : " + statsKeyList);
        }
    }

    private static void unblockStatKey(String statsKeyList, Hashtable details) {
        for (String statKey : CommonUtil.getList((String)statsKeyList)) {
            if (CommonUtil.isEmpty((String)statKey)) continue;
            if (StatsDB.unblockStatKey(statKey)) {
                details.put(statKey, "Unblocked");
                continue;
            }
            details.put(statKey, "Stat must be already blocked in order to unblock it");
        }
    }

    private static void listBlockedStatsKey(Hashtable details) {
        ConcurrentHashMap<String, ArrayList<Object>> statsKeyMap = StatsDB.listBlockStatsKey();
        ConcurrentHashMap result = new ConcurrentHashMap();
        if (statsKeyMap.size() == 0) {
            details.put("Block Stats List", "No stats blocked");
        } else {
            long currentTime = System.currentTimeMillis();
            for (String statKey : statsKeyMap.keySet()) {
                ArrayList<Object> userDetail = statsKeyMap.get(statKey);
                long blockedTime = (Long)userDetail.get(0);
                ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
                map.put("Time", WMSUtil.HumanReadable.getTime(blockedTime));
                map.put("Since", WMSUtil.HumanReadable.getDuration(currentTime - blockedTime));
                map.put("By", (String)userDetail.get(1));
                result.put(statKey, map);
            }
            details.put("Block Stats List", result);
        }
    }

    private static void clearAllBlockedStatsKey(Hashtable<String, String> details) {
        Set<String> blockStatsKey = StatsDB.clearAllBlockStatsKey();
        if (blockStatsKey != null && blockStatsKey.size() == 0) {
            details.put("Block Stats List", "No stats blocked");
        } else {
            for (String statKey : blockStatsKey) {
                details.put(statKey, "Unblocked");
            }
        }
    }
}

