/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.stats.influx;

import com.adventnet.wms.servercommon.stats.influx.Stats;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

class StatsByteArrayUploader
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(StatsByteArrayUploader.class.getName());
    private static LinkedBlockingQueue<Stats> stats = new LinkedBlockingQueue();

    public StatsByteArrayUploader() {
        this.setName("Stats/StatsByteArrayUploader");
    }

    public static void add(Stats stat) {
        stats.add(stat);
    }

    @Override
    public void run() {
        this.setName("StatsByteArrayUploader");
        while (StatsConf.isStatsEnabled()) {
            if (StatsDB.isDrainMode() && stats.size() == 0) {
                StatsDB.notifyComplete("StatsByteArrayUploader");
                break;
            }
            try {
                Stats stat = stats.take();
                stat.dispatch();
            }
            catch (InterruptedException exp) {
                if (StatsDB.isDrainMode()) {
                    LOGGER.info("PS --> StatsDB is in Drain mode, triggered interrupt exception in StatsByteArrayUploader");
                    continue;
                }
                LOGGER.log(Level.INFO, "PS --> StatsByteArrayUploader thrown exception...", exp);
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "PS --> StatsByteArrayUploader Unable to dispatch data ", e);
            }
        }
    }
}

