/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.stats.influx;

import com.adventnet.wms.servercommon.stats.influx.SelectStatement;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QueryExecutor {
    private static Logger logger = Logger.getLogger(QueryExecutor.class.getName());

    public static Object execute(SelectStatement statement, StatsDB.ResultFormat format) throws Exception {
        if (format.equals((Object)StatsDB.ResultFormat.STREAM)) {
            return StatsDB.doFetchAsStream(statement.getStatType(), statement.getDatabase(), statement.getQuery());
        }
        if (format.equals((Object)StatsDB.ResultFormat.STAEMENTRESULTS)) {
            return StatsDB.doFetchAsStatement(statement.getStatType(), statement.getDatabase(), statement.getQuery());
        }
        if (format.equals((Object)StatsDB.ResultFormat.JSON)) {
            return StatsDB.doFetchAsJSON(statement.getStatType(), statement.getDatabase(), statement.getQuery());
        }
        return null;
    }

    public static Object execute(SelectStatement statement, OutputStream os, int bufferSize) throws Exception {
        InputStream in = StatsDB.doFetchAsStream(statement.getStatType(), statement.getDatabase(), statement.getQuery());
        byte[] buffer = bufferSize <= 0 ? new byte[1024] : new byte[bufferSize];
        try {
            int length;
            while ((length = in.read(buffer)) > -1) {
                os.write(buffer, 0, length);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while transferring data", e);
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error closing input stream", e);
        }
        return null;
    }
}

