/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.stats.influx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class BBQueue {
    private byte[][] inQ;
    private int writepos = 0;
    private int qSize = -1;
    private int qdatalen = 0;
    private int filestart = 0;
    private int fileend = 0;
    private String fileName = null;
    private File directory = null;

    BBQueue(String strDir, String fileName, int qSize) {
        this.qSize = qSize;
        this.inQ = new byte[qSize][];
        this.directory = new File(strDir + File.separator);
        if (!this.directory.isDirectory()) {
            this.directory.mkdirs();
        }
        if (!this.directory.exists()) {
            throw new IllegalArgumentException(strDir + " temp directory does not exist");
        }
        this.fileName = fileName;
        this.resetFileCounts();
    }

    synchronized boolean add(byte[] data) {
        if (this.writepos >= this.qSize) {
            int tryCount;
            for (tryCount = 0; !this.saveToFile(this.inQ, this.getNextWriteFile()) && tryCount < 5; ++tryCount) {
            }
            if (tryCount == 5) {
                return false;
            }
            this.resetInQ();
        }
        this.inQ[this.writepos] = data;
        this.qdatalen += data.length;
        ++this.writepos;
        return true;
    }

    synchronized boolean addToNewFile(byte[] data) {
        byte[][] temp = new byte[][]{data};
        return this.saveToFile(temp, this.getNextWriteFile());
    }

    synchronized byte[] get() {
        byte[] data = null;
        if (this.fileend > this.filestart) {
            data = this.getFileContent(this.getNextReadFile());
            while (data == null && this.fileend > this.filestart) {
                data = this.getFileContent(this.getNextReadFile());
            }
        }
        if (data == null) {
            data = this.purgeInQ();
        }
        return data;
    }

    private synchronized byte[] purgeInQ() {
        byte[] data = new byte[this.qdatalen];
        int len = 0;
        int pos = 0;
        for (int i = 0; i < this.writepos; ++i) {
            len = this.inQ[i].length;
            System.arraycopy(this.inQ[i], 0, data, pos, len);
            pos += len;
        }
        this.resetInQ();
        return data;
    }

    private synchronized void resetInQ() {
        this.inQ = new byte[this.qSize][];
        this.writepos = 0;
        this.qdatalen = 0;
    }

    synchronized void close() {
        if (this.writepos > 0) {
            this.saveToFile(this.inQ, this.getNextWriteFile());
        }
        this.inQ = null;
    }

    private synchronized File getNextWriteFile() {
        File file = new File(this.directory, this.fileName + this.fileend + ".txt");
        ++this.fileend;
        return file;
    }

    private synchronized File getNextReadFile() {
        File file = new File(this.directory, this.fileName + this.filestart + ".txt");
        ++this.filestart;
        return file;
    }

    synchronized boolean isEmpty() {
        return this.writepos <= 0 && this.fileend <= this.filestart;
    }

    synchronized int size() {
        return this.writepos + (this.fileend - this.filestart) * this.qSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean saveToFile(byte[][] data, File file) {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            for (int i = 0; i < data.length; ++i) {
                try {
                    if (data[i] == null) continue;
                    fout.write(data[i]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        fout = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized byte[] getFileContent(File file) {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(file);
            data = new byte[fin.available()];
            fin.read(data);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
                this.deleteFile(file);
            }
            catch (Exception exception) {}
        }
        return data;
    }

    private synchronized void deleteFile(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    private synchronized void resetFileCounts() {
        int min = -1;
        int max = -1;
        File[] fileList = this.directory.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            String currFile = fileList[i].getName();
            if (!currFile.startsWith(this.fileName)) continue;
            try {
                String baseName = currFile.substring(this.fileName.length(), currFile.length() - 4);
                int currVal = Integer.parseInt("" + baseName);
                if (currVal <= min || min == -1) {
                    min = currVal;
                }
                if (currVal < max && max != -1) continue;
                max = currVal + 1;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (min != -1) {
            this.filestart = min;
        }
        if (max != -1) {
            this.fileend = max;
        }
    }
}

