/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.rocksdb;

import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.rocksdb.RocksDBAdapter;
import com.adventnet.wms.servercommon.rocksdb.RocksDBInstance;
import com.adventnet.wms.servercommon.rocksdb.RocksDBIteratorAdapter;
import com.adventnet.wms.servercommon.rocksdb.RocksDBIteratorHandler;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rocksdb.BackupEngine;
import org.rocksdb.RocksDBException;
import org.rocksdb.TransactionLogIterator;

public class RocksDBManager {
    private static Logger logger = Logger.getLogger(RocksDBManager.class.getName());
    protected static final String ROCKSDB_CONF_FILE_DIR = ServerUtil.serverHome + File.separator + "conf" + File.separator + "rocksdb" + File.separator;
    private static Map<String, RocksDBInstance> dbMap = new HashMap<String, RocksDBInstance>();
    private static boolean recordStats = false;
    private static boolean isInitialized = false;
    public static String rocksDBDir = ServerUtil.dataHome + "rocksdbfiles" + File.separator;

    public static boolean initialize(boolean recordStatsBool) {
        if (isInitialized) {
            logger.log(Level.WARNING, "RocksDB is already initialized");
            return true;
        }
        try {
            recordStats = recordStatsBool;
            Properties dbconf = ServerUtil.getProperties(ROCKSDB_CONF_FILE_DIR + "wmsdb.conf");
            Enumeration<?> e = dbconf.propertyNames();
            while (e.hasMoreElements()) {
                String dbName = (String)e.nextElement();
                RocksDBInstance rocksDB = new RocksDBInstance(dbName, recordStatsBool);
                dbMap.put(dbName, rocksDB);
                logger.info("NS--> DB=" + dbName + " initialised successfully. ");
            }
            Hashtable<String, String> statsDefs = new Hashtable<String, String>();
            if (recordStats) {
                statsDefs.put("rocksdbstats", "[[\"metric\",\"rserver\",\"\",\"rocksdbstats\",true],[\"dbname\",\"colname\"],[],[\"numrecords\",\"dbsize\",\"walsyncmicros\",\"writestall\"]]");
                if (StatsConf.loadStatsKeyDef(statsDefs)) {
                    StatsDB.initialize();
                    logger.info("RocksDBManager - Influx Stats Initialized]");
                }
            }
            isInitialized = true;
            logger.info("NS--> RocksDB initialized successfully");
            return true;
        }
        catch (Exception exp) {
            logger.log(Level.SEVERE, "NSERR--> Unable to setup RocksDB recordStatsBool=" + recordStatsBool, exp);
            return false;
        }
    }

    public static boolean initialize() {
        return RocksDBManager.initialize(false);
    }

    public static long put(String cfName, String skey, Object value) throws WMSException {
        return RocksDBManager.put("rocksdbfiles", cfName, skey, value);
    }

    public static long put(String dbName, String cfName, String skey, Object value) throws WMSException {
        RocksDBInstance rocksDB = dbMap.get(dbName);
        if (rocksDB == null) {
            throw new WMSException("DB not registered. Invalid DBName=" + dbName + "; opr=put; cfName=" + cfName + " skey=" + skey);
        }
        return rocksDB.put(cfName, skey, value);
    }

    public static Object get(String cfName, String skey) throws WMSException {
        return RocksDBManager.get("rocksdbfiles", cfName, skey);
    }

    public static Object get(String dbName, String cfName, String skey) throws WMSException {
        RocksDBInstance rocksDB = dbMap.get(dbName);
        if (rocksDB == null) {
            throw new WMSException("DB not registered. Invalid DBName=" + dbName + "; opr=get; cfName=" + cfName + " skey=" + skey);
        }
        return rocksDB.get(cfName, skey);
    }

    public static void delete(String cfName, String skey) throws WMSException {
        RocksDBManager.delete("rocksdbfiles", cfName, skey);
    }

    public static void delete(String dbName, String cfName, String skey) throws WMSException {
        RocksDBInstance rocksDB = dbMap.get(dbName);
        if (rocksDB == null) {
            throw new WMSException("DB not registered. Invalid DBName=" + dbName + "; opr=delete; cfName=" + cfName + " skey=" + skey);
        }
        rocksDB.delete(cfName, skey);
    }

    public static void delete(String cfName, String[] keys) throws WMSException {
        for (String key : keys) {
            RocksDBManager.delete(cfName, key);
        }
    }

    public static void delete(String dbName, String cfName, String[] keys) throws WMSException {
        for (String key : keys) {
            RocksDBManager.delete(dbName, cfName, key);
        }
    }

    public static String putVerificationRecord() throws Exception {
        return RocksDBManager.putVerificationRecord("rocksdbfiles");
    }

    public static String putVerificationRecord(String dbName) throws Exception {
        RocksDBInstance rocksDB = dbMap.get(dbName);
        if (rocksDB == null) {
            throw new WMSException("DB not registered. Invalid DBName=" + dbName + "; opr=putVerificationRecord;");
        }
        return rocksDB.putVerificationRecord();
    }

    public static String getVerificationRecord() {
        return RocksDBManager.getVerificationRecord("rocksdbfiles");
    }

    public static String getVerificationRecord(String dbName) {
        RocksDBInstance rocksDB = dbMap.get(dbName);
        if (rocksDB == null) {
            logger.severe("DB not registered. Invalid DBName=" + dbName + "; opr=getVerificationRecord;");
        }
        return rocksDB.getVerificationRecord();
    }

    public static boolean write(byte[] writeBatchData) {
        return RocksDBManager.write("rocksdbfiles", writeBatchData);
    }

    public static boolean write(String dbName, byte[] writeBatchData) {
        RocksDBInstance rocksDB = dbMap.get(dbName);
        if (rocksDB == null) {
            logger.severe("DB not registered. Invalid DBName=" + dbName + "; opr=write;");
        }
        return rocksDB.write(writeBatchData);
    }

    public static void createBackup(BackupEngine backupEngine) throws RocksDBException {
        RocksDBManager.createBackup("rocksdbfiles", backupEngine);
    }

    public static void createBackup(String dbName, BackupEngine backupEngine) throws RocksDBException {
        RocksDBInstance rocksDB = dbMap.get(dbName);
        if (rocksDB == null) {
            logger.severe("DB not registered. Invalid DBName=" + dbName + "; opr=createBackup;");
        }
        rocksDB.createBackup(backupEngine);
    }

    public static void recordDBInfo(long timems) {
        if (isInitialized && recordStats) {
            for (String dbName : dbMap.keySet()) {
                dbMap.get(dbName).recordDBInfo(timems);
            }
        }
    }

    public static boolean flushDB() {
        return RocksDBManager.flushDB("rocksdbfiles");
    }

    public static boolean flushDB(String dbName) {
        RocksDBInstance rocksDB = dbMap.get(dbName);
        if (rocksDB == null) {
            logger.severe("DB not registered. Invalid DBName=" + dbName + "; opr=flushDB;");
        }
        return rocksDB.flushDB();
    }

    public static boolean disableFileDeletions() {
        return RocksDBManager.disableFileDeletions("rocksdbfiles");
    }

    public static boolean disableFileDeletions(String dbName) {
        RocksDBInstance rocksDB = dbMap.get(dbName);
        if (rocksDB == null) {
            logger.severe("DB not registered. Invalid DBName=" + dbName + "; opr=disableFileDeletions;");
        }
        return rocksDB.disableFileDeletions();
    }

    public static boolean enableFileDeletions() {
        return RocksDBManager.enableFileDeletions("rocksdbfiles");
    }

    public static boolean enableFileDeletions(String dbName) {
        RocksDBInstance rocksDB = dbMap.get(dbName);
        if (rocksDB == null) {
            logger.severe("DB not registered. Invalid DBName=" + dbName + "; opr=enableFileDeletions;");
        }
        return rocksDB.enableFileDeletions();
    }

    public static long getLatestSequenceNumber() {
        return RocksDBManager.getLatestSequenceNumber("rocksdbfiles");
    }

    public static long getLatestSequenceNumber(String dbName) {
        RocksDBInstance rocksDB = dbMap.get(dbName);
        if (rocksDB == null) {
            logger.severe("DB not registered. Invalid DBName=" + dbName + "; opr=getLatestSequenceNumber;");
        }
        return rocksDB.getLatestSequenceNumber();
    }

    static TransactionLogIterator getUpdatesSince(long seqNo) throws Exception {
        return RocksDBManager.getUpdatesSince("rocksdbfiles", seqNo);
    }

    static TransactionLogIterator getUpdatesSince(String dbName, long seqNo) throws Exception {
        RocksDBInstance rocksDB = dbMap.get(dbName);
        if (rocksDB == null) {
            logger.severe("DB not registered. Invalid DBName=" + dbName + "; opr=getUpdatesSince;");
        }
        return rocksDB.getUpdatesSince(seqNo);
    }

    public static void close() {
        isInitialized = false;
        for (String dbName : dbMap.keySet()) {
            dbMap.get(dbName).close();
            logger.info("NSRocksDB--> dbname=" + dbName + " closed successfully");
        }
    }

    public static synchronized void iterateDB(RocksDBIteratorHandler iterHandler, String colName) {
        RocksDBManager.iterateDB("rocksdbfiles", iterHandler, colName);
    }

    public static synchronized void iterateDB(String dbName, RocksDBIteratorHandler iterHandler, String colName) {
        RocksDBInstance rocksDB = dbMap.get(dbName);
        if (rocksDB == null) {
            logger.severe("DB not registered. Invalid DBName=" + dbName + "; opr=iterateDB;");
            return;
        }
        new Thread((Runnable)new DBIterator(rocksDB, iterHandler, colName), "RocksDBIterator:" + colName).start();
    }

    public static void iterateDBSync(RocksDBIteratorHandler iterHandler, String colName) {
        RocksDBManager.iterateDBSync("rocksdbfiles", iterHandler, colName);
    }

    public static void iterateDBSync(String dbName, RocksDBIteratorHandler iterHandler, String colName) {
        RocksDBInstance rocksDB = dbMap.get(dbName);
        if (rocksDB == null) {
            logger.severe("DB not registered. Invalid DBName=" + dbName + "; opr=iterateDBSync;");
            return;
        }
        try {
            FutureTask<Object> iterateTask = new FutureTask<Object>(new DBIterator(rocksDB, iterHandler, colName), null);
            new Thread(iterateTask, "RocksDBIterator:" + colName).start();
            iterateTask.get();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exeption in RocksDBManager iterateDBSync; dbName=" + dbName + " colName=" + colName, e);
        }
    }

    static class DBIterator
    implements Runnable {
        private String colName;
        private RocksDBInstance rocksdb;
        private RocksDBSeekHandle seekHandle;
        private RocksDBIteratorAdapter iterator;
        private RocksDBIteratorHandler iterHandler;

        public DBIterator(RocksDBInstance rocksDB, RocksDBIteratorHandler iterHandler) {
            new DBIterator(rocksDB, iterHandler, RocksDBAdapter.DEFAULT_COLUMN_FAMILY_NAME);
        }

        public DBIterator(RocksDBInstance rocksDB, RocksDBIteratorHandler iterHandler, String colName) {
            this.colName = colName;
            this.rocksdb = rocksDB;
            this.iterHandler = iterHandler;
            this.seekHandle = new RocksDBSeekHandle(this.iterator);
            this.iterator = rocksDB.getDBAdaptor().iterinit(colName);
        }

        @Override
        public void run() {
            try {
                this.iterHandler.handleInitialized(this.seekHandle);
                while (this.iterator.isValid()) {
                    Object obj = this.rocksdb.getCFRecordBinding(this.colName).deserialize(this.iterator.getValue());
                    if (!this.iterHandler.handleRecord(this.iterator.getKey(), obj, this.seekHandle)) {
                        break;
                    }
                    this.iterator.next();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "DBIterator failed for colName=" + this.colName, e);
                this.iterHandler.handleFailure();
            }
            finally {
                this.iterator.close();
                this.iterHandler.handleClose();
            }
        }
    }

    public static class RocksDBSeekHandle {
        private RocksDBIteratorAdapter iterator;

        RocksDBSeekHandle(RocksDBIteratorAdapter iterator) {
            this.iterator = iterator;
        }

        public void seek(String target) {
            this.iterator.seek(target);
        }
    }
}

