/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.rocksdb;

import com.adventnet.wms.nioclient.http.EventDispatcher;
import com.adventnet.wms.nioclient.http.HttpRequest;
import com.adventnet.wms.nioclient.http.HttpRequestEventListener;
import com.adventnet.wms.nioclient.http.NIONetDataProcessor;
import com.adventnet.wms.nioclient.http.NetworkEventProcessor;
import com.adventnet.wms.nioclient.http.SelectorPoolFactory;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.servlet.WCPFuture;
import com.adventnet.wms.servercommon.components.net.servlet.WCPRequest;
import com.adventnet.wms.servercommon.components.net.servlet.WCPResponse;
import com.adventnet.wms.servercommon.components.queue.ar.RocksDBDTConnection;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.grid.ar.ARManager;
import com.adventnet.wms.servercommon.rocksdb.RocksDBARModule;
import com.adventnet.wms.servercommon.rocksdb.RocksDBCBListener;
import com.adventnet.wms.servercommon.rocksdb.RocksDBHttpRequestEventListener;
import com.adventnet.wms.servercommon.rocksdb.RocksDBListener;
import com.adventnet.wms.servercommon.rocksdb.RocksDBManager;
import com.adventnet.wms.servercommon.rocksdb.RocksDBWSHandler;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rocksdb.TransactionLogIterator;

public class RocksDBCommunicator {
    private static final Logger LOGGER = Logger.getLogger(RocksDBCommunicator.class.getName());
    private static int transferBufferSize = 0x500000;
    private static final Object restoreLock = new Object();
    private static int restoreStatus = 100;
    private static boolean streamFlag = false;
    private static RocksDBStreamExecutor streamExecutor;
    private static FutureTask<Boolean> streamFutureTask;
    private static int streamBatchSize;
    private static int nioClientThreadCount;

    public static boolean initialize() {
        LOGGER.log(Level.INFO, "SNA-- initializing RocksDBCommunicator");
        try {
            LOGGER.log(Level.INFO, "SNA-- RocksDBCommunicator creating con pool");
            WCPDispatcher.createWCPConnPool("rocksdbconpool", DC.getServertype(), DC.getServertype(), null, "rocksdbcontext", false, 1, "/grid/ar", ARManager.getGACPort());
        }
        catch (Exception wcpe) {
            LOGGER.log(Level.WARNING, "SNA-- Unable to create WCPDispatcher connection pool for RocksDB", wcpe);
            return false;
        }
        if (ARManager.getServerMode() == 1) {
            try {
                LOGGER.log(Level.INFO, "SNA-- initailizing nio ");
                SelectorPoolFactory.init((int)7070, (int)3);
                NIONetDataProcessor.initialize((int)nioClientThreadCount, (int)nioClientThreadCount);
                NetworkEventProcessor.initialize((int)2);
                EventDispatcher.initialize((int)nioClientThreadCount);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "SNA-- Exception while initailizing nio ", e);
                return false;
            }
        }
        try {
            LOGGER.log(Level.INFO, "SNA-- RocksDBCommunicator registering listener");
            if (!WCPDispatcher.registerListener("rocksdbcontext", new RocksDBListener()) && !WCPDispatcher.registerCBListener("rocksdbcontext", new RocksDBCBListener())) {
                LOGGER.log(Level.WARNING, "SNA-- Unable to register WCPDispatcher listeners for RocksDB");
                return false;
            }
            LOGGER.log(Level.INFO, "SNA-- RocksDBCommunicator registration completed");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "SNA-- Unable to register WCPDispatcher listeners for RocksDB", e);
            return false;
        }
        Hashtable<String, String> statsDefs = new Hashtable<String, String>();
        statsDefs.put("rocksdbar", "[[\"qos\",\"qos_rocksdb\",\"\",\"rocksdbar\",false],[\"opr\",\"servertype\"],[],[\"timetaken\"]]");
        statsDefs.put("rocksdbarfiletransfer", "[[\"qos\",\"qos_rocksdb\",\"\",\"rocksdbarfiletransfer\",true],[\"servertype\"],[],[\"filesize\",\"timetaken\"]]");
        if (StatsConf.loadStatsKeyDef(statsDefs)) {
            StatsDB.initialize();
            LOGGER.info("SNA-- RocksDBCommunicator - influx stats initialized]");
        }
        return true;
    }

    public static boolean transferFile(String filePath, String destPath) {
        return RocksDBCommunicator.transferFile(filePath, destPath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean transferFile(String filePath, String destPath, boolean compress) {
        Object lock = new Object();
        try {
            LOGGER.log(Level.INFO, "SNA-- Transfering file. filePath : {0}", filePath);
            File fileToSend = new File(filePath);
            RocksDBHttpRequestEventListener listener = new RocksDBHttpRequestEventListener(fileToSend, lock, compress);
            HttpRequest httpRequest = new HttpRequest(ARManager.getARIp(), 7070, "POST", (HttpRequestEventListener)listener);
            httpRequest.setRequestURI("/grid/rocksdbft");
            httpRequest.setReadTimeout(60000);
            httpRequest.registerStreamWrite();
            httpRequest.addHeader("Transfer-Encoding", "chunked");
            httpRequest.addHeader("x-streammode", "1");
            httpRequest.addHeader("Content-Type", "application/octet-stream");
            httpRequest.addHeader("destpath", destPath);
            httpRequest.addHeader("start-time", "" + System.currentTimeMillis());
            httpRequest.addHeader("iscompressed", "" + compress);
            httpRequest.connect();
            Object object = lock;
            synchronized (object) {
                while (listener.getCompletionStatus() == 200) {
                    lock.wait(300000L);
                }
            }
            if (listener.getCompletionStatus() == 203) {
                LOGGER.log(Level.WARNING, "SNA-- RocksDB - File Transfer Completed Successfully. filePath : {0}", filePath);
                return true;
            }
            LOGGER.log(Level.WARNING, "SNA-- RocksDB - File Transfer failed. filePath: {0}", filePath);
            return false;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "SNA-- RocksDB - Exception while sending nio http request", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeRemoteRestore(String tarFile) throws Exception {
        if (restoreStatus == 102) {
            LOGGER.log(Level.WARNING, "SNA-- RocksDB - Restore already in progress");
            return false;
        }
        Object object = restoreLock;
        synchronized (object) {
            WCPDispatcher.sendData("rocksdbconpool", ARManager.getARIp(), 101, tarFile);
            restoreStatus = 102;
            LOGGER.log(Level.INFO, "SNA-- RocksDB - restore command sent, waiting for restore response");
            restoreLock.wait();
        }
        if (restoreStatus == 103) {
            LOGGER.log(Level.WARNING, "SNA-- RocksDB - Restore Completed Successfully");
            restoreStatus = 100;
            return true;
        }
        LOGGER.log(Level.WARNING, "SNA-- RocksDB - Restore Failed");
        restoreStatus = 100;
        return false;
    }

    static boolean startStreaming() {
        if (streamFutureTask != null && !streamFutureTask.isDone()) {
            LOGGER.log(Level.WARNING, "SNA-- RocksDB - WAL stream already in progress");
            return false;
        }
        streamFlag = true;
        streamExecutor = new RocksDBStreamExecutor();
        streamFutureTask = new FutureTask<Boolean>(streamExecutor);
        Thread RocksDBWALStreamThread = new Thread(streamFutureTask);
        LOGGER.log(Level.INFO, "SNA-- RocksDB - initiating WAL stream");
        RocksDBWALStreamThread.start();
        return true;
    }

    static boolean endStreaming() throws Exception {
        LOGGER.log(Level.INFO, "SNA-- RocksDB - WAL stream is ending");
        streamFlag = false;
        if (!streamFutureTask.get(30L, TimeUnit.SECONDS).booleanValue()) {
            LOGGER.log(Level.WARNING, "SNA-- WAL stream unsuccessful");
            return false;
        }
        return true;
    }

    static void abortStreaming() {
        if (streamExecutor != null) {
            LOGGER.log(Level.WARNING, "SNA-- RocksDB Aborting Stream");
            streamExecutor.abortStream();
        }
    }

    static boolean executeRemoteUntar(String data) throws Exception {
        LOGGER.log(Level.INFO, "SNA-- sending remote untar request");
        WCPRequest req = new WCPRequest("grid/rocksdbuntar");
        req.setData(data);
        WCPFuture future = WCPDispatcher.sendRequest("rocksdbconpool", ARManager.getARIp(), req, null);
        WCPResponse res = future.get();
        LOGGER.log(Level.INFO, "SNA-- remote untar response:{0}", res.getResponseData());
        return res.getResponseData().equals("success");
    }

    static boolean executeRemoteRocksDBInit() throws Exception {
        LOGGER.log(Level.INFO, "SNA-- sending remote init request");
        WCPRequest req = new WCPRequest("grid/rocksdbinit");
        WCPFuture future = WCPDispatcher.sendRequest("rocksdbconpool", ARManager.getARIp(), req, null);
        WCPResponse res = future.get();
        LOGGER.log(Level.INFO, "SNA-- remote rocksdb init and restore response:{0}", res.getResponseData());
        return res.getResponseData().equals("success");
    }

    private static boolean getWriteAck() throws Exception {
        LOGGER.log(Level.INFO, "SNA-- requesting write ack");
        WCPRequest req = new WCPRequest("grid/rocksdback");
        WCPFuture future = WCPDispatcher.sendRequest("rocksdbconpool", ARManager.getARIp(), req, null);
        WCPResponse res = future.get();
        LOGGER.log(Level.INFO, "SNA-- write ack response:{0}", res.getResponseData());
        return res.getResponseData().equals("success");
    }

    static boolean verifyRecord(String verificationValue) throws Exception {
        LOGGER.log(Level.INFO, "SNA-- requesting Verification record");
        WCPRequest req = new WCPRequest("grid/rocksdbverifyrecord");
        WCPFuture future = WCPDispatcher.sendRequest("rocksdbconpool", ARManager.getARIp(), req, null);
        WCPResponse res = future.get();
        LOGGER.log(Level.INFO, "SNA-- OLD Server verification value:{0}", verificationValue);
        LOGGER.log(Level.INFO, "SNA-- NEW Server verification value:{0}", res.getResponseData());
        return verificationValue.equals(res.getResponseData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyRestoreComplete(int status) {
        restoreStatus = status;
        Object object = restoreLock;
        synchronized (object) {
            restoreLock.notify();
        }
    }

    public static void setStreamBatchSize(int streamBatchSize) {
        RocksDBCommunicator.streamBatchSize = streamBatchSize;
    }

    public static void setBufferSize(int size) {
        transferBufferSize = size;
    }

    public static int getBufferSize() {
        return transferBufferSize;
    }

    public static void setNIOClientThreadCount(int maxThreadsForIncrementalBackup) {
        nioClientThreadCount = maxThreadsForIncrementalBackup;
    }

    public static long getLatestSequenceNumber() throws Exception {
        WCPRequest req = new WCPRequest("grid/rocksdbseqno");
        WCPFuture future = WCPDispatcher.sendRequest("rocksdbconpool", ARManager.getARIp(), req, null);
        WCPResponse res = future.get();
        return Long.parseLong(res.getResponseData());
    }

    public static void close() {
        try {
            LOGGER.log(Level.INFO, "SNA-- reinitailizing nio ");
            NIONetDataProcessor.shutdown();
            NetworkEventProcessor.shutdown();
            EventDispatcher.shutdown();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "SNA-- Exception while reinitailizing nio ", e);
        }
    }

    static {
        streamBatchSize = 100;
        nioClientThreadCount = 5;
    }

    private static class RocksDBStreamExecutor
    implements Callable<Boolean> {
        RocksDBDTConnection rocksDBDTCon = new RocksDBDTConnection();
        private long checkpoint = -1L;
        private int checkpointCounter = 0;

        private RocksDBStreamExecutor() {
        }

        @Override
        public Boolean call() {
            try {
                this.rocksDBDTCon.init(ARManager.getARIp() + ":7070", new RocksDBWSHandler(this.rocksDBDTCon), true);
                long latestSeqNo = 0L;
                boolean allDataSent = false;
                long walStreamStartTime = System.currentTimeMillis();
                while (streamFlag || !allDataSent) {
                    long curSeqNo = 0L;
                    if (!this.isCheckpointValid()) {
                        LOGGER.log(Level.WARNING, "SNA-- Failed to send WAL data after 3 retries");
                        return false;
                    }
                    latestSeqNo = this.checkpoint == -1L ? RocksDBCommunicator.getLatestSequenceNumber() : this.checkpoint;
                    if (RocksDBManager.getLatestSequenceNumber() == latestSeqNo) continue;
                    TransactionLogIterator walIter = RocksDBManager.getUpdatesSince(latestSeqNo + 1L);
                    LOGGER.log(Level.INFO, "SEQ-- OLD SERVER Latest Sequence number {0}", RocksDBManager.getLatestSequenceNumber());
                    LOGGER.log(Level.INFO, "SEQ-- NEW SERVER Latest Sequence number {0}", latestSeqNo);
                    if (!streamFlag) {
                        RocksDBARModule.updateProgress(String.format("%d Records Left", RocksDBManager.getLatestSequenceNumber() - this.rocksDBDTCon.getLastReceivedSeqNo()), "100");
                    }
                    this.rocksDBDTCon.startBatch(streamBatchSize);
                    while (walIter.isValid()) {
                        TransactionLogIterator.BatchResult batchResult = walIter.getBatch();
                        curSeqNo = batchResult.sequenceNumber();
                        byte[] batchData = batchResult.writeBatch().data();
                        ByteBuffer byteBuffer = ByteBuffer.allocate(batchData.length + 8);
                        byteBuffer.putLong(curSeqNo);
                        byteBuffer.put(batchData);
                        if (this.rocksDBDTCon.write(byteBuffer.array(), curSeqNo)) break;
                        walIter.next();
                    }
                    if (this.rocksDBDTCon.awaitBatchCompletion()) {
                        this.checkpoint = -1L;
                    } else {
                        LOGGER.log(Level.WARNING, "SNA-- WAL data failed to send");
                        this.checkpoint = this.rocksDBDTCon.getLastReceivedSeqNo();
                    }
                    allDataSent = this.rocksDBDTCon.getLastReceivedSeqNo() == RocksDBManager.getLatestSequenceNumber();
                }
                long walStreamTime = System.currentTimeMillis() - walStreamStartTime;
                StatsDB.addData("rocksdbar", "walstreamtime", DC.getServertype(), walStreamTime);
                RocksDBARModule.updateStatus("WAL Stream time", walStreamTime);
                RocksDBARModule.updateStatus("Total WAL records sent", this.rocksDBDTCon.getTotalSentCount());
                RocksDBARModule.setNumRecordsSent(this.rocksDBDTCon.getTotalSentCount());
                this.rocksDBDTCon.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "SNA-- Exception while streaming RocksDB WAL", e);
                return false;
            }
            return true;
        }

        void abortStream() {
            this.rocksDBDTCon.close();
        }

        boolean isCheckpointValid() {
            if (this.checkpoint == -1L) {
                return true;
            }
            ++this.checkpointCounter;
            return this.checkpointCounter <= 3;
        }
    }
}

